/*
 * Copyright 2015 Andrew T. Flowers, K0SM
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package dopplerpsk.util;

/**
 * SQF represents the frequency information in a satellite.
 * 
 * @author Andrew T. Flowers
 */
public class Sqf {

        private final boolean rev;
        private final double uplinkHz;
        private final double downlinkHz;
        private final String name;

        public Sqf(String name, double downlinkHz, double uplinkHz, boolean rev) {

            this.name = name;
            this.downlinkHz = downlinkHz;
            this.uplinkHz = uplinkHz;
            this.rev = rev;

        }

        /**
         * @return the rev
         */
        public boolean isRev() {
            return rev;
        }

        /**
         * @return the uplinkHz
         */
        public double getUplinkHz() {
            return uplinkHz;
        }

        /**
         * @return the downlinkHz
         */
        public double getDownlinkHz() {
            return downlinkHz;
        }

        /**
         * @return the name
         */
        public String getName() {
            return name;
        }

    }