/*
 * Copyright 2015 Andrew T. Flowers, K0SM.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package dopplerpsk.ui;

import dopplerpsk.Macro;
import dopplerpsk.event.IMessageChangedListener;
import javax.swing.ButtonGroup;

/**
 *
 * @author Andrew
 */
public class MessagePanel extends javax.swing.JPanel {

    private Macro macro;
    private String mycall;
    private String dxcall;
    private String exchange;
    private IMessageChangedListener messageChangedListener;

    /**
     * Default constructor.
     */
    public MessagePanel() {
        initComponents();
    }

    public MessagePanel(Macro m, ButtonGroup bg, String mycall, String dxcall, String exchange, IMessageChangedListener l) {
        this.mycall = mycall;
        this.dxcall = dxcall;
        this.exchange = exchange;
        this.messageChangedListener = l;
        initComponents();
        initialize(m);
        bg.add(selectButton);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        messageTextField = new javax.swing.JTextField();
        selectButton = new javax.swing.JRadioButton();

        selectButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                selectButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(messageTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 403, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(selectButton)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                .addComponent(messageTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(selectButton))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void selectButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_selectButtonActionPerformed
        if (this.selectButton.isSelected()) {
            if (messageChangedListener != null) {
                messageChangedListener.messageChanged(getFormattedMessage());
            }
        }
    }//GEN-LAST:event_selectButtonActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField messageTextField;
    private javax.swing.JRadioButton selectButton;
    // End of variables declaration//GEN-END:variables

    private void initialize(Macro m) {
        this.macro = m;

        this.messageTextField.setText(formatMessage(m.getText()));
    }

    public String getFormattedMessage() {
        return messageTextField.getText();
    }

    public boolean isSelected() {
        return selectButton.isSelected();
    }

    public void update(String myCall, String dxCall, String exchange) {
        this.mycall = myCall;
        this.dxcall = dxCall;
        this.exchange = exchange;
        this.messageTextField.setText(formatMessage(macro.getText()));
    }

    private String formatMessage(String text) {
        text = text.replaceAll("MYCALL", mycall);
        text = text.replaceAll("DXCALL", dxcall);
        text = text.replaceAll("EXCHANGE", exchange);
        return text;
    }

}
