/*
 * Copyright 2015 Andrew T. Flowers, K0SM
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package dopplerpsk.event;


/**
 * Interface for classes that create satellite events.
 * 
 * @author Andrew T. Flowers
 */
public interface ISatelliteEventSource {
    void start();
    void stop();

    public void addEventListener(ISatelliteEventSink snk);

    public void removeEventListener(ISatelliteEventSink snk);
}
