/*
 * Copyright 2015 Andrew T. Flowers, K0SM
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package dopplerpsk.dsp;

/**
 *
 *  The mixer mixes the 31.25Hz baseband signal with the LO to generate a PSK
 *  signal.
 * 
 * @author Andrew T. Flowers
 */
public class Mixer {

    private final LocalOscillator lo;

    public Mixer(LocalOscillator lo) {
        this.lo = lo;
    }

    /**
     * Gets the mixed (time-domain product) of LO and input sample.
     * 
     * @param sample baseband modulation
     * @return product
     */
    public double mix(double sample) {
        return lo.getNextSample() * sample;
    }

    /**
     * Gets the mixed (time-domain product) of LO and input samples.
     * 
     * @param samples baseband modulation
     * 
     * @return product
     */
    public double[] mix(double[] samples) {
        double[] rVal = new double[samples.length];
        for (int i = 0; i < samples.length; i++) {
            rVal[i] = lo.getNextSample() * samples[i];
        }
        return rVal;
    }

}
