/*
 * Copyright 2015 Andrew T. Flowers, K0SM
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package dopplerpsk;

/**
 * Represents a preset message for transmission.
 * @author Andrew T. Flowers
 */
public class Macro {
    
    private final String text;
    
    public Macro(String text) {
        this.text = text;
    }


    /**
     * The text content of the message to be sent over the air
     * @return the text
     */
    public String getText() {
        return text;
    }

}
