/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.geometry.euclidean.threed.FieldRotation;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.util.Pair;
import org.orekit.errors.OrekitException;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeShiftable;
import org.orekit.utils.AngularCoordinates;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class FieldAngularCoordinates<T extends RealFieldElement<T>>
implements TimeShiftable<FieldAngularCoordinates<T>>,
Serializable {
    private static final long serialVersionUID = 20140414L;
    private final FieldRotation<T> rotation;
    private final FieldVector3D<T> rotationRate;
    private final FieldVector3D<T> rotationAcceleration;

    public FieldAngularCoordinates(FieldRotation<T> rotation, FieldVector3D<T> rotationRate) {
        this(rotation, rotationRate, new FieldVector3D((RealFieldElement)rotation.getQ0().getField().getZero(), (RealFieldElement)rotation.getQ0().getField().getZero(), (RealFieldElement)rotation.getQ0().getField().getZero()));
    }

    public FieldAngularCoordinates(FieldRotation<T> rotation, FieldVector3D<T> rotationRate, FieldVector3D<T> rotationAcceleration) {
        this.rotation = rotation;
        this.rotationRate = rotationRate;
        this.rotationAcceleration = rotationAcceleration;
    }

    public static <T extends RealFieldElement<T>> FieldVector3D<T> estimateRate(FieldRotation<T> start, FieldRotation<T> end, double dt) {
        FieldRotation evolution = start.applyTo(end.revert());
        return new FieldVector3D((RealFieldElement)evolution.getAngle().divide(dt), evolution.getAxis());
    }

    public FieldAngularCoordinates<T> revert() {
        return new FieldAngularCoordinates<T>(this.rotation.revert(), this.rotation.applyInverseTo(this.rotationRate.negate()), this.rotation.applyInverseTo(this.rotationAcceleration.negate()));
    }

    @Override
    public FieldAngularCoordinates<T> shiftedBy(double dt) {
        RealFieldElement rate = this.rotationRate.getNorm();
        RealFieldElement zero = (RealFieldElement)rate.getField().getZero();
        RealFieldElement one = (RealFieldElement)rate.getField().getOne();
        FieldRotation rateContribution = rate.getReal() == 0.0 ? new FieldRotation(one, zero, zero, zero, false) : new FieldRotation(this.rotationRate, (RealFieldElement)rate.multiply(-dt));
        FieldAngularCoordinates<T> linearPart = new FieldAngularCoordinates<T>(rateContribution.applyTo(this.rotation), this.rotationRate);
        RealFieldElement acc = this.rotationAcceleration.getNorm();
        if (acc.getReal() == 0.0) {
            return linearPart;
        }
        FieldAngularCoordinates<T> quadraticContribution = new FieldAngularCoordinates<T>(new FieldRotation(this.rotationAcceleration, (RealFieldElement)acc.multiply(-0.5 * dt * dt)), new FieldVector3D(dt, this.rotationAcceleration), this.rotationAcceleration);
        return quadraticContribution.addOffset(linearPart);
    }

    public FieldRotation<T> getRotation() {
        return this.rotation;
    }

    public FieldVector3D<T> getRotationRate() {
        return this.rotationRate;
    }

    public FieldVector3D<T> getRotationAcceleration() {
        return this.rotationAcceleration;
    }

    public FieldAngularCoordinates<T> addOffset(FieldAngularCoordinates<T> offset) {
        FieldVector3D rOmega = this.rotation.applyTo(offset.rotationRate);
        FieldVector3D rOmegaDot = this.rotation.applyTo(offset.rotationAcceleration);
        return new FieldAngularCoordinates<T>(this.rotation.applyTo(offset.rotation), this.rotationRate.add(rOmega), new FieldVector3D(1.0, this.rotationAcceleration, 1.0, rOmegaDot, -1.0, FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)rOmega)));
    }

    public FieldAngularCoordinates<T> subtractOffset(FieldAngularCoordinates<T> offset) {
        return this.addOffset(offset.revert());
    }

    public AngularCoordinates toAngularCoordinates() {
        return new AngularCoordinates(this.rotation.toRotation(), this.rotationRate.toVector3D(), this.rotationAcceleration.toVector3D());
    }

    @Deprecated
    public static <T extends RealFieldElement<T>> FieldAngularCoordinates<T> interpolate(AbsoluteDate date, boolean useRotationRates, Collection<Pair<AbsoluteDate, FieldAngularCoordinates<T>>> sample) throws OrekitException {
        ArrayList list = new ArrayList(sample.size());
        for (Pair<AbsoluteDate, FieldAngularCoordinates<T>> pair : sample) {
            list.add(new TimeStampedFieldAngularCoordinates<T>((AbsoluteDate)pair.getFirst(), ((FieldAngularCoordinates)pair.getSecond()).getRotation(), ((FieldAngularCoordinates)pair.getSecond()).getRotationRate(), ((FieldAngularCoordinates)pair.getSecond()).getRotationAcceleration()));
        }
        return TimeStampedFieldAngularCoordinates.interpolate(date, useRotationRates ? AngularDerivativesFilter.USE_RR : AngularDerivativesFilter.USE_R, list);
    }
}

