/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.apache.commons.math3.util.FastMath;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;

public class TDBScale
implements TimeScale {
    private static final long serialVersionUID = 20131209L;

    TDBScale() {
    }

    @Override
    public double offsetFromTAI(AbsoluteDate date) {
        double dtDays = date.durationFrom(AbsoluteDate.J2000_EPOCH) / 86400.0;
        double g = FastMath.toRadians((double)(357.53 + 0.9856003 * dtDays));
        return TimeScalesFactory.getTT().offsetFromTAI(date) + (0.001658 * FastMath.sin((double)g) + 1.4E-5 * FastMath.sin((double)(2.0 * g)));
    }

    @Override
    public double offsetToTAI(DateComponents date, TimeComponents time) {
        AbsoluteDate reference = new AbsoluteDate(date, time, (TimeScale)TimeScalesFactory.getTAI());
        double offset = 0.0;
        for (int i = 0; i < 3; ++i) {
            offset = -this.offsetFromTAI(reference.shiftedBy(offset));
        }
        return offset;
    }

    @Override
    public String getName() {
        return "TDB";
    }

    public String toString() {
        return this.getName();
    }
}

