/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.complex.Complex;

public class CjSjCoefficient {
    private int jLast;
    private final Complex kih;
    private final List<Complex> cjsj;

    public CjSjCoefficient(double k, double h) {
        this.kih = new Complex(k, h);
        this.cjsj = new ArrayList<Complex>();
        this.cjsj.add(new Complex(1.0, 0.0));
        this.cjsj.add(this.kih);
        this.jLast = 1;
    }

    public double getCj(int j) {
        if (j > this.jLast) {
            this.updateCjSj(j);
        }
        return this.cjsj.get(j).getReal();
    }

    public double getSj(int j) {
        if (j > this.jLast) {
            this.updateCjSj(j);
        }
        return this.cjsj.get(j).getImaginary();
    }

    public double getDcjDk(int j) {
        return j == 0 ? 0.0 : (double)j * this.getCj(j - 1);
    }

    public double getDsjDk(int j) {
        return j == 0 ? 0.0 : (double)j * this.getSj(j - 1);
    }

    public double getDcjDh(int j) {
        return j == 0 ? 0.0 : (double)(-j) * this.getSj(j - 1);
    }

    public double getDsjDh(int j) {
        return j == 0 ? 0.0 : (double)j * this.getCj(j - 1);
    }

    private void updateCjSj(int j) {
        Complex last = this.cjsj.get(this.cjsj.size() - 1);
        for (int i = this.jLast; i < j; ++i) {
            Complex next = last.multiply(this.kih);
            this.cjsj.add(next);
            last = next;
        }
        this.jLast = j;
    }
}

