/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.CoefficientsFactory;
import org.orekit.propagation.semianalytical.dsst.utilities.GHmsjPolynomials;
import org.orekit.propagation.semianalytical.dsst.utilities.GammaMnsFunction;
import org.orekit.propagation.semianalytical.dsst.utilities.JacobiPolynomials;
import org.orekit.propagation.semianalytical.dsst.utilities.ShortPeriodicsInterpolatedCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.HansenTesseralLinear;
import org.orekit.time.AbsoluteDate;

class TesseralContribution
implements DSSTForceModel {
    private static final double MIN_PERIOD_IN_SECONDS = 864000.0;
    private static final double MIN_PERIOD_IN_SAT_REV = 10.0;
    private static final int INTERPOLATION_POINTS = 3;
    private static final int MAXJ = 12;
    private static final int MAX_DEGREE_TESSERAL_SP = 8;
    private static final int MAX_DEGREE_MDAILY_TESSERAL_SP = 12;
    private static final int MAX_ORDER_TESSERAL_SP = 8;
    private static final int MAX_ORDER_MDAILY_TESSERAL_SP = 12;
    private static final int MAX_ECCPOWER_SP = 4;
    private final UnnormalizedSphericalHarmonicsProvider provider;
    private final Frame bodyFrame;
    private final double centralBodyRotationRate;
    private final double bodyPeriod;
    private final int maxDegree;
    private final int maxDegreeTesseralSP;
    private final int maxDegreeMdailyTesseralSP;
    private final int maxOrder;
    private final int maxOrderTesseralSP;
    private final int maxOrderMdailyTesseralSP;
    private final List<Integer> resOrders;
    private final double[] fact;
    private int maxEccPow;
    private int maxEccPowTesseralSP;
    private int maxEccPowMdailyTesseralSP;
    private int maxHansen;
    private double orbitPeriod;
    private double ratio;
    private int I;
    private double a;
    private double k;
    private double h;
    private double q;
    private double p;
    private double lm;
    private double ecc;
    private double chi;
    private double chi2;
    private Vector3D f;
    private Vector3D g;
    private double theta;
    private double alpha;
    private double beta;
    private double gamma;
    private double ax2oA;
    private double ooAB;
    private double BoA;
    private double BoABpo;
    private double Co2AB;
    private double moa;
    private double roa;
    private double e2;
    private double meanMotion;
    private final boolean mDailiesOnly;
    private int jMax;
    private final SortedMap<Integer, List<Integer>> nonResOrders;
    private HansenTesseralLinear[][] hansenObjects;
    private TesseralShortPeriodicCoefficients tesseralSPCoefs;
    private Frame frame;

    public TesseralContribution(Frame centralBodyFrame, double centralBodyRotationRate, UnnormalizedSphericalHarmonicsProvider provider, boolean mDailiesOnly) {
        this.bodyFrame = centralBodyFrame;
        this.centralBodyRotationRate = centralBodyRotationRate;
        this.bodyPeriod = Math.PI * 2 / centralBodyRotationRate;
        this.provider = provider;
        this.maxDegree = provider.getMaxDegree();
        this.maxOrder = provider.getMaxOrder();
        this.maxDegreeTesseralSP = FastMath.min((int)this.maxDegree, (int)8);
        this.maxDegreeMdailyTesseralSP = FastMath.min((int)this.maxDegree, (int)12);
        this.maxOrderTesseralSP = FastMath.min((int)this.maxOrder, (int)8);
        this.maxOrderMdailyTesseralSP = FastMath.min((int)this.maxOrder, (int)12);
        this.maxEccPowTesseralSP = 4;
        this.maxEccPowMdailyTesseralSP = FastMath.min((int)(this.maxDegreeMdailyTesseralSP - 2), (int)4);
        this.jMax = FastMath.min((int)12, (int)(this.maxDegreeTesseralSP + this.maxEccPowTesseralSP));
        this.mDailiesOnly = mDailiesOnly;
        this.resOrders = new ArrayList<Integer>();
        this.nonResOrders = new TreeMap<Integer, List<Integer>>();
        this.maxEccPow = 0;
        this.maxHansen = 0;
        int maxFact = 2 * this.maxDegree + 1;
        this.fact = new double[maxFact];
        this.fact[0] = 1.0;
        for (int i = 1; i < maxFact; ++i) {
            this.fact[i] = (double)i * this.fact[i - 1];
        }
    }

    @Override
    public void initialize(AuxiliaryElements aux, boolean meanOnly) throws OrekitException {
        this.orbitPeriod = aux.getKeplerianPeriod();
        this.frame = aux.getFrame();
        double e = aux.getEcc();
        this.maxEccPow = e <= 0.005 ? 3 : (e <= 0.02 ? 4 : (e <= 0.1 ? 7 : (e <= 0.2 ? 10 : (e <= 0.3 ? 12 : (e <= 0.4 ? 15 : 20)))));
        this.maxHansen = this.maxEccPow / 2;
        this.jMax = FastMath.min((int)12, (int)(this.maxDegree + this.maxEccPow));
        this.ratio = this.orbitPeriod / this.bodyPeriod;
        this.getResonantAndNonResonantTerms(meanOnly);
        this.createHansenObjects(meanOnly);
        if (!meanOnly) {
            this.tesseralSPCoefs = new TesseralShortPeriodicCoefficients(this.jMax, FastMath.max((int)this.maxOrderTesseralSP, (int)this.maxOrderMdailyTesseralSP), 3);
        }
    }

    private void createHansenObjects(boolean meanOnly) {
        this.hansenObjects = new HansenTesseralLinear[2 * this.maxDegree + 1][this.jMax + 1];
        if (meanOnly) {
            for (int m : this.resOrders) {
                int j = FastMath.max((int)1, (int)((int)FastMath.round((double)(this.ratio * (double)m))));
                int sMin = FastMath.min((int)(this.maxEccPow - j), (int)this.maxDegree);
                int sMax = FastMath.min((int)(this.maxEccPow + j), (int)this.maxDegree);
                for (int s = 0; s <= sMax; ++s) {
                    int n0 = FastMath.max((int)FastMath.max((int)2, (int)m), (int)s);
                    this.hansenObjects[s + this.maxDegree][j] = new HansenTesseralLinear(this.maxDegree, s, j, n0, this.maxHansen);
                    if (s <= 0 || s > sMin) continue;
                    this.hansenObjects[this.maxDegree - s][j] = new HansenTesseralLinear(this.maxDegree, -s, j, n0, this.maxHansen);
                }
            }
        } else {
            for (int j = 0; j <= this.jMax; ++j) {
                for (int s = -this.maxDegree; s <= this.maxDegree; ++s) {
                    int n0 = FastMath.max((int)2, (int)FastMath.abs((int)s));
                    this.hansenObjects[s + this.maxDegree][j] = new HansenTesseralLinear(this.maxDegree, s, j, n0, this.maxHansen);
                }
            }
        }
    }

    @Override
    public void initializeStep(AuxiliaryElements aux) throws OrekitException {
        this.a = aux.getSma();
        this.k = aux.getK();
        this.h = aux.getH();
        this.q = aux.getQ();
        this.p = aux.getP();
        this.lm = aux.getLM();
        this.ecc = aux.getEcc();
        this.e2 = this.ecc * this.ecc;
        this.I = aux.getRetrogradeFactor();
        this.f = aux.getVectorF();
        this.g = aux.getVectorG();
        Transform t = this.bodyFrame.getTransformTo(aux.getFrame(), aux.getDate());
        Vector3D xB = t.transformVector(Vector3D.PLUS_I);
        Vector3D yB = t.transformVector(Vector3D.PLUS_J);
        this.theta = FastMath.atan2((double)(-this.f.dotProduct((Vector)yB) + (double)this.I * this.g.dotProduct((Vector)xB)), (double)(this.f.dotProduct((Vector)xB) + (double)this.I * this.g.dotProduct((Vector)yB)));
        this.alpha = aux.getAlpha();
        this.beta = aux.getBeta();
        this.gamma = aux.getGamma();
        double A = aux.getA();
        double B = aux.getB();
        double C = aux.getC();
        this.ax2oA = 2.0 * this.a / A;
        this.BoA = B / A;
        this.ooAB = 1.0 / (A * B);
        this.Co2AB = C * this.ooAB / 2.0;
        this.BoABpo = this.BoA / (1.0 + B);
        this.moa = this.provider.getMu() / this.a;
        this.roa = this.provider.getAe() / this.a;
        this.chi = 1.0 / B;
        this.chi2 = this.chi * this.chi;
        this.meanMotion = aux.getMeanMotion();
    }

    @Override
    public double[] getMeanElementRate(SpacecraftState spacecraftState) throws OrekitException {
        double[] dU = this.computeUDerivatives(spacecraftState.getDate());
        double dUda = dU[0];
        double dUdh = dU[1];
        double dUdk = dU[2];
        double dUdl = dU[3];
        double dUdAl = dU[4];
        double dUdBe = dU[5];
        double dUdGa = dU[6];
        double UAlphaGamma = this.alpha * dUdGa - this.gamma * dUdAl;
        double UAlphaBeta = this.alpha * dUdBe - this.beta * dUdAl;
        double UBetaGamma = this.beta * dUdGa - this.gamma * dUdBe;
        double Uhk = this.h * dUdk - this.k * dUdh;
        double pUagmIqUbgoAB = (this.p * UAlphaGamma - (double)this.I * this.q * UBetaGamma) * this.ooAB;
        double UhkmUabmdUdl = Uhk - UAlphaBeta - dUdl;
        double da = this.ax2oA * dUdl;
        double dh = this.BoA * dUdk + this.k * pUagmIqUbgoAB - this.h * this.BoABpo * dUdl;
        double dk = -(this.BoA * dUdh + this.h * pUagmIqUbgoAB + this.k * this.BoABpo * dUdl);
        double dp = this.Co2AB * (this.p * UhkmUabmdUdl - UBetaGamma);
        double dq = this.Co2AB * (this.q * UhkmUabmdUdl - (double)this.I * UAlphaGamma);
        double dM = -this.ax2oA * dUda + this.BoABpo * (this.h * dUdh + this.k * dUdk) + pUagmIqUbgoAB;
        return new double[]{da, dk, dh, dq, dp, dM};
    }

    @Override
    public double[] getShortPeriodicVariations(AbsoluteDate date, double[] meanElements) throws OrekitException {
        double[] shortPeriodicVariation = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        if (!this.nonResOrders.isEmpty() || this.mDailiesOnly) {
            Orbit meanOrbit = OrbitType.EQUINOCTIAL.mapArrayToOrbit(meanElements, PositionAngle.MEAN, date, this.provider.getMu(), this.frame);
            AuxiliaryElements aux = new AuxiliaryElements(meanOrbit, this.I);
            Transform t = this.bodyFrame.getTransformTo(aux.getFrame(), aux.getDate());
            Vector3D xB = t.transformVector(Vector3D.PLUS_I);
            Vector3D yB = t.transformVector(Vector3D.PLUS_J);
            double currentTheta = FastMath.atan2((double)(-this.f.dotProduct((Vector)yB) + (double)this.I * this.g.dotProduct((Vector)xB)), (double)(this.f.dotProduct((Vector)xB) + (double)this.I * this.g.dotProduct((Vector)yB)));
            for (int m = 1; m <= this.maxOrderMdailyTesseralSP; ++m) {
                double jlMmt = (double)(-m) * currentTheta;
                double sinPhi = FastMath.sin((double)jlMmt);
                double cosPhi = FastMath.cos((double)jlMmt);
                for (int i = 0; i < 6; ++i) {
                    int n = i;
                    shortPeriodicVariation[n] = shortPeriodicVariation[n] + (this.tesseralSPCoefs.getCijm(i, 0, m, date) * cosPhi + this.tesseralSPCoefs.getSijm(i, 0, m, date) * sinPhi);
                }
            }
            for (int m : this.nonResOrders.keySet()) {
                List listJ = (List)this.nonResOrders.get(m);
                Iterator i$ = listJ.iterator();
                while (i$.hasNext()) {
                    int j = (Integer)i$.next();
                    double jlMmt = (double)j * meanElements[5] - (double)m * currentTheta;
                    double sinPhi = FastMath.sin((double)jlMmt);
                    double cosPhi = FastMath.cos((double)jlMmt);
                    for (int i = 0; i < 6; ++i) {
                        int n = i;
                        shortPeriodicVariation[n] = shortPeriodicVariation[n] + (this.tesseralSPCoefs.getCijm(i, j, m, date) * cosPhi + this.tesseralSPCoefs.getSijm(i, j, m, date) * sinPhi);
                    }
                }
            }
        }
        return shortPeriodicVariation;
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return null;
    }

    @Override
    public void computeShortPeriodicsCoefficients(SpacecraftState state) throws OrekitException {
        for (int s = -this.maxDegree; s <= this.maxDegree; ++s) {
            this.hansenObjects[s + this.maxDegree][0].computeInitValues(this.e2, this.chi, this.chi2);
            if (this.mDailiesOnly) continue;
            for (int j = 1; j <= this.jMax; ++j) {
                this.hansenObjects[s + this.maxDegree][j].computeInitValues(this.e2, this.chi, this.chi2);
            }
        }
        this.tesseralSPCoefs.computeCoefficients(state.getDate());
    }

    private void getResonantAndNonResonantTerms(boolean resonantOnly) {
        double tolerance = 1.0 / FastMath.max((double)10.0, (double)(864000.0 / this.orbitPeriod));
        this.resOrders.clear();
        this.nonResOrders.clear();
        for (int m = 1; m <= this.maxOrder; ++m) {
            double resonance = this.ratio * (double)m;
            int jRes = 0;
            int jComputedRes = (int)FastMath.round((double)resonance);
            if (jComputedRes > 0 && jComputedRes <= this.jMax && FastMath.abs((double)(resonance - (double)jComputedRes)) <= tolerance) {
                this.resOrders.add(m);
                jRes = jComputedRes;
            }
            if (resonantOnly || this.mDailiesOnly || m > this.maxOrderTesseralSP) continue;
            ArrayList<Integer> listJofM = new ArrayList<Integer>();
            for (int j = -this.jMax; j <= this.jMax; ++j) {
                if (j == 0 || j == jRes) continue;
                listJofM.add(j);
            }
            this.nonResOrders.put(m, listJofM);
        }
    }

    private double[] computeUDerivatives(AbsoluteDate date) throws OrekitException {
        double dUda = 0.0;
        double dUdh = 0.0;
        double dUdk = 0.0;
        double dUdl = 0.0;
        double dUdAl = 0.0;
        double dUdBe = 0.0;
        double dUdGa = 0.0;
        if (!this.resOrders.isEmpty()) {
            GHmsjPolynomials ghMSJ = new GHmsjPolynomials(this.k, this.h, this.alpha, this.beta, this.I);
            GammaMnsFunction gammaMNS = new GammaMnsFunction(this.fact, this.gamma, this.I);
            double[] roaPow = new double[this.maxDegree + 1];
            roaPow[0] = 1.0;
            for (int i = 1; i <= this.maxDegree; ++i) {
                roaPow[i] = this.roa * roaPow[i - 1];
            }
            for (int m : this.resOrders) {
                int j = FastMath.max((int)1, (int)((int)FastMath.round((double)(this.ratio * (double)m))));
                double jlMmt = (double)j * this.lm - (double)m * this.theta;
                double sinPhi = FastMath.sin((double)jlMmt);
                double cosPhi = FastMath.cos((double)jlMmt);
                double dUdaCos = 0.0;
                double dUdaSin = 0.0;
                double dUdhCos = 0.0;
                double dUdhSin = 0.0;
                double dUdkCos = 0.0;
                double dUdkSin = 0.0;
                double dUdlCos = 0.0;
                double dUdlSin = 0.0;
                double dUdAlCos = 0.0;
                double dUdAlSin = 0.0;
                double dUdBeCos = 0.0;
                double dUdBeSin = 0.0;
                double dUdGaCos = 0.0;
                double dUdGaSin = 0.0;
                int sMin = FastMath.min((int)(this.maxEccPow - j), (int)this.maxDegree);
                int sMax = FastMath.min((int)(this.maxEccPow + j), (int)this.maxDegree);
                for (int s = 0; s <= sMax; ++s) {
                    this.hansenObjects[s + this.maxDegree][j].computeInitValues(this.e2, this.chi, this.chi2);
                    double[][] nSumSpos = this.computeNSum(date, j, m, s, this.maxDegree, roaPow, ghMSJ, gammaMNS);
                    dUdaCos += nSumSpos[0][0];
                    dUdaSin += nSumSpos[0][1];
                    dUdhCos += nSumSpos[1][0];
                    dUdhSin += nSumSpos[1][1];
                    dUdkCos += nSumSpos[2][0];
                    dUdkSin += nSumSpos[2][1];
                    dUdlCos += nSumSpos[3][0];
                    dUdlSin += nSumSpos[3][1];
                    dUdAlCos += nSumSpos[4][0];
                    dUdAlSin += nSumSpos[4][1];
                    dUdBeCos += nSumSpos[5][0];
                    dUdBeSin += nSumSpos[5][1];
                    dUdGaCos += nSumSpos[6][0];
                    dUdGaSin += nSumSpos[6][1];
                    if (s <= 0 || s > sMin) continue;
                    this.hansenObjects[this.maxDegree - s][j].computeInitValues(this.e2, this.chi, this.chi2);
                    double[][] nSumSneg = this.computeNSum(date, j, m, -s, this.maxDegree, roaPow, ghMSJ, gammaMNS);
                    dUdaCos += nSumSneg[0][0];
                    dUdaSin += nSumSneg[0][1];
                    dUdhCos += nSumSneg[1][0];
                    dUdhSin += nSumSneg[1][1];
                    dUdkCos += nSumSneg[2][0];
                    dUdkSin += nSumSneg[2][1];
                    dUdlCos += nSumSneg[3][0];
                    dUdlSin += nSumSneg[3][1];
                    dUdAlCos += nSumSneg[4][0];
                    dUdAlSin += nSumSneg[4][1];
                    dUdBeCos += nSumSneg[5][0];
                    dUdBeSin += nSumSneg[5][1];
                    dUdGaCos += nSumSneg[6][0];
                    dUdGaSin += nSumSneg[6][1];
                }
                dUda += cosPhi * dUdaCos + sinPhi * dUdaSin;
                dUdh += cosPhi * dUdhCos + sinPhi * dUdhSin;
                dUdk += cosPhi * dUdkCos + sinPhi * dUdkSin;
                dUdl += cosPhi * dUdlCos + sinPhi * dUdlSin;
                dUdAl += cosPhi * dUdAlCos + sinPhi * dUdAlSin;
                dUdBe += cosPhi * dUdBeCos + sinPhi * dUdBeSin;
                dUdGa += cosPhi * dUdGaCos + sinPhi * dUdGaSin;
            }
            dUda *= -this.moa / this.a;
            dUdh *= this.moa;
            dUdk *= this.moa;
            dUdl *= this.moa;
            dUdAl *= this.moa;
            dUdBe *= this.moa;
            dUdGa *= this.moa;
        }
        return new double[]{dUda, dUdh, dUdk, dUdl, dUdAl, dUdBe, dUdGa};
    }

    private double[][] computeNSum(AbsoluteDate date, int j, int m, int s, int maxN, double[] roaPow, GHmsjPolynomials ghMSJ, GammaMnsFunction gammaMNS) throws OrekitException {
        UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics = this.provider.onDate(date);
        double dUdaCos = 0.0;
        double dUdaSin = 0.0;
        double dUdhCos = 0.0;
        double dUdhSin = 0.0;
        double dUdkCos = 0.0;
        double dUdkSin = 0.0;
        double dUdlCos = 0.0;
        double dUdlSin = 0.0;
        double dUdAlCos = 0.0;
        double dUdAlSin = 0.0;
        double dUdBeCos = 0.0;
        double dUdBeSin = 0.0;
        double dUdGaCos = 0.0;
        double dUdGaSin = 0.0;
        int Im = this.I > 0 ? 1 : (m % 2 == 0 ? 1 : -1);
        int v = FastMath.abs((int)(m - s));
        int w = FastMath.abs((int)(m + s));
        int nmin = FastMath.max((int)FastMath.max((int)2, (int)m), (int)FastMath.abs((int)s));
        int sIndex = this.maxDegree + (j < 0 ? -s : s);
        int jIndex = FastMath.abs((int)j);
        HansenTesseralLinear hans = this.hansenObjects[sIndex][jIndex];
        for (int n = nmin; n <= maxN; ++n) {
            if ((n - s) % 2 != 0) continue;
            double fns = this.fact[n + FastMath.abs((int)s)];
            double vMNS = CoefficientsFactory.getVmns(m, n, s, fns, this.fact[n - m]);
            double gaMNS = gammaMNS.getValue(m, n, s);
            double dGaMNS = gammaMNS.getDerivative(m, n, s);
            double kJNS = hans.getValue(-n - 1, this.chi);
            double dkJNS = hans.getDerivative(-n - 1, this.chi);
            double gMSJ = ghMSJ.getGmsj(m, s, j);
            double hMSJ = ghMSJ.getHmsj(m, s, j);
            double dGdh = ghMSJ.getdGmsdh(m, s, j);
            double dGdk = ghMSJ.getdGmsdk(m, s, j);
            double dGdA = ghMSJ.getdGmsdAlpha(m, s, j);
            double dGdB = ghMSJ.getdGmsdBeta(m, s, j);
            double dHdh = ghMSJ.getdHmsdh(m, s, j);
            double dHdk = ghMSJ.getdHmsdk(m, s, j);
            double dHdA = ghMSJ.getdHmsdAlpha(m, s, j);
            double dHdB = ghMSJ.getdHmsdBeta(m, s, j);
            int l = FastMath.min((int)(n - m), (int)(n - FastMath.abs((int)s)));
            DerivativeStructure jacobi = JacobiPolynomials.getValue(l, v, w, new DerivativeStructure(1, 1, 0, this.gamma));
            double cnm = harmonics.getUnnormalizedCnm(n, m);
            double snm = harmonics.getUnnormalizedSnm(n, m);
            double cf_0 = roaPow[n] * (double)Im * vMNS;
            double cf_1 = cf_0 * gaMNS * jacobi.getValue();
            double cf_2 = cf_1 * kJNS;
            double gcPhs = gMSJ * cnm + hMSJ * snm;
            double gsMhc = gMSJ * snm - hMSJ * cnm;
            double dKgcPhsx2 = 2.0 * dkJNS * gcPhs;
            double dKgsMhcx2 = 2.0 * dkJNS * gsMhc;
            double dUdaCoef = (double)(n + 1) * cf_2;
            double dUdlCoef = (double)j * cf_2;
            double dUdGaCoef = cf_0 * kJNS * (jacobi.getValue() * dGaMNS + gaMNS * jacobi.getPartialDerivative(new int[]{1}));
            dUdaCos += dUdaCoef * gcPhs;
            dUdaSin += dUdaCoef * gsMhc;
            dUdhCos += cf_1 * (kJNS * (cnm * dGdh + snm * dHdh) + this.h * dKgcPhsx2);
            dUdhSin += cf_1 * (kJNS * (snm * dGdh - cnm * dHdh) + this.h * dKgsMhcx2);
            dUdkCos += cf_1 * (kJNS * (cnm * dGdk + snm * dHdk) + this.k * dKgcPhsx2);
            dUdkSin += cf_1 * (kJNS * (snm * dGdk - cnm * dHdk) + this.k * dKgsMhcx2);
            dUdlCos += dUdlCoef * gsMhc;
            dUdlSin += -dUdlCoef * gcPhs;
            dUdAlCos += cf_2 * (dGdA * cnm + dHdA * snm);
            dUdAlSin += cf_2 * (dGdA * snm - dHdA * cnm);
            dUdBeCos += cf_2 * (dGdB * cnm + dHdB * snm);
            dUdBeSin += cf_2 * (dGdB * snm - dHdB * cnm);
            dUdGaCos += dUdGaCoef * gcPhs;
            dUdGaSin += dUdGaCoef * gsMhc;
        }
        return new double[][]{{dUdaCos, dUdaSin}, {dUdhCos, dUdhSin}, {dUdkCos, dUdkSin}, {dUdlCos, dUdlSin}, {dUdAlCos, dUdAlSin}, {dUdBeCos, dUdBeSin}, {dUdGaCos, dUdGaSin}};
    }

    @Override
    public void registerAttitudeProvider(AttitudeProvider attitudeProvider) {
    }

    @Override
    public void resetShortPeriodicsCoefficients() {
        if (this.tesseralSPCoefs != null) {
            this.tesseralSPCoefs.resetCoefficients();
        }
    }

    private class TesseralShortPeriodicCoefficients {
        private final ShortPeriodicsInterpolatedCoefficient[][][] cijm;
        private final ShortPeriodicsInterpolatedCoefficient[][][] sijm;
        private final int jMax;
        private final int mMax;
        private final FourierCjSjCoefficients cjsjFourier;
        private double tnota;

        public TesseralShortPeriodicCoefficients(int jMax, int mMax, int interpolationPoints) {
            this.jMax = jMax;
            this.mMax = mMax;
            this.cijm = new ShortPeriodicsInterpolatedCoefficient[mMax + 1][2 * jMax + 1][6];
            this.sijm = new ShortPeriodicsInterpolatedCoefficient[mMax + 1][2 * jMax + 1][6];
            this.cjsjFourier = new FourierCjSjCoefficients(jMax, mMax);
            for (int m = 1; m <= mMax; ++m) {
                for (int j = -jMax; j <= jMax; ++j) {
                    for (int i = 0; i < 6; ++i) {
                        this.cijm[m][j + jMax][i] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                        this.sijm[m][j + jMax][i] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                    }
                }
            }
        }

        public void computeCoefficients(AbsoluteDate date) throws OrekitException {
            if (!TesseralContribution.this.nonResOrders.isEmpty() || TesseralContribution.this.mDailiesOnly) {
                this.cjsjFourier.generateCoefficients(date);
                this.tnota = 1.5 * TesseralContribution.this.meanMotion / TesseralContribution.this.a;
                for (int m = 1; m <= TesseralContribution.this.maxOrderMdailyTesseralSP; ++m) {
                    this.buildCoefficients(date, m, 0);
                }
                if (!TesseralContribution.this.mDailiesOnly) {
                    Iterator i$ = TesseralContribution.this.nonResOrders.keySet().iterator();
                    while (i$.hasNext()) {
                        int m = (Integer)i$.next();
                        List listJ = (List)TesseralContribution.this.nonResOrders.get(m);
                        Iterator i$2 = listJ.iterator();
                        while (i$2.hasNext()) {
                            int j = (Integer)i$2.next();
                            this.buildCoefficients(date, m, j);
                        }
                    }
                }
            }
        }

        private void buildCoefficients(AbsoluteDate date, int m, int j) {
            int i;
            double[] currentCijm = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            double[] currentSijm = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            double oojnmt = 1.0 / ((double)j * TesseralContribution.this.meanMotion - (double)m * TesseralContribution.this.centralBodyRotationRate);
            for (i = 0; i < 6; ++i) {
                currentCijm[i] = -this.cjsjFourier.getSijm(i, j, m);
                currentSijm[i] = this.cjsjFourier.getCijm(i, j, m);
            }
            currentCijm[5] = currentCijm[5] + this.tnota * oojnmt * this.cjsjFourier.getCijm(0, j, m);
            currentSijm[5] = currentSijm[5] + this.tnota * oojnmt * this.cjsjFourier.getSijm(0, j, m);
            i = 0;
            while (i < 6) {
                int n = i;
                currentCijm[n] = currentCijm[n] * oojnmt;
                int n2 = i++;
                currentSijm[n2] = currentSijm[n2] * oojnmt;
            }
            for (i = 0; i < 6; ++i) {
                this.cijm[m][j + this.jMax][i].addGridPoint(date, currentCijm[i]);
                this.sijm[m][j + this.jMax][i].addGridPoint(date, currentSijm[i]);
            }
        }

        public void resetCoefficients() {
            for (int m = 1; m <= this.mMax; ++m) {
                for (int j = -this.jMax; j <= this.jMax; ++j) {
                    for (int i = 0; i < 6; ++i) {
                        this.cijm[m][j + this.jMax][i].clearHistory();
                        this.sijm[m][j + this.jMax][i].clearHistory();
                    }
                }
            }
        }

        public double getCijm(int i, int j, int m, AbsoluteDate date) {
            return this.cijm[m][j + this.jMax][i].value(date);
        }

        public double getSijm(int i, int j, int m, AbsoluteDate date) {
            return this.sijm[m][j + this.jMax][i].value(date);
        }
    }

    private class FourierCjSjCoefficients {
        private final int jMax;
        private final double[][][] cCoef;
        private final double[][][] sCoef;
        private GHmsjPolynomials ghMSJ;
        private GammaMnsFunction gammaMNS;
        private final double[] roaPow;

        public FourierCjSjCoefficients(int jMax, int mMax) {
            this.jMax = jMax;
            this.cCoef = new double[mMax + 1][2 * jMax + 1][6];
            this.sCoef = new double[mMax + 1][2 * jMax + 1][6];
            this.roaPow = new double[TesseralContribution.this.maxDegree + 1];
            this.roaPow[0] = 1.0;
        }

        public void generateCoefficients(AbsoluteDate date) throws OrekitException {
            if (!TesseralContribution.this.nonResOrders.isEmpty() || TesseralContribution.this.mDailiesOnly) {
                this.ghMSJ = new GHmsjPolynomials(TesseralContribution.this.k, TesseralContribution.this.h, TesseralContribution.this.alpha, TesseralContribution.this.beta, TesseralContribution.this.I);
                this.gammaMNS = new GammaMnsFunction(TesseralContribution.this.fact, TesseralContribution.this.gamma, TesseralContribution.this.I);
                int maxRoaPower = FastMath.max((int)TesseralContribution.this.maxDegreeTesseralSP, (int)TesseralContribution.this.maxDegreeMdailyTesseralSP);
                for (int i = 1; i <= maxRoaPower; ++i) {
                    this.roaPow[i] = TesseralContribution.this.roa * this.roaPow[i - 1];
                }
                for (int m = 1; m <= TesseralContribution.this.maxOrderMdailyTesseralSP; ++m) {
                    this.buildFourierCoefficients(date, m, 0, TesseralContribution.this.maxDegreeMdailyTesseralSP);
                }
                if (!TesseralContribution.this.mDailiesOnly) {
                    Iterator i$ = TesseralContribution.this.nonResOrders.keySet().iterator();
                    while (i$.hasNext()) {
                        int m = (Integer)i$.next();
                        List listJ = (List)TesseralContribution.this.nonResOrders.get(m);
                        Iterator i$2 = listJ.iterator();
                        while (i$2.hasNext()) {
                            int j = (Integer)i$2.next();
                            this.buildFourierCoefficients(date, m, j, TesseralContribution.this.maxDegreeTesseralSP);
                        }
                    }
                }
            }
        }

        private void buildFourierCoefficients(AbsoluteDate date, int m, int j, int maxN) throws OrekitException {
            double dRdaCos = 0.0;
            double dRdaSin = 0.0;
            double dRdhCos = 0.0;
            double dRdhSin = 0.0;
            double dRdkCos = 0.0;
            double dRdkSin = 0.0;
            double dRdlCos = 0.0;
            double dRdlSin = 0.0;
            double dRdAlCos = 0.0;
            double dRdAlSin = 0.0;
            double dRdBeCos = 0.0;
            double dRdBeSin = 0.0;
            double dRdGaCos = 0.0;
            double dRdGaSin = 0.0;
            int sMin = j == 0 ? TesseralContribution.this.maxEccPowMdailyTesseralSP : TesseralContribution.this.maxEccPowTesseralSP;
            int sMax = j == 0 ? TesseralContribution.this.maxEccPowMdailyTesseralSP : TesseralContribution.this.maxEccPowTesseralSP;
            for (int s = 0; s <= sMax; ++s) {
                double[][] nSumSpos = TesseralContribution.this.computeNSum(date, j, m, s, maxN, this.roaPow, this.ghMSJ, this.gammaMNS);
                dRdaCos += nSumSpos[0][0];
                dRdaSin += nSumSpos[0][1];
                dRdhCos += nSumSpos[1][0];
                dRdhSin += nSumSpos[1][1];
                dRdkCos += nSumSpos[2][0];
                dRdkSin += nSumSpos[2][1];
                dRdlCos += nSumSpos[3][0];
                dRdlSin += nSumSpos[3][1];
                dRdAlCos += nSumSpos[4][0];
                dRdAlSin += nSumSpos[4][1];
                dRdBeCos += nSumSpos[5][0];
                dRdBeSin += nSumSpos[5][1];
                dRdGaCos += nSumSpos[6][0];
                dRdGaSin += nSumSpos[6][1];
                if (s <= 0 || s > sMin) continue;
                double[][] nSumSneg = TesseralContribution.this.computeNSum(date, j, m, -s, maxN, this.roaPow, this.ghMSJ, this.gammaMNS);
                dRdaCos += nSumSneg[0][0];
                dRdaSin += nSumSneg[0][1];
                dRdhCos += nSumSneg[1][0];
                dRdhSin += nSumSneg[1][1];
                dRdkCos += nSumSneg[2][0];
                dRdkSin += nSumSneg[2][1];
                dRdlCos += nSumSneg[3][0];
                dRdlSin += nSumSneg[3][1];
                dRdAlCos += nSumSneg[4][0];
                dRdAlSin += nSumSneg[4][1];
                dRdBeCos += nSumSneg[5][0];
                dRdBeSin += nSumSneg[5][1];
                dRdGaCos += nSumSneg[6][0];
                dRdGaSin += nSumSneg[6][1];
            }
            dRdaCos *= -TesseralContribution.this.moa / TesseralContribution.this.a;
            dRdaSin *= -TesseralContribution.this.moa / TesseralContribution.this.a;
            dRdhCos *= TesseralContribution.this.moa;
            dRdhSin *= TesseralContribution.this.moa;
            dRdkCos *= TesseralContribution.this.moa;
            dRdkSin *= TesseralContribution.this.moa;
            dRdlCos *= TesseralContribution.this.moa;
            dRdlSin *= TesseralContribution.this.moa;
            double RAlphaGammaCos = TesseralContribution.this.alpha * (dRdGaCos *= TesseralContribution.this.moa) - TesseralContribution.this.gamma * (dRdAlCos *= TesseralContribution.this.moa);
            double RAlphaGammaSin = TesseralContribution.this.alpha * (dRdGaSin *= TesseralContribution.this.moa) - TesseralContribution.this.gamma * (dRdAlSin *= TesseralContribution.this.moa);
            double RAlphaBetaCos = TesseralContribution.this.alpha * (dRdBeCos *= TesseralContribution.this.moa) - TesseralContribution.this.beta * dRdAlCos;
            double RAlphaBetaSin = TesseralContribution.this.alpha * (dRdBeSin *= TesseralContribution.this.moa) - TesseralContribution.this.beta * dRdAlSin;
            double RBetaGammaCos = TesseralContribution.this.beta * dRdGaCos - TesseralContribution.this.gamma * dRdBeCos;
            double RBetaGammaSin = TesseralContribution.this.beta * dRdGaSin - TesseralContribution.this.gamma * dRdBeSin;
            double RhkCos = TesseralContribution.this.h * dRdkCos - TesseralContribution.this.k * dRdhCos;
            double RhkSin = TesseralContribution.this.h * dRdkSin - TesseralContribution.this.k * dRdhSin;
            double pRagmIqRbgoABCos = (TesseralContribution.this.p * RAlphaGammaCos - (double)TesseralContribution.this.I * TesseralContribution.this.q * RBetaGammaCos) * TesseralContribution.this.ooAB;
            double pRagmIqRbgoABSin = (TesseralContribution.this.p * RAlphaGammaSin - (double)TesseralContribution.this.I * TesseralContribution.this.q * RBetaGammaSin) * TesseralContribution.this.ooAB;
            double RhkmRabmdRdlCos = RhkCos - RAlphaBetaCos - dRdlCos;
            double RhkmRabmdRdlSin = RhkSin - RAlphaBetaSin - dRdlSin;
            this.cCoef[m][j + this.jMax][0] = TesseralContribution.this.ax2oA * dRdlCos;
            this.sCoef[m][j + this.jMax][0] = TesseralContribution.this.ax2oA * dRdlSin;
            this.cCoef[m][j + this.jMax][1] = -(TesseralContribution.this.BoA * dRdhCos + TesseralContribution.this.h * pRagmIqRbgoABCos + TesseralContribution.this.k * TesseralContribution.this.BoABpo * dRdlCos);
            this.sCoef[m][j + this.jMax][1] = -(TesseralContribution.this.BoA * dRdhSin + TesseralContribution.this.h * pRagmIqRbgoABSin + TesseralContribution.this.k * TesseralContribution.this.BoABpo * dRdlSin);
            this.cCoef[m][j + this.jMax][2] = TesseralContribution.this.BoA * dRdkCos + TesseralContribution.this.k * pRagmIqRbgoABCos - TesseralContribution.this.h * TesseralContribution.this.BoABpo * dRdlCos;
            this.sCoef[m][j + this.jMax][2] = TesseralContribution.this.BoA * dRdkSin + TesseralContribution.this.k * pRagmIqRbgoABSin - TesseralContribution.this.h * TesseralContribution.this.BoABpo * dRdlSin;
            this.cCoef[m][j + this.jMax][3] = TesseralContribution.this.Co2AB * (TesseralContribution.this.q * RhkmRabmdRdlCos - (double)TesseralContribution.this.I * RAlphaGammaCos);
            this.sCoef[m][j + this.jMax][3] = TesseralContribution.this.Co2AB * (TesseralContribution.this.q * RhkmRabmdRdlSin - (double)TesseralContribution.this.I * RAlphaGammaSin);
            this.cCoef[m][j + this.jMax][4] = TesseralContribution.this.Co2AB * (TesseralContribution.this.p * RhkmRabmdRdlCos - RBetaGammaCos);
            this.sCoef[m][j + this.jMax][4] = TesseralContribution.this.Co2AB * (TesseralContribution.this.p * RhkmRabmdRdlSin - RBetaGammaSin);
            this.cCoef[m][j + this.jMax][5] = -TesseralContribution.this.ax2oA * dRdaCos + TesseralContribution.this.BoABpo * (TesseralContribution.this.h * dRdhCos + TesseralContribution.this.k * dRdkCos) + pRagmIqRbgoABCos;
            this.sCoef[m][j + this.jMax][5] = -TesseralContribution.this.ax2oA * dRdaSin + TesseralContribution.this.BoABpo * (TesseralContribution.this.h * dRdhSin + TesseralContribution.this.k * dRdkSin) + pRagmIqRbgoABSin;
        }

        public double getCijm(int i, int j, int m) {
            return this.cCoef[m][j + this.jMax][i];
        }

        public double getSijm(int i, int j, int m) {
            return this.sCoef[m][j + this.jMax][i];
        }
    }
}

