/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.ode.AbstractIntegrator;
import org.apache.commons.math3.ode.nonstiff.ClassicalRungeKuttaIntegrator;
import org.apache.commons.math3.ode.sampling.StepHandler;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.errors.PropagationException;
import org.orekit.frames.Frame;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.integration.AbstractIntegratedPropagator;
import org.orekit.propagation.integration.StateMapper;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.InterpolationGrid;
import org.orekit.propagation.semianalytical.dsst.utilities.VariableStepInterpolationGrid;
import org.orekit.time.AbsoluteDate;

public class DSSTPropagator
extends AbstractIntegratedPropagator {
    private static final int I = 1;
    private static final int INTERPOLATION_POINTS_PER_STEP = 3;
    private MeanPlusShortPeriodicMapper mapper;

    public DSSTPropagator(AbstractIntegrator integrator, boolean meanOnly) {
        super(integrator, meanOnly);
        this.initMapper();
        this.setOrbitType(OrbitType.EQUINOCTIAL);
        this.setPositionAngleType(PositionAngle.TRUE);
        this.setAttitudeProvider(DEFAULT_LAW);
    }

    public DSSTPropagator(AbstractIntegrator integrator) {
        super(integrator, true);
        this.initMapper();
        this.setOrbitType(OrbitType.EQUINOCTIAL);
        this.setPositionAngleType(PositionAngle.TRUE);
        this.setAttitudeProvider(DEFAULT_LAW);
    }

    public void setInitialState(SpacecraftState initialState) throws PropagationException {
        this.setInitialState(initialState, true);
    }

    public void setInitialState(SpacecraftState initialState, boolean isOsculating) throws PropagationException {
        this.mapper.setInitialIsOsculating(isOsculating);
        this.resetInitialState(initialState);
    }

    @Override
    public void resetInitialState(SpacecraftState state) throws PropagationException {
        super.setStartDate(state.getDate());
        super.resetInitialState(state);
    }

    public boolean initialIsOsculating() {
        return this.mapper.initialIsOsculating();
    }

    public void addForceModel(DSSTForceModel force) {
        this.mapper.addForceModel(force);
        force.registerAttitudeProvider(this.getAttitudeProvider());
    }

    public void removeForceModels() {
        this.mapper.removeForceModels();
    }

    public static SpacecraftState computeOsculatingState(SpacecraftState mean, Collection<DSSTForceModel> forces) throws OrekitException {
        ClassicalRungeKuttaIntegrator integrator = new ClassicalRungeKuttaIntegrator(43200.0);
        DSSTPropagator dsst = new DSSTPropagator((AbstractIntegrator)integrator, false);
        AuxiliaryElements aux = new AuxiliaryElements(mean.getOrbit(), 1);
        for (DSSTForceModel force : forces) {
            force.initialize(aux, false);
            dsst.addForceModel(force);
        }
        Orbit osculatingOrbit = dsst.mapper.computeOsculatingOrbit(mean);
        return new SpacecraftState(osculatingOrbit, mean.getAttitude(), mean.getMass(), mean.getAdditionalStates());
    }

    public static SpacecraftState computeMeanState(SpacecraftState osculating, Collection<DSSTForceModel> forces) throws OrekitException {
        ClassicalRungeKuttaIntegrator integrator = new ClassicalRungeKuttaIntegrator(43200.0);
        DSSTPropagator dsst = new DSSTPropagator((AbstractIntegrator)integrator, false);
        AuxiliaryElements aux = new AuxiliaryElements(osculating.getOrbit(), 1);
        for (DSSTForceModel force : forces) {
            force.initialize(aux, false);
            dsst.addForceModel(force);
        }
        dsst.setInitialState(osculating, true);
        Orbit meanOrbit = dsst.mapper.computeMeanOrbit(osculating);
        return new SpacecraftState(meanOrbit, osculating.getAttitude(), osculating.getMass(), osculating.getAdditionalStates());
    }

    public void setSatelliteRevolution(int satelliteRevolution) {
        this.mapper.setSatelliteRevolution(satelliteRevolution);
    }

    public int getSatelliteRevolution() {
        return this.mapper.getSatelliteRevolution();
    }

    @Override
    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        super.setAttitudeProvider(attitudeProvider);
        for (DSSTForceModel force : this.mapper.getForceModels()) {
            force.registerAttitudeProvider(attitudeProvider);
        }
    }

    @Override
    protected void beforeIntegration(SpacecraftState initialState, AbsoluteDate tEnd) throws OrekitException {
        AuxiliaryElements aux = new AuxiliaryElements(initialState.getOrbit(), 1);
        boolean meanOnly = this.isMeanOrbit();
        for (DSSTForceModel force : this.mapper.getForceModels()) {
            force.initialize(aux, meanOnly);
        }
        if (!meanOnly) {
            VariableStepInterpolationGrid grid = new VariableStepInterpolationGrid(3);
            ShortPeriodicsHandler spHandler = new ShortPeriodicsHandler(grid);
            ArrayList<ShortPeriodicsHandler> stepHandlers = new ArrayList<ShortPeriodicsHandler>();
            stepHandlers.add(spHandler);
            AbstractIntegrator integrator = this.getIntegrator();
            Collection existing = integrator.getStepHandlers();
            stepHandlers.addAll(existing);
            integrator.clearStepHandlers();
            for (StepHandler stepHandler : stepHandlers) {
                integrator.addStepHandler(stepHandler);
            }
        }
    }

    @Override
    protected void afterIntegration() throws OrekitException {
        if (!this.isMeanOrbit()) {
            ArrayList<StepHandler> preserved = new ArrayList<StepHandler>();
            AbstractIntegrator integrator = this.getIntegrator();
            for (StepHandler sp : integrator.getStepHandlers()) {
                if (sp instanceof ShortPeriodicsHandler) continue;
                preserved.add(sp);
            }
            integrator.clearStepHandlers();
            for (StepHandler sp : preserved) {
                integrator.addStepHandler(sp);
            }
        }
    }

    @Override
    protected StateMapper createMapper(AbsoluteDate referenceDate, double mu, OrbitType orbitType, PositionAngle positionAngleType, AttitudeProvider attitudeProvider, Frame frame) {
        MeanPlusShortPeriodicMapper newMapper = new MeanPlusShortPeriodicMapper(referenceDate, mu, attitudeProvider, frame);
        if (this.mapper != null) {
            for (DSSTForceModel forceModel : this.mapper.getForceModels()) {
                newMapper.addForceModel(forceModel);
            }
            newMapper.setSatelliteRevolution(this.mapper.getSatelliteRevolution());
            newMapper.setInitialIsOsculating(this.mapper.initialIsOsculating());
        }
        this.mapper = newMapper;
        return this.mapper;
    }

    @Override
    protected AbstractIntegratedPropagator.MainStateEquations getMainStateEquations(AbstractIntegrator integrator) {
        return new Main(integrator);
    }

    public static double[][] tolerances(double dP, Orbit orbit) throws PropagationException {
        return NumericalPropagator.tolerances(dP, orbit, OrbitType.EQUINOCTIAL);
    }

    private class ShortPeriodicsHandler
    implements StepHandler {
        private final InterpolationGrid grid;

        public ShortPeriodicsHandler(InterpolationGrid grid) {
            this.grid = grid;
        }

        public void init(double t0, double[] y0, double t) {
        }

        public void handleStep(StepInterpolator interpolator, boolean isLast) {
            double[] interpolationPoints;
            DSSTPropagator.this.mapper.resetShortPeriodicsCoefficients();
            for (double time : interpolationPoints = this.grid.getGridPoints(interpolator.getPreviousTime(), interpolator.getCurrentTime())) {
                interpolator.setInterpolatedTime(time);
                try {
                    SpacecraftState state = DSSTPropagator.this.mapper.mapArrayToState(time, interpolator.getInterpolatedState(), true);
                    DSSTPropagator.this.mapper.computeShortPeriodicsCoefficients(state);
                }
                catch (MaxCountExceededException e) {
                    e.printStackTrace();
                }
                catch (OrekitException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class Main
    implements AbstractIntegratedPropagator.MainStateEquations {
        private final double[] yDot = new double[7];

        public Main(AbstractIntegrator integrator) {
            for (DSSTForceModel forceModel : DSSTPropagator.this.mapper.getForceModels()) {
                EventDetector[] modelDetectors = forceModel.getEventsDetectors();
                if (modelDetectors == null) continue;
                for (EventDetector detector : modelDetectors) {
                    DSSTPropagator.this.setUpEventDetector(integrator, detector);
                }
            }
        }

        @Override
        public double[] computeDerivatives(SpacecraftState state) throws OrekitException {
            AuxiliaryElements aux = new AuxiliaryElements(state.getOrbit(), 1);
            for (DSSTForceModel force : DSSTPropagator.this.mapper.getForceModels()) {
                force.initializeStep(aux);
            }
            Arrays.fill(this.yDot, 0.0);
            for (DSSTForceModel forceModel : DSSTPropagator.this.mapper.getForceModels()) {
                double[] daidt = forceModel.getMeanElementRate(state);
                for (int i = 0; i < daidt.length; ++i) {
                    int n = i;
                    this.yDot[n] = this.yDot[n] + daidt[i];
                }
            }
            EquinoctialOrbit orbit = (EquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(state.getOrbit());
            orbit.addKeplerContribution(PositionAngle.MEAN, DSSTPropagator.this.getMu(), this.yDot);
            return (double[])this.yDot.clone();
        }
    }

    private static class MeanPlusShortPeriodicMapper
    extends StateMapper
    implements Serializable {
        private static final long serialVersionUID = 20130621L;
        private boolean initialIsOsculating = true;
        private final transient List<DSSTForceModel> forceModels = new ArrayList<DSSTForceModel>();
        private int satelliteRevolution = 2;

        public MeanPlusShortPeriodicMapper(AbsoluteDate referenceDate, double mu, AttitudeProvider attitudeProvider, Frame frame) {
            super(referenceDate, mu, OrbitType.EQUINOCTIAL, PositionAngle.MEAN, attitudeProvider, frame);
        }

        @Override
        public SpacecraftState mapArrayToState(double t, double[] y, boolean meanOnly) throws OrekitException {
            double mass;
            AbsoluteDate date = this.mapDoubleToDate(t);
            double[] elements = (double[])y.clone();
            if (!meanOnly) {
                for (DSSTForceModel forceModel : this.forceModels) {
                    double[] shortPeriodic = forceModel.getShortPeriodicVariations(date, y);
                    for (int i = 0; i < shortPeriodic.length; ++i) {
                        int n = i;
                        elements[n] = elements[n] + shortPeriodic[i];
                    }
                }
            }
            if ((mass = elements[6]) <= 0.0) {
                throw new PropagationException((Localizable)OrekitMessages.SPACECRAFT_MASS_BECOMES_NEGATIVE, mass);
            }
            Orbit orbit = OrbitType.EQUINOCTIAL.mapArrayToOrbit(elements, PositionAngle.MEAN, date, this.getMu(), this.getFrame());
            Attitude attitude = this.getAttitudeProvider().getAttitude(orbit, date, this.getFrame());
            return new SpacecraftState(orbit, attitude, mass);
        }

        @Override
        public void mapStateToArray(SpacecraftState state, double[] y) throws OrekitException {
            Orbit meanOrbit = !this.initialIsOsculating ? state.getOrbit() : DSSTPropagator.computeMeanState(state, this.forceModels).getOrbit();
            OrbitType.EQUINOCTIAL.mapOrbitToArray(meanOrbit, PositionAngle.MEAN, y);
            y[6] = state.getMass();
        }

        public void addForceModel(DSSTForceModel force) {
            this.forceModels.add(force);
        }

        public void removeForceModels() {
            this.forceModels.clear();
        }

        public List<DSSTForceModel> getForceModels() {
            return this.forceModels;
        }

        public void setSatelliteRevolution(int satelliteRevolution) {
            this.satelliteRevolution = satelliteRevolution;
        }

        public int getSatelliteRevolution() {
            return this.satelliteRevolution;
        }

        public void setInitialIsOsculating(boolean initialIsOsculating) {
            this.initialIsOsculating = initialIsOsculating;
        }

        public boolean initialIsOsculating() {
            return this.initialIsOsculating;
        }

        private void resetShortPeriodicsCoefficients() {
            for (DSSTForceModel forceModel : this.forceModels) {
                forceModel.resetShortPeriodicsCoefficients();
            }
        }

        private void computeShortPeriodicsCoefficients(SpacecraftState state) throws OrekitException {
            AuxiliaryElements aux = new AuxiliaryElements(state.getOrbit(), 1);
            for (DSSTForceModel forceModel : this.forceModels) {
                forceModel.initializeStep(aux);
                forceModel.computeShortPeriodicsCoefficients(state);
            }
        }

        private Orbit computeMeanOrbit(SpacecraftState osculating) throws OrekitException {
            EquinoctialOrbit meanOrbit = new EquinoctialOrbit(osculating.getOrbit());
            double epsilon = 1.0E-13;
            double thresholdA = 1.0E-13 * (1.0 + FastMath.abs((double)meanOrbit.getA()));
            double thresholdE = 1.0E-13 * (1.0 + meanOrbit.getE());
            double thresholdAngles = 3.141592653589793E-13;
            int i = 0;
            while (i++ < 200) {
                SpacecraftState meanState = new SpacecraftState((Orbit)meanOrbit, osculating.getAttitude(), osculating.getMass());
                EquinoctialOrbit rebuilt = (EquinoctialOrbit)this.computeOsculatingOrbit(meanState);
                double deltaA = osculating.getA() - rebuilt.getA();
                double deltaEx = osculating.getEquinoctialEx() - rebuilt.getEquinoctialEx();
                double deltaEy = osculating.getEquinoctialEy() - rebuilt.getEquinoctialEy();
                double deltaHx = osculating.getHx() - rebuilt.getHx();
                double deltaHy = osculating.getHy() - rebuilt.getHy();
                double deltaLm = MathUtils.normalizeAngle((double)(osculating.getLM() - rebuilt.getLM()), (double)0.0);
                if (FastMath.abs((double)deltaA) < thresholdA && FastMath.abs((double)deltaEx) < thresholdE && FastMath.abs((double)deltaEy) < thresholdE && FastMath.abs((double)deltaLm) < 3.141592653589793E-13) {
                    return meanOrbit;
                }
                meanOrbit = new EquinoctialOrbit(meanOrbit.getA() + deltaA, meanOrbit.getEquinoctialEx() + deltaEx, meanOrbit.getEquinoctialEy() + deltaEy, meanOrbit.getHx() + deltaHx, meanOrbit.getHy() + deltaHy, meanOrbit.getLM() + deltaLm, PositionAngle.MEAN, meanOrbit.getFrame(), meanOrbit.getDate(), meanOrbit.getMu());
            }
            throw new PropagationException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_DSST_MEAN_PARAMETERS, i);
        }

        private Orbit computeOsculatingOrbit(SpacecraftState meanState) throws OrekitException {
            this.resetShortPeriodicsCoefficients();
            this.computeShortPeriodicsCoefficients(meanState);
            double[] mean = new double[6];
            OrbitType.EQUINOCTIAL.mapOrbitToArray(meanState.getOrbit(), PositionAngle.MEAN, mean);
            double[] y = (double[])mean.clone();
            for (DSSTForceModel forceModel : this.forceModels) {
                double[] shortPeriodic = forceModel.getShortPeriodicVariations(meanState.getDate(), mean);
                for (int i = 0; i < shortPeriodic.length; ++i) {
                    int n = i;
                    y[n] = y[n] + shortPeriodic[i];
                }
            }
            return OrbitType.EQUINOCTIAL.mapArrayToOrbit(y, PositionAngle.MEAN, meanState.getDate(), meanState.getMu(), meanState.getFrame());
        }

        private Object writeReplace() throws NotSerializableException {
            DSSTForceModel[] serializableorceModels = new DSSTForceModel[this.forceModels.size()];
            for (int i = 0; i < serializableorceModels.length; ++i) {
                DSSTForceModel forceModel = this.forceModels.get(i);
                if (!(forceModel instanceof Serializable)) {
                    throw new NotSerializableException(forceModel.getClass().getName());
                }
                serializableorceModels[i] = forceModel;
            }
            return new DataTransferObject(this.getReferenceDate(), this.getMu(), this.getAttitudeProvider(), this.getFrame(), this.initialIsOsculating, serializableorceModels, this.satelliteRevolution);
        }

        private static class DataTransferObject
        implements Serializable {
            private static final long serialVersionUID = 20130621L;
            private final AbsoluteDate referenceDate;
            private final double mu;
            private final AttitudeProvider attitudeProvider;
            private final Frame frame;
            private final boolean initialIsOsculating;
            private final DSSTForceModel[] forceModels;
            private final int satelliteRevolution;

            public DataTransferObject(AbsoluteDate referenceDate, double mu, AttitudeProvider attitudeProvider, Frame frame, boolean initialIsOsculating, DSSTForceModel[] forceModels, int satelliteRevolution) {
                this.referenceDate = referenceDate;
                this.mu = mu;
                this.attitudeProvider = attitudeProvider;
                this.frame = frame;
                this.initialIsOsculating = initialIsOsculating;
                this.forceModels = forceModels;
                this.satelliteRevolution = satelliteRevolution;
            }

            private Object readResolve() {
                MeanPlusShortPeriodicMapper mapper = new MeanPlusShortPeriodicMapper(this.referenceDate, this.mu, this.attitudeProvider, this.frame);
                for (DSSTForceModel forceModel : this.forceModels) {
                    mapper.addForceModel(forceModel);
                }
                mapper.setSatelliteRevolution(this.satelliteRevolution);
                mapper.setInitialIsOsculating(this.initialIsOsculating);
                return mapper;
            }
        }
    }
}

