/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.apache.commons.math3.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;

public class EventShifter<T extends EventDetector>
extends AbstractDetector<EventShifter<T>> {
    private static final long serialVersionUID = 20131118L;
    private final T detector;
    private final boolean useShiftedStates;
    private final double increasingOffset;
    private final double decreasingOffset;

    public EventShifter(T detector, boolean useShiftedStates, double increasingTimeShift, double decreasingTimeShift) {
        this(detector.getMaxCheckInterval(), detector.getThreshold(), detector.getMaxIterationCount(), new LocalHandler(), detector, useShiftedStates, increasingTimeShift, decreasingTimeShift);
    }

    private EventShifter(double maxCheck, double threshold, int maxIter, EventHandler<EventShifter<T>> handler, T detector, boolean useShiftedStates, double increasingTimeShift, double decreasingTimeShift) {
        super(maxCheck, threshold, maxIter, handler);
        this.detector = detector;
        this.useShiftedStates = useShiftedStates;
        this.increasingOffset = -increasingTimeShift;
        this.decreasingOffset = -decreasingTimeShift;
    }

    @Override
    protected EventShifter<T> create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<EventShifter<T>> newHandler) {
        return new EventShifter<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.detector, this.useShiftedStates, -this.increasingOffset, -this.decreasingOffset);
    }

    public double getIncreasingTimeShift() {
        return this.increasingOffset;
    }

    public double getDecreasingTimeShift() {
        return this.decreasingOffset;
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        this.detector.init(s0, t);
    }

    @Override
    public double g(SpacecraftState s) throws OrekitException {
        double incShiftedG = this.detector.g(s.shiftedBy(this.increasingOffset));
        double decShiftedG = this.detector.g(s.shiftedBy(this.decreasingOffset));
        return this.increasingOffset >= this.decreasingOffset ? FastMath.max((double)incShiftedG, (double)decShiftedG) : FastMath.min((double)incShiftedG, (double)decShiftedG);
    }

    private static class LocalHandler<T extends EventDetector>
    implements EventHandler<EventShifter<T>> {
        private SpacecraftState shiftedState;

        private LocalHandler() {
        }

        @Override
        public EventHandler.Action eventOccurred(SpacecraftState s, EventShifter<T> shifter, boolean increasing) throws OrekitException {
            if (((EventShifter)shifter).useShiftedStates) {
                this.shiftedState = s;
            } else {
                double offset = increasing ? ((EventShifter)shifter).increasingOffset : ((EventShifter)shifter).decreasingOffset;
                this.shiftedState = s.shiftedBy(offset);
            }
            return ((EventShifter)shifter).detector.eventOccurred(this.shiftedState, increasing);
        }

        @Override
        public SpacecraftState resetState(EventShifter<T> shifter, SpacecraftState oldState) throws OrekitException {
            return ((EventShifter)shifter).detector.resetState(this.shiftedState);
        }
    }
}

