/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.apache.commons.math3.ode.AbstractIntegrator;
import org.apache.commons.math3.ode.nonstiff.AdamsMoultonIntegrator;
import org.orekit.errors.PropagationException;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.propagation.conversion.FirstOrderIntegratorBuilder;
import org.orekit.propagation.numerical.NumericalPropagator;

public class AdamsMoultonIntegratorBuilder
implements FirstOrderIntegratorBuilder {
    private final int nSteps;
    private final double minStep;
    private final double maxStep;
    private final double dP;

    public AdamsMoultonIntegratorBuilder(int nSteps, double minStep, double maxStep, double dP) {
        this.nSteps = nSteps;
        this.minStep = minStep;
        this.maxStep = maxStep;
        this.dP = dP;
    }

    @Override
    public AbstractIntegrator buildIntegrator(Orbit orbit) throws PropagationException {
        double[][] tol = NumericalPropagator.tolerances(this.dP, orbit, OrbitType.CARTESIAN);
        return new AdamsMoultonIntegrator(this.nSteps, this.minStep, this.maxStep, tol[0], tol[1]);
    }
}

