/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;

public class LocalOrbitalFrame
extends Frame {
    private static final long serialVersionUID = -4469440345574964950L;

    public LocalOrbitalFrame(Frame parent, LOFType type, PVCoordinatesProvider provider, String name) throws IllegalArgumentException {
        super(parent, new LocalProvider(type, provider, parent), name, false);
    }

    private static class LocalProvider
    implements TransformProvider {
        private static final long serialVersionUID = 386815086579675823L;
        private final LOFType type;
        private final PVCoordinatesProvider provider;
        private final Frame reference;

        public LocalProvider(LOFType type, PVCoordinatesProvider provider, Frame reference) {
            this.type = type;
            this.provider = provider;
            this.reference = reference;
        }

        @Override
        public Transform getTransform(AbsoluteDate date) throws OrekitException {
            return this.type.transformFromInertial(date, this.provider.getPVCoordinates(date, this.reference));
        }
    }
}

