/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.PoleCorrection;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;

class ITRFProvider
implements TransformProvider {
    private static final long serialVersionUID = 20130922L;
    private static final double S_PRIME_RATE = -2.278624301214819E-10;
    private final EOPHistory eopHistory;

    public ITRFProvider(EOPHistory eopHistory) {
        this.eopHistory = eopHistory;
    }

    @Override
    public Transform getTransform(AbsoluteDate date) throws OrekitException {
        double tts = date.durationFrom(AbsoluteDate.J2000_EPOCH);
        double ttc = tts / 3.15576E9;
        PoleCorrection eop = this.eopHistory.getPoleCorrection(date);
        Rotation r1 = new Rotation(Vector3D.PLUS_I, -eop.getYp());
        Rotation r2 = new Rotation(Vector3D.PLUS_J, -eop.getXp());
        Rotation r3 = new Rotation(Vector3D.PLUS_K, -2.278624301214819E-10 * ttc);
        Rotation wRot = r3.applyTo(r2.applyTo(r1));
        Rotation combined = wRot.revert();
        return new Transform(date, combined, Vector3D.ZERO);
    }
}

