/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeFunction;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.UT1Scale;
import org.orekit.utils.IERSConventions;

public class GTODProvider
implements TransformProvider {
    private static final long serialVersionUID = 20141228L;
    private static final double AVE = 7.292115146706979E-5;
    private final IERSConventions conventions;
    private final EOPHistory eopHistory;
    private final transient TimeFunction<DerivativeStructure> gastFunction;

    protected GTODProvider(IERSConventions conventions, EOPHistory eopHistory) throws OrekitException {
        UT1Scale ut1 = TimeScalesFactory.getUT1(eopHistory);
        this.conventions = conventions;
        this.eopHistory = eopHistory;
        this.gastFunction = conventions.getGASTFunction(ut1, eopHistory);
    }

    EOPHistory getEOPHistory() {
        return this.eopHistory;
    }

    @Override
    public Transform getTransform(AbsoluteDate date) throws OrekitException {
        double gast = this.gastFunction.value(date).getValue();
        double lod = this.eopHistory == null ? 0.0 : this.eopHistory.getLOD(date);
        double omp = 7.292115146706979E-5 * (1.0 - lod / 86400.0);
        Vector3D rotationRate = new Vector3D(omp, Vector3D.PLUS_K);
        return new Transform(date, new Rotation(Vector3D.PLUS_K, -gast), rotationRate);
    }

    private Object writeReplace() {
        return new DataTransferObject(this.conventions, this.eopHistory);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20131209L;
        private final IERSConventions conventions;
        private final EOPHistory eopHistory;

        public DataTransferObject(IERSConventions conventions, EOPHistory eopHistory) {
            this.conventions = conventions;
            this.eopHistory = eopHistory;
        }

        private Object readResolve() {
            try {
                return new GTODProvider(this.conventions, this.eopHistory);
            }
            catch (OrekitException oe) {
                throw OrekitException.createInternalError(oe);
            }
        }
    }
}

