/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.analysis.interpolation.HermiteInterpolator;
import org.apache.commons.math3.exception.util.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.errors.TimeStampedCacheException;
import org.orekit.frames.EOPEntry;
import org.orekit.frames.PoleCorrection;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeFunction;
import org.orekit.time.TimeStamped;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.ImmutableTimeStampedCache;

public class EOPHistory
implements Serializable {
    private static final long serialVersionUID = 20131010L;
    private static final int INTERPOLATION_POINTS = 4;
    private final boolean hasData;
    private final transient ImmutableTimeStampedCache<EOPEntry> cache;
    private final IERSConventions conventions;
    private final transient TimeFunction<double[]> tidalCorrection;

    protected EOPHistory(IERSConventions conventions, Collection<EOPEntry> data, boolean simpleEOP) throws OrekitException {
        this.conventions = conventions;
        TimeFunction<double[]> timeFunction = this.tidalCorrection = simpleEOP ? null : conventions.getEOPTidalCorrection();
        if (data.size() >= 4) {
            this.cache = new ImmutableTimeStampedCache<EOPEntry>(4, data);
            this.hasData = true;
        } else {
            this.cache = ImmutableTimeStampedCache.emptyCache();
            this.hasData = false;
        }
    }

    public IERSConventions getConventions() {
        return this.conventions;
    }

    public AbsoluteDate getStartDate() {
        return this.cache.getEarliest().getDate();
    }

    public AbsoluteDate getEndDate() {
        return this.cache.getLatest().getDate();
    }

    public double getUT1MinusUTC(AbsoluteDate date) {
        if (!this.hasDataFor(date)) {
            return this.tidalCorrection == null ? 0.0 : this.tidalCorrection.value(date)[2];
        }
        try {
            List<EOPEntry> neighbors = this.getNeighbors(date);
            HermiteInterpolator interpolator = new HermiteInterpolator();
            double firstDUT = neighbors.get(0).getUT1MinusUTC();
            boolean beforeLeap = true;
            for (EOPEntry neighbor : neighbors) {
                double dut;
                if (neighbor.getUT1MinusUTC() - firstDUT > 0.9) {
                    dut = neighbor.getUT1MinusUTC() - 1.0;
                    if (neighbor.getDate().compareTo(date) <= 0) {
                        beforeLeap = false;
                    }
                } else {
                    dut = neighbor.getUT1MinusUTC();
                }
                interpolator.addSamplePoint(neighbor.getDate().durationFrom(date), (double[][])new double[][]{{dut}});
            }
            double interpolated = interpolator.value(0.0)[0];
            if (this.tidalCorrection != null) {
                interpolated += this.tidalCorrection.value(date)[2];
            }
            return beforeLeap ? interpolated : interpolated + 1.0;
        }
        catch (TimeStampedCacheException tce) {
            throw OrekitException.createInternalError(tce);
        }
    }

    protected List<EOPEntry> getNeighbors(AbsoluteDate central) throws TimeStampedCacheException {
        return this.cache.getNeighbors(central);
    }

    public double getLOD(AbsoluteDate date) {
        if (!this.hasDataFor(date)) {
            return this.tidalCorrection == null ? 0.0 : this.tidalCorrection.value(date)[3];
        }
        try {
            HermiteInterpolator interpolator = new HermiteInterpolator();
            for (EOPEntry entry : this.getNeighbors(date)) {
                interpolator.addSamplePoint(entry.getDate().durationFrom(date), (double[][])new double[][]{{entry.getLOD()}});
            }
            double interpolated = interpolator.value(0.0)[0];
            if (this.tidalCorrection != null) {
                interpolated += this.tidalCorrection.value(date)[3];
            }
            return interpolated;
        }
        catch (TimeStampedCacheException tce) {
            throw OrekitException.createInternalError(tce);
        }
    }

    public PoleCorrection getPoleCorrection(AbsoluteDate date) {
        if (!this.hasDataFor(date)) {
            if (this.tidalCorrection == null) {
                return PoleCorrection.NULL_CORRECTION;
            }
            double[] correction = this.tidalCorrection.value(date);
            return new PoleCorrection(correction[0], correction[1]);
        }
        try {
            HermiteInterpolator interpolator = new HermiteInterpolator();
            for (EOPEntry entry : this.getNeighbors(date)) {
                interpolator.addSamplePoint(entry.getDate().durationFrom(date), (double[][])new double[][]{{entry.getX(), entry.getY()}});
            }
            double[] interpolated = interpolator.value(0.0);
            if (this.tidalCorrection != null) {
                double[] correction = this.tidalCorrection.value(date);
                interpolated[0] = interpolated[0] + correction[0];
                interpolated[1] = interpolated[1] + correction[1];
            }
            return new PoleCorrection(interpolated[0], interpolated[1]);
        }
        catch (TimeStampedCacheException tce) {
            throw OrekitException.createInternalError(tce);
        }
    }

    public double[] getEquinoxNutationCorrection(AbsoluteDate date) {
        if (!this.hasDataFor(date)) {
            return new double[2];
        }
        try {
            HermiteInterpolator interpolator = new HermiteInterpolator();
            for (EOPEntry entry : this.getNeighbors(date)) {
                interpolator.addSamplePoint(entry.getDate().durationFrom(date), (double[][])new double[][]{{entry.getDdPsi(), entry.getDdEps()}});
            }
            return interpolator.value(0.0);
        }
        catch (TimeStampedCacheException tce) {
            throw OrekitException.createInternalError(tce);
        }
    }

    public double[] getNonRotatinOriginNutationCorrection(AbsoluteDate date) {
        if (!this.hasDataFor(date)) {
            return new double[2];
        }
        try {
            HermiteInterpolator interpolator = new HermiteInterpolator();
            for (EOPEntry entry : this.getNeighbors(date)) {
                interpolator.addSamplePoint(entry.getDate().durationFrom(date), (double[][])new double[][]{{entry.getDx(), entry.getDy()}});
            }
            return interpolator.value(0.0);
        }
        catch (TimeStampedCacheException tce) {
            throw OrekitException.createInternalError(tce);
        }
    }

    public void checkEOPContinuity(double maxGap) throws OrekitException {
        TimeStamped preceding = null;
        for (TimeStamped timeStamped : this.cache.getAll()) {
            if (preceding != null && timeStamped.getDate().durationFrom(preceding.getDate()) > maxGap) {
                throw new OrekitException((Localizable)OrekitMessages.MISSING_EARTH_ORIENTATION_PARAMETERS_BETWEEN_DATES, preceding.getDate(), timeStamped.getDate());
            }
            preceding = timeStamped;
        }
    }

    protected boolean hasDataFor(AbsoluteDate date) {
        return this.hasData && this.getStartDate().compareTo(date) <= 0 && date.compareTo(this.getEndDate()) <= 0;
    }

    List<EOPEntry> getEntries() {
        return this.cache.getAll();
    }

    private Object writeReplace() {
        return new DataTransferObject(this.conventions, this.getEntries(), this.tidalCorrection == null);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20131010L;
        private final IERSConventions conventions;
        private final List<EOPEntry> entries;
        private final boolean simpleEOP;

        public DataTransferObject(IERSConventions conventions, List<EOPEntry> entries, boolean simpleEOP) {
            this.conventions = conventions;
            this.entries = entries;
            this.simpleEOP = simpleEOP;
        }

        private Object readResolve() {
            try {
                return new EOPHistory(this.conventions, this.entries, this.simpleEOP);
            }
            catch (OrekitException oe) {
                throw OrekitException.createInternalError(oe);
            }
        }
    }
}

