/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.math3.exception.util.Localizable;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.EOPEntry;
import org.orekit.frames.EOPHistoryLoader;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.utils.IERSConventions;

class EOP08C04FilesLoader
implements EOPHistoryLoader {
    private static final Pattern COLUMNS_HEADER_PATTERN = Pattern.compile("^ *Date +MJD +x +y +UT1-UTC +LOD +((?:dPsi +dEps)|(?:dX +dY)) .*");
    private static final Pattern DATA_LINE_PATTERN = Pattern.compile("^\\d+ +\\d+ +\\d+ +\\d+(?: +-?\\d+\\.\\d+){12}$");
    private static final int YEAR_FIELD = 0;
    private static final int MONTH_FIELD = 1;
    private static final int DAY_FIELD = 2;
    private static final int MJD_FIELD = 3;
    private static final int POLE_X_FIELD = 4;
    private static final int POLE_Y_FIELD = 5;
    private static final int UT1_UTC_FIELD = 6;
    private static final int LOD_FIELD = 7;
    private static final int NUT_0_FIELD = 8;
    private static final int NUT_1_FIELD = 9;
    private final String supportedNames;

    public EOP08C04FilesLoader(String supportedNames) {
        this.supportedNames = supportedNames;
    }

    @Override
    public void fillHistory(IERSConventions.NutationCorrectionConverter converter, SortedSet<EOPEntry> history) throws OrekitException {
        Parser parser = new Parser(converter);
        DataProvidersManager.getInstance().feed(this.supportedNames, parser);
        history.addAll(parser.history);
    }

    private static class Parser
    implements DataLoader {
        private final IERSConventions.NutationCorrectionConverter converter;
        private final List<EOPEntry> history;
        private int lineNumber;
        private String line;
        private boolean inHeader;
        private boolean isNonRotatingOrigin;

        public Parser(IERSConventions.NutationCorrectionConverter converter) {
            this.converter = converter;
            this.history = new ArrayList<EOPEntry>();
            this.lineNumber = 0;
            this.inHeader = true;
            this.isNonRotatingOrigin = false;
        }

        @Override
        public boolean stillAcceptsData() {
            return true;
        }

        @Override
        public void loadData(InputStream input, String name) throws IOException, OrekitException {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            this.lineNumber = 0;
            this.inHeader = true;
            this.isNonRotatingOrigin = false;
            this.line = reader.readLine();
            while (this.line != null) {
                Matcher matcher;
                ++this.lineNumber;
                boolean parsed = false;
                if (this.inHeader && (matcher = COLUMNS_HEADER_PATTERN.matcher(this.line)).matches() && matcher.group(1).startsWith("dX")) {
                    this.isNonRotatingOrigin = true;
                }
                if (DATA_LINE_PATTERN.matcher(this.line).matches()) {
                    double[] equinox;
                    double[] nro;
                    this.inHeader = false;
                    String[] fields = this.line.split(" +");
                    DateComponents dc = new DateComponents(Integer.parseInt(fields[YEAR_FIELD]), Integer.parseInt(fields[MONTH_FIELD]), Integer.parseInt(fields[DAY_FIELD]));
                    int mjd = Integer.parseInt(fields[MJD_FIELD]);
                    if (dc.getMJD() != mjd) {
                        throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_DATES_IN_IERS_FILE, name, dc.getYear(), dc.getMonth(), dc.getDay(), mjd);
                    }
                    AbsoluteDate date = new AbsoluteDate(dc, (TimeScale)TimeScalesFactory.getUTC());
                    double x = Double.parseDouble(fields[POLE_X_FIELD]) * 4.84813681109536E-6;
                    double y = Double.parseDouble(fields[POLE_Y_FIELD]) * 4.84813681109536E-6;
                    double dtu1 = Double.parseDouble(fields[UT1_UTC_FIELD]);
                    double lod = Double.parseDouble(fields[LOD_FIELD]);
                    if (this.isNonRotatingOrigin) {
                        nro = new double[]{Double.parseDouble(fields[NUT_0_FIELD]) * 4.84813681109536E-6, Double.parseDouble(fields[NUT_1_FIELD]) * 4.84813681109536E-6};
                        equinox = this.converter.toEquinox(date, nro[0], nro[1]);
                    } else {
                        equinox = new double[]{Double.parseDouble(fields[NUT_0_FIELD]) * 4.84813681109536E-6, Double.parseDouble(fields[NUT_1_FIELD]) * 4.84813681109536E-6};
                        nro = this.converter.toNonRotating(date, equinox[0], equinox[1]);
                    }
                    this.history.add(new EOPEntry(mjd, dtu1, lod, x, y, equinox[0], equinox[1], nro[0], nro[1]));
                    parsed = true;
                }
                if (!this.inHeader && !parsed) {
                    throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, this.lineNumber, name, this.line);
                }
                this.line = reader.readLine();
            }
            if (this.inHeader) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_IERS_DATA_FILE, name);
            }
        }
    }
}

