/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.geometry.euclidean.threed.FieldRotation;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.ode.AbstractParameterizable;
import org.apache.commons.math3.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.forces.ForceModel;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;

public class NewtonianAttraction
extends AbstractParameterizable
implements ForceModel {
    public static final String CENTRAL_ATTRACTION_COEFFICIENT = "central attraction coefficient";
    private double mu;

    public NewtonianAttraction(double mu) {
        super(new String[]{CENTRAL_ATTRACTION_COEFFICIENT});
        this.mu = mu;
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, FieldVector3D<DerivativeStructure> velocity, FieldRotation<DerivativeStructure> rotation, DerivativeStructure mass) throws OrekitException {
        DerivativeStructure r2 = (DerivativeStructure)position.getNormSq();
        return new FieldVector3D((RealFieldElement)r2.sqrt().multiply(r2).reciprocal().multiply(-this.mu), position);
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(SpacecraftState s, String paramName) throws OrekitException {
        this.complainIfNotSupported(paramName);
        Vector3D position = s.getPVCoordinates().getPosition();
        double r2 = position.getNormSq();
        DerivativeStructure muds = new DerivativeStructure(1, 1, 0, this.mu);
        return new FieldVector3D((RealFieldElement)muds.divide(-r2 * FastMath.sqrt((double)r2)), position);
    }

    public double getMu() {
        return this.mu;
    }

    public double getParameter(String name) throws IllegalArgumentException {
        this.complainIfNotSupported(name);
        return this.mu;
    }

    public void setParameter(String name, double value) throws IllegalArgumentException {
        this.complainIfNotSupported(name);
        this.mu = value;
    }

    @Override
    public void addContribution(SpacecraftState s, TimeDerivativesEquations adder) throws OrekitException {
        adder.addKeplerContribution(this.mu);
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return new EventDetector[0];
    }
}

