/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.Pair;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ODMFile;
import org.orekit.files.ccsds.ODMMetaData;
import org.orekit.files.general.OrbitFile;
import org.orekit.files.general.SatelliteInformation;
import org.orekit.files.general.SatelliteTimeCoordinate;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.time.AbsoluteDate;

public class OEMFile
extends ODMFile {
    private List<EphemeridesBlock> ephemeridesBlocks = new ArrayList<EphemeridesBlock>();

    void addEphemeridesBlock() {
        this.ephemeridesBlocks.add(new EphemeridesBlock());
    }

    public List<EphemeridesBlock> getEphemeridesBlocks() {
        return Collections.unmodifiableList(this.ephemeridesBlocks);
    }

    void checkTimeSystems() throws OrekitException {
        OrbitFile.TimeSystem timeSystem = this.getEphemeridesBlocks().get(0).getMetaData().getTimeSystem();
        for (EphemeridesBlock block : this.ephemeridesBlocks) {
            if (timeSystem.equals((Object)block.getMetaData().getTimeSystem())) continue;
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_OEM_INCONSISTENT_TIME_SYSTEMS, new Object[]{timeSystem, block.getMetaData().getTimeSystem()});
        }
    }

    @Override
    public String getCoordinateSystem() {
        return this.ephemeridesBlocks.get(0).getMetaData().getFrame().toString();
    }

    @Override
    public OrbitFile.TimeSystem getTimeSystem() {
        return this.ephemeridesBlocks.get(0).getMetaData().getTimeSystem();
    }

    @Override
    public AbsoluteDate getEpoch() {
        return this.ephemeridesBlocks.get(0).getStartTime();
    }

    @Override
    public Collection<SatelliteInformation> getSatellites() {
        Set<String> availableSatellites = this.getAvailableSatelliteIds();
        ArrayList<SatelliteInformation> satellites = new ArrayList<SatelliteInformation>(availableSatellites.size());
        for (String satId : availableSatellites) {
            satellites.add(new SatelliteInformation(satId));
        }
        return satellites;
    }

    @Override
    public int getSatelliteCount() {
        return this.getAvailableSatelliteIds().size();
    }

    @Override
    public SatelliteInformation getSatellite(String satId) {
        Set<String> availableSatellites = this.getAvailableSatelliteIds();
        if (availableSatellites.contains(satId)) {
            return new SatelliteInformation(satId);
        }
        return null;
    }

    @Override
    public List<SatelliteTimeCoordinate> getSatelliteCoordinates(String satId) {
        final ArrayList<Pair> ephemeridesBlockMapping = new ArrayList<Pair>();
        ListIterator<EphemeridesBlock> it = this.ephemeridesBlocks.listIterator();
        int totalDataLines = 0;
        while (it.hasNext()) {
            int index = it.nextIndex();
            EphemeridesBlock block = it.next();
            if (!block.getMetaData().getObjectID().equals(satId)) continue;
            int dataLines = block.getEphemeridesDataLines().size();
            totalDataLines += dataLines;
            ephemeridesBlockMapping.add(new Pair((Object)index, (Object)dataLines));
        }
        final int totalNumberOfCoordinates = totalDataLines;
        return new AbstractList<SatelliteTimeCoordinate>(){

            @Override
            public SatelliteTimeCoordinate get(int index) {
                if (index < 0 || index >= this.size()) {
                    throw new IndexOutOfBoundsException();
                }
                int ephemeridesBlockIndex = -1;
                int dataLineIndex = index;
                for (Pair pair : ephemeridesBlockMapping) {
                    if (dataLineIndex < (Integer)pair.getValue()) {
                        ephemeridesBlockIndex = (Integer)pair.getKey();
                        break;
                    }
                    dataLineIndex -= ((Integer)pair.getValue()).intValue();
                }
                if (ephemeridesBlockIndex == -1 || dataLineIndex == -1) {
                    throw new IndexOutOfBoundsException();
                }
                EphemeridesDataLine dataLine = ((EphemeridesBlock)OEMFile.this.ephemeridesBlocks.get(ephemeridesBlockIndex)).getEphemeridesDataLines().get(dataLineIndex);
                CartesianOrbit orbit = dataLine.getOrbit();
                return new SatelliteTimeCoordinate(orbit.getDate(), orbit.getPVCoordinates());
            }

            @Override
            public int size() {
                return totalNumberOfCoordinates;
            }
        };
    }

    private Set<String> getAvailableSatelliteIds() {
        LinkedHashSet<String> availableSatellites = new LinkedHashSet<String>();
        for (EphemeridesBlock block : this.ephemeridesBlocks) {
            availableSatellites.add(block.getMetaData().getObjectID());
        }
        return availableSatellites;
    }

    public static class CovarianceMatrix {
        private RealMatrix matrix;
        private AbsoluteDate epoch;
        private LOFType lofType;
        private Frame frame;

        CovarianceMatrix(AbsoluteDate epoch, LOFType lofType, Frame frame, RealMatrix lastMatrix) {
            this.matrix = lastMatrix;
            this.epoch = epoch;
            this.lofType = lofType;
            this.frame = frame;
        }

        public RealMatrix getMatrix() {
            return this.matrix;
        }

        public AbsoluteDate getEpoch() {
            return this.epoch;
        }

        public LOFType getLofType() {
            return this.lofType;
        }

        public Frame getFrame() {
            return this.frame;
        }
    }

    public static class EphemeridesDataLine {
        private CartesianOrbit orbit;
        private Vector3D acceleration;

        EphemeridesDataLine(CartesianOrbit orbit, Vector3D acceleration) {
            this.acceleration = acceleration;
            this.orbit = orbit;
        }

        public CartesianOrbit getOrbit() {
            return this.orbit;
        }

        public Vector3D getAcceleration() {
            return this.acceleration;
        }
    }

    public class EphemeridesBlock {
        private ODMMetaData metaData;
        private AbsoluteDate startTime;
        private AbsoluteDate stopTime;
        private AbsoluteDate useableStartTime;
        private AbsoluteDate useableStopTime;
        private String interpolationMethod;
        private int interpolationDegree;
        private List<EphemeridesDataLine> ephemeridesDataLines;
        private List<CovarianceMatrix> covarianceMatrices;
        private boolean hasRefFrameEpoch;
        private List<String> ephemeridesDataLinesComment;

        public EphemeridesBlock() {
            this.metaData = new ODMMetaData(OEMFile.this);
            this.ephemeridesDataLines = new ArrayList<EphemeridesDataLine>();
            this.covarianceMatrices = new ArrayList<CovarianceMatrix>();
        }

        public List<EphemeridesDataLine> getEphemeridesDataLines() {
            return this.ephemeridesDataLines;
        }

        public List<CovarianceMatrix> getCovarianceMatrices() {
            return this.covarianceMatrices;
        }

        public ODMMetaData getMetaData() {
            return this.metaData;
        }

        public AbsoluteDate getStartTime() {
            return this.startTime;
        }

        void setStartTime(AbsoluteDate startTime) {
            this.startTime = startTime;
        }

        public AbsoluteDate getStopTime() {
            return this.stopTime;
        }

        void setStopTime(AbsoluteDate stopTime) {
            this.stopTime = stopTime;
        }

        public AbsoluteDate getUseableStartTime() {
            return this.useableStartTime;
        }

        void setUseableStartTime(AbsoluteDate useableStartTime) {
            this.useableStartTime = useableStartTime;
        }

        public AbsoluteDate getUseableStopTime() {
            return this.useableStopTime;
        }

        void setUseableStopTime(AbsoluteDate useableStopTime) {
            this.useableStopTime = useableStopTime;
        }

        public String getInterpolationMethod() {
            return this.interpolationMethod;
        }

        void setInterpolationMethod(String interpolationMethod) {
            this.interpolationMethod = interpolationMethod;
        }

        public int getInterpolationDegree() {
            return this.interpolationDegree;
        }

        void setInterpolationDegree(int interpolationDegree) {
            this.interpolationDegree = interpolationDegree;
        }

        public boolean getHasRefFrameEpoch() {
            return this.hasRefFrameEpoch;
        }

        void setHasRefFrameEpoch(boolean hasRefFrameEpoch) {
            this.hasRefFrameEpoch = hasRefFrameEpoch;
        }

        public List<String> getEphemeridesDataLinesComment() {
            return this.ephemeridesDataLinesComment;
        }

        void setEphemeridesDataLinesComment(List<String> ephemeridesDataLinesComment) {
            this.ephemeridesDataLinesComment = new ArrayList<String>(ephemeridesDataLinesComment);
        }
    }
}

