/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.util.FastMath;
import org.orekit.bodies.CelestialBody;
import org.orekit.bodies.CelestialBodyLoader;
import org.orekit.bodies.IAUPole;
import org.orekit.bodies.IAUPoleFactory;
import org.orekit.bodies.JPLCelestialBody;
import org.orekit.bodies.PosVelChebyshev;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.errors.TimeStampedCacheException;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.utils.GenericTimeStampedCache;
import org.orekit.utils.OrekitConfiguration;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedGenerator;

public class JPLEphemeridesLoader
implements CelestialBodyLoader {
    public static final String DEFAULT_DE_SUPPORTED_NAMES = "^[lu]nx([mp](\\d\\d\\d\\d))+\\.(?:4\\d\\d)$";
    public static final String DEFAULT_INPOP_SUPPORTED_NAMES = "^inpop.*\\.dat$";
    private static final double FIFTY_DAYS = 4320000.0;
    private static final int INPOP_DE_NUMBER = 100;
    private static final int CONSTANTS_MAX_NUMBER = 400;
    private static final int HEADER_EPHEMERIS_TYPE_OFFSET = 2840;
    private static final int HEADER_RECORD_SIZE_OFFSET = 2856;
    private static final int HEADER_START_EPOCH_OFFSET = 2652;
    private static final int HEADER_END_EPOCH_OFFSET = 2660;
    private static final int HEADER_ASTRONOMICAL_UNIT_OFFSET = 2680;
    private static final int HEADER_EM_RATIO_OFFSET = 2688;
    private static final int HEADER_CHEBISHEV_INDICES_OFFSET = 2696;
    private static final int HEADER_LIBRATION_INDICES_OFFSET = 2844;
    private static final int HEADER_CHUNK_DURATION_OFFSET = 2668;
    private static final int HEADER_CONSTANTS_NAMES_OFFSET = 252;
    private static final int HEADER_CONSTANTS_VALUES_OFFSET = 0;
    private static final int DATA_START_RANGE_OFFSET = 0;
    private static final int DATE_END_RANGE_OFFSET = 8;
    private static final String CONSTANT_AU = "AU";
    private static final String CONSTANT_EMRAT = "EMRAT";
    private final String supportedNames;
    private final GenericTimeStampedCache<PosVelChebyshev> ephemerides;
    private final AtomicReference<Map<String, Double>> constants;
    private final EphemerisType generateType;
    private final EphemerisType loadType;
    private AbsoluteDate startEpoch;
    private AbsoluteDate finalEpoch;
    private double maxChunksDuration;
    private double chunksDuration;
    private int firstIndex;
    private int coeffs;
    private int chunks;
    private int components;
    private double positionUnit;
    private TimeScale timeScale;
    private boolean bigEndian;

    public JPLEphemeridesLoader(String supportedNames, EphemerisType generateType) throws OrekitException {
        this.supportedNames = supportedNames;
        this.constants = new AtomicReference();
        this.generateType = generateType;
        this.loadType = generateType == EphemerisType.SOLAR_SYSTEM_BARYCENTER ? EphemerisType.EARTH_MOON : (generateType == EphemerisType.EARTH_MOON ? EphemerisType.MOON : generateType);
        this.ephemerides = new GenericTimeStampedCache<PosVelChebyshev>(2, OrekitConfiguration.getCacheSlotsNumber(), Double.POSITIVE_INFINITY, 4320000.0, new EphemerisParser(), PosVelChebyshev.class);
        this.maxChunksDuration = Double.NaN;
        this.chunksDuration = Double.NaN;
    }

    @Override
    public CelestialBody loadCelestialBody(String name) throws OrekitException {
        RawPVProvider rawPVProvider;
        Frame definingFrameAlignedWithICRF;
        double scale;
        double gm = this.getLoadedGravitationalCoefficient(this.generateType);
        IAUPole iauPole = IAUPoleFactory.getIAUPole(this.generateType);
        switch (this.generateType) {
            case SOLAR_SYSTEM_BARYCENTER: {
                scale = -1.0;
                JPLEphemeridesLoader parentLoader = new JPLEphemeridesLoader(this.supportedNames, EphemerisType.EARTH_MOON);
                CelestialBody parentBody = parentLoader.loadCelestialBody("Earth-Moon barycenter");
                definingFrameAlignedWithICRF = parentBody.getInertiallyOrientedFrame();
                rawPVProvider = new EphemerisRawPVProvider();
                break;
            }
            case EARTH_MOON: {
                scale = 1.0 / (1.0 + this.getLoadedEarthMoonMassRatio());
                definingFrameAlignedWithICRF = FramesFactory.getGCRF();
                rawPVProvider = new EphemerisRawPVProvider();
                break;
            }
            case EARTH: {
                scale = 1.0;
                definingFrameAlignedWithICRF = FramesFactory.getGCRF();
                rawPVProvider = new ZeroRawPVProvider();
                break;
            }
            case MOON: {
                scale = 1.0;
                definingFrameAlignedWithICRF = FramesFactory.getGCRF();
                rawPVProvider = new EphemerisRawPVProvider();
                break;
            }
            default: {
                scale = 1.0;
                JPLEphemeridesLoader parentLoader = new JPLEphemeridesLoader(this.supportedNames, EphemerisType.SOLAR_SYSTEM_BARYCENTER);
                CelestialBody parentBody = parentLoader.loadCelestialBody("solar system barycenter");
                definingFrameAlignedWithICRF = parentBody.getInertiallyOrientedFrame();
                rawPVProvider = new EphemerisRawPVProvider();
            }
        }
        return new JPLCelestialBody(name, this.supportedNames, this.generateType, rawPVProvider, gm, scale, iauPole, definingFrameAlignedWithICRF);
    }

    public double getLoadedAstronomicalUnit() throws OrekitException {
        return 1000.0 * this.getLoadedConstant(CONSTANT_AU);
    }

    public double getLoadedEarthMoonMassRatio() throws OrekitException {
        return this.getLoadedConstant(CONSTANT_EMRAT);
    }

    public double getLoadedGravitationalCoefficient(EphemerisType body) throws OrekitException {
        double rawGM;
        switch (body) {
            case SOLAR_SYSTEM_BARYCENTER: {
                return this.getLoadedGravitationalCoefficient(EphemerisType.SUN) + this.getLoadedGravitationalCoefficient(EphemerisType.MERCURY) + this.getLoadedGravitationalCoefficient(EphemerisType.VENUS) + this.getLoadedGravitationalCoefficient(EphemerisType.EARTH_MOON) + this.getLoadedGravitationalCoefficient(EphemerisType.MARS) + this.getLoadedGravitationalCoefficient(EphemerisType.JUPITER) + this.getLoadedGravitationalCoefficient(EphemerisType.SATURN) + this.getLoadedGravitationalCoefficient(EphemerisType.URANUS) + this.getLoadedGravitationalCoefficient(EphemerisType.NEPTUNE) + this.getLoadedGravitationalCoefficient(EphemerisType.PLUTO);
            }
            case SUN: {
                rawGM = this.getLoadedConstant("GMS", "GM_Sun");
                break;
            }
            case MERCURY: {
                rawGM = this.getLoadedConstant("GM1", "GM_Mer");
                break;
            }
            case VENUS: {
                rawGM = this.getLoadedConstant("GM2", "GM_Ven");
                break;
            }
            case EARTH_MOON: {
                rawGM = this.getLoadedConstant("GMB", "GM_EMB");
                break;
            }
            case EARTH: {
                return this.getLoadedEarthMoonMassRatio() * this.getLoadedGravitationalCoefficient(EphemerisType.MOON);
            }
            case MOON: {
                return this.getLoadedGravitationalCoefficient(EphemerisType.EARTH_MOON) / (1.0 + this.getLoadedEarthMoonMassRatio());
            }
            case MARS: {
                rawGM = this.getLoadedConstant("GM4", "GM_Mar");
                break;
            }
            case JUPITER: {
                rawGM = this.getLoadedConstant("GM5", "GM_Jup");
                break;
            }
            case SATURN: {
                rawGM = this.getLoadedConstant("GM6", "GM_Sat");
                break;
            }
            case URANUS: {
                rawGM = this.getLoadedConstant("GM7", "GM_Ura");
                break;
            }
            case NEPTUNE: {
                rawGM = this.getLoadedConstant("GM8", "GM_Nep");
                break;
            }
            case PLUTO: {
                rawGM = this.getLoadedConstant("GM9", "GM_Plu");
                break;
            }
            default: {
                throw OrekitException.createInternalError(null);
            }
        }
        double au = this.getLoadedAstronomicalUnit();
        return rawGM * au * au * au / 7.46496E9;
    }

    public double getLoadedConstant(String ... names) throws OrekitException {
        Map<String, Double> map = this.constants.get();
        if (map == null) {
            ConstantsParser parser = new ConstantsParser();
            if (!DataProvidersManager.getInstance().feed(this.supportedNames, parser)) {
                throw new OrekitException((Localizable)OrekitMessages.NO_JPL_EPHEMERIDES_BINARY_FILES_FOUND, new Object[0]);
            }
            map = parser.getConstants();
            this.constants.compareAndSet(null, map);
        }
        for (String name : names) {
            if (!map.containsKey(name)) continue;
            return map.get(name);
        }
        return Double.NaN;
    }

    public double getMaxChunksDuration() {
        return this.maxChunksDuration;
    }

    private void parseFirstHeaderRecord(byte[] record, String name) throws OrekitException {
        int deNum = this.extractInt(record, 2840);
        this.components = 3;
        this.positionUnit = 1000.0;
        this.timeScale = TimeScalesFactory.getTDB();
        if (deNum == 100) {
            double timesc;
            double unite;
            double format = this.getLoadedConstant("FORMAT");
            if (!Double.isNaN(format) && (int)FastMath.IEEEremainder((double)format, (double)10.0) != 1) {
                this.components = 6;
            }
            if (!Double.isNaN(unite = this.getLoadedConstant("UNITE")) && (int)unite == 0) {
                this.positionUnit = this.getLoadedAstronomicalUnit();
            }
            if (!Double.isNaN(timesc = this.getLoadedConstant("TIMESC")) && (int)timesc == 1) {
                this.timeScale = TimeScalesFactory.getTCB();
            }
        }
        this.startEpoch = this.extractDate(record, 2652);
        this.finalEpoch = this.extractDate(record, 2660);
        boolean ok = this.finalEpoch.compareTo(this.startEpoch) > 0;
        for (int i = 0; i < 12; ++i) {
            int row1 = this.extractInt(record, 2696 + 12 * i);
            int row2 = this.extractInt(record, 2700 + 12 * i);
            int row3 = this.extractInt(record, 2704 + 12 * i);
            boolean bl = ok = ok && row1 >= 0 && row2 >= 0 && row3 >= 0;
            if (!(i == 0 && this.loadType == EphemerisType.MERCURY || i == 1 && this.loadType == EphemerisType.VENUS || i == 2 && this.loadType == EphemerisType.EARTH_MOON || i == 3 && this.loadType == EphemerisType.MARS || i == 4 && this.loadType == EphemerisType.JUPITER || i == 5 && this.loadType == EphemerisType.SATURN || i == 6 && this.loadType == EphemerisType.URANUS || i == 7 && this.loadType == EphemerisType.NEPTUNE || i == 8 && this.loadType == EphemerisType.PLUTO || i == 9 && this.loadType == EphemerisType.MOON) && (i != 10 || this.loadType != EphemerisType.SUN)) continue;
            this.firstIndex = row1;
            this.coeffs = row2;
            this.chunks = row3;
        }
        double timeSpan = this.extractDouble(record, 2668);
        ok = ok && timeSpan > 0.0 && timeSpan < 100.0;
        this.chunksDuration = 86400.0 * (timeSpan / (double)this.chunks);
        this.maxChunksDuration = Double.isNaN(this.maxChunksDuration) ? this.chunksDuration : FastMath.max((double)this.maxChunksDuration, (double)this.chunksDuration);
        if (!ok) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_A_JPL_EPHEMERIDES_BINARY_FILE, name);
        }
    }

    private byte[] readFirstRecord(InputStream input, String name) throws OrekitException, IOException {
        byte[] firstPart = new byte[2860];
        if (!this.readInRecord(input, firstPart, 0)) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_READ_JPL_HEADER, name);
        }
        this.detectEndianess(firstPart);
        int deNum = this.extractInt(firstPart, 2840);
        int recordSize = 0;
        recordSize = deNum == 100 ? this.extractInt(firstPart, 2856) << 3 : this.computeRecordSize(firstPart, name);
        if (recordSize <= 0) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_READ_JPL_HEADER, name);
        }
        int start = firstPart.length;
        byte[] record = new byte[recordSize];
        System.arraycopy(firstPart, 0, record, 0, firstPart.length);
        if (!this.readInRecord(input, record, start)) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_READ_JPL_HEADER, name);
        }
        return record;
    }

    private Map<String, Double> parseConstants(byte[] first, byte[] second, String name) {
        String constantName;
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (int i = 0; i < 400 && (constantName = this.extractString(first, 252 + i * 6, 6)).length() != 0; ++i) {
            double constantValue = this.extractDouble(second, 0 + 8 * i);
            map.put(constantName, constantValue);
        }
        if (!map.containsKey(CONSTANT_AU)) {
            map.put(CONSTANT_AU, this.extractDouble(first, 2680));
        }
        if (!map.containsKey(CONSTANT_EMRAT)) {
            map.put(CONSTANT_EMRAT, this.extractDouble(first, 2688));
        }
        return map;
    }

    private boolean readInRecord(InputStream input, byte[] record, int start) throws IOException {
        int n;
        for (int index = start; index != record.length; index += n) {
            n = input.read(record, index, record.length - index);
            if (n >= 0) continue;
            return false;
        }
        return true;
    }

    private void detectEndianess(byte[] record) {
        this.bigEndian = true;
        long deNum = (long)this.extractInt(record, 2840) & 0xFFFFFFFFL;
        if (deNum > 32768L) {
            this.bigEndian = false;
        }
    }

    private int computeRecordSize(byte[] record, String name) throws OrekitException {
        int recordSize = 0;
        boolean ok = true;
        int nComp = 3;
        for (int j = 0; j < 12; ++j) {
            int nCompCur = j == 11 ? 2 : 3;
            int idx = 2696 + j * 3 * 4;
            int coeffPtr1 = this.extractInt(record, idx + 4);
            int coeffPtr2 = this.extractInt(record, idx + 8);
            ok = ok && (coeffPtr1 >= 0 || coeffPtr2 >= 0);
            recordSize += coeffPtr1 * coeffPtr2 * nCompCur;
        }
        int libratPtr1 = this.extractInt(record, 2848);
        int libratPtr2 = this.extractInt(record, 2852);
        ok = ok && (libratPtr1 >= 0 || libratPtr2 >= 0);
        recordSize += libratPtr1 * libratPtr2 * 3 + 2;
        if (!ok || (recordSize <<= 3) <= 0) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_A_JPL_EPHEMERIDES_BINARY_FILE, name);
        }
        return recordSize;
    }

    private AbsoluteDate extractDate(byte[] record, int offset) {
        int jDay;
        double t = this.extractDouble(record, offset);
        double seconds = (t + 0.5 - (double)(jDay = (int)FastMath.floor((double)t))) * 86400.0;
        if (seconds >= 86400.0) {
            ++jDay;
            seconds -= 86400.0;
        }
        return new AbsoluteDate(new DateComponents(DateComponents.JULIAN_EPOCH, jDay), new TimeComponents(seconds), this.timeScale);
    }

    private double extractDouble(byte[] record, int offset) {
        long l8 = (long)record[offset + 0] & 0xFFL;
        long l7 = (long)record[offset + 1] & 0xFFL;
        long l6 = (long)record[offset + 2] & 0xFFL;
        long l5 = (long)record[offset + 3] & 0xFFL;
        long l4 = (long)record[offset + 4] & 0xFFL;
        long l3 = (long)record[offset + 5] & 0xFFL;
        long l2 = (long)record[offset + 6] & 0xFFL;
        long l1 = (long)record[offset + 7] & 0xFFL;
        long l = this.bigEndian ? l8 << 56 | l7 << 48 | l6 << 40 | l5 << 32 | l4 << 24 | l3 << 16 | l2 << 8 | l1 : l1 << 56 | l2 << 48 | l3 << 40 | l4 << 32 | l5 << 24 | l6 << 16 | l7 << 8 | l8;
        return Double.longBitsToDouble(l);
    }

    private int extractInt(byte[] record, int offset) {
        int l4 = record[offset + 0] & 0xFF;
        int l3 = record[offset + 1] & 0xFF;
        int l2 = record[offset + 2] & 0xFF;
        int l1 = record[offset + 3] & 0xFF;
        if (this.bigEndian) {
            return l4 << 24 | l3 << 16 | l2 << 8 | l1;
        }
        return l1 << 24 | l2 << 16 | l3 << 8 | l4;
    }

    private String extractString(byte[] record, int offset, int length) {
        try {
            return new String(record, offset, length, "US-ASCII").trim();
        }
        catch (UnsupportedEncodingException uee) {
            throw OrekitException.createInternalError(uee);
        }
    }

    private static class ZeroRawPVProvider
    implements RawPVProvider {
        private ZeroRawPVProvider() {
        }

        @Override
        public PVCoordinates getRawPV(AbsoluteDate date) {
            return PVCoordinates.ZERO;
        }
    }

    private class EphemerisRawPVProvider
    implements RawPVProvider {
        private EphemerisRawPVProvider() {
        }

        @Override
        public PVCoordinates getRawPV(AbsoluteDate date) throws TimeStampedCacheException {
            PosVelChebyshev chebyshev;
            block2: {
                try {
                    chebyshev = (PosVelChebyshev)JPLEphemeridesLoader.this.ephemerides.getNeighbors(date).get(0);
                }
                catch (TimeStampedCacheException tce) {
                    chebyshev = (PosVelChebyshev)JPLEphemeridesLoader.this.ephemerides.getLatest();
                    if (chebyshev.inRange(date)) break block2;
                    throw tce;
                }
            }
            return chebyshev.getPositionVelocityAcceleration(date);
        }
    }

    private class EphemerisParser
    implements DataLoader,
    TimeStampedGenerator<PosVelChebyshev> {
        private final SortedSet<PosVelChebyshev> entries;
        private AbsoluteDate start;
        private AbsoluteDate end;

        public EphemerisParser() {
            this.entries = new TreeSet<PosVelChebyshev>(new Comparator<PosVelChebyshev>(){

                @Override
                public int compare(PosVelChebyshev o1, PosVelChebyshev o2) {
                    return o1.getDate().compareTo(o2.getDate());
                }
            });
        }

        @Override
        public List<PosVelChebyshev> generate(PosVelChebyshev existing, AbsoluteDate date) throws TimeStampedCacheException {
            try {
                this.entries.clear();
                if (existing == null) {
                    this.start = date.shiftedBy(-4320000.0);
                    this.end = date.shiftedBy(4320000.0);
                } else if (existing.getDate().compareTo(date) <= 0) {
                    this.start = existing.getDate();
                    this.end = date;
                } else {
                    this.start = date;
                    this.end = existing.getDate();
                }
                if (!DataProvidersManager.getInstance().feed(JPLEphemeridesLoader.this.supportedNames, this)) {
                    throw new OrekitException((Localizable)OrekitMessages.NO_JPL_EPHEMERIDES_BINARY_FILES_FOUND, new Object[0]);
                }
                return new ArrayList<PosVelChebyshev>(this.entries);
            }
            catch (OrekitException oe) {
                throw new TimeStampedCacheException(oe);
            }
        }

        @Override
        public boolean stillAcceptsData() {
            if (JPLEphemeridesLoader.this.generateType == EphemerisType.EARTH) {
                return false;
            }
            if (this.entries.isEmpty()) {
                return true;
            }
            return this.entries.first().getDate().compareTo(this.start) >= 0 || this.entries.last().getDate().compareTo(this.end) <= 0;
        }

        @Override
        public void loadData(InputStream input, String name) throws OrekitException, IOException {
            double au;
            byte[] first = JPLEphemeridesLoader.this.readFirstRecord(input, name);
            byte[] second = new byte[first.length];
            if (!JPLEphemeridesLoader.this.readInRecord(input, second, 0)) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_READ_JPL_HEADER, name);
            }
            if (JPLEphemeridesLoader.this.constants.get() == null) {
                JPLEphemeridesLoader.this.constants.compareAndSet(null, JPLEphemeridesLoader.this.parseConstants(first, second, name));
            }
            if ((au = 1000.0 * JPLEphemeridesLoader.this.extractDouble(first, 2680)) < 1.4E11 || au > 1.6E11) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_A_JPL_EPHEMERIDES_BINARY_FILE, name);
            }
            if (FastMath.abs((double)(JPLEphemeridesLoader.this.getLoadedAstronomicalUnit() - au)) >= 10.0) {
                throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_ASTRONOMICAL_UNIT_IN_FILES, JPLEphemeridesLoader.this.getLoadedAstronomicalUnit(), au);
            }
            double emRat = JPLEphemeridesLoader.this.extractDouble(first, 2688);
            if (emRat < 80.0 || emRat > 82.0) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_A_JPL_EPHEMERIDES_BINARY_FILE, name);
            }
            if (FastMath.abs((double)(JPLEphemeridesLoader.this.getLoadedEarthMoonMassRatio() - emRat)) >= 1.0E-5) {
                throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_EARTH_MOON_RATIO_IN_FILES, JPLEphemeridesLoader.this.getLoadedEarthMoonMassRatio(), emRat);
            }
            JPLEphemeridesLoader.this.parseFirstHeaderRecord(first, name);
            if (JPLEphemeridesLoader.this.startEpoch.compareTo(this.end) < 0 && JPLEphemeridesLoader.this.finalEpoch.compareTo(this.start) > 0) {
                byte[] record = new byte[first.length];
                while (JPLEphemeridesLoader.this.readInRecord(input, record, 0)) {
                    AbsoluteDate rangeStart = this.parseDataRecord(record);
                    if (rangeStart.compareTo(this.end) <= 0) continue;
                    return;
                }
            }
        }

        private AbsoluteDate parseDataRecord(byte[] record) throws OrekitException {
            AbsoluteDate rangeStart = JPLEphemeridesLoader.this.extractDate(record, 0);
            if (rangeStart.compareTo(JPLEphemeridesLoader.this.startEpoch) < 0) {
                throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE, rangeStart, JPLEphemeridesLoader.this.startEpoch, JPLEphemeridesLoader.this.finalEpoch);
            }
            AbsoluteDate rangeEnd = JPLEphemeridesLoader.this.extractDate(record, 8);
            if (rangeEnd.compareTo(JPLEphemeridesLoader.this.finalEpoch) > 0) {
                throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE, rangeEnd, JPLEphemeridesLoader.this.startEpoch, JPLEphemeridesLoader.this.finalEpoch);
            }
            if (rangeStart.compareTo(this.end) > 0 || rangeEnd.compareTo(this.start) < 0) {
                return rangeEnd;
            }
            AbsoluteDate chunkEnd = rangeStart;
            int nbChunks = JPLEphemeridesLoader.this.chunks;
            int nbCoeffs = JPLEphemeridesLoader.this.coeffs;
            int first = JPLEphemeridesLoader.this.firstIndex;
            double duration = JPLEphemeridesLoader.this.chunksDuration;
            for (int i = 0; i < nbChunks; ++i) {
                AbsoluteDate chunkStart = chunkEnd;
                chunkEnd = i == nbChunks - 1 ? rangeEnd : rangeStart.shiftedBy((double)(i + 1) * duration);
                double[] xCoeffs = new double[nbCoeffs];
                double[] yCoeffs = new double[nbCoeffs];
                double[] zCoeffs = new double[nbCoeffs];
                for (int k = 0; k < nbCoeffs; ++k) {
                    int index = first + JPLEphemeridesLoader.this.components * i * nbCoeffs + k - 1;
                    xCoeffs[k] = JPLEphemeridesLoader.this.positionUnit * JPLEphemeridesLoader.this.extractDouble(record, 8 * index);
                    yCoeffs[k] = JPLEphemeridesLoader.this.positionUnit * JPLEphemeridesLoader.this.extractDouble(record, 8 * (index + nbCoeffs));
                    zCoeffs[k] = JPLEphemeridesLoader.this.positionUnit * JPLEphemeridesLoader.this.extractDouble(record, 8 * (index + 2 * nbCoeffs));
                }
                this.entries.add(new PosVelChebyshev(chunkStart, duration, xCoeffs, yCoeffs, zCoeffs));
            }
            return rangeStart;
        }
    }

    private class ConstantsParser
    implements DataLoader {
        private Map<String, Double> localConstants;

        private ConstantsParser() {
        }

        public Map<String, Double> getConstants() {
            return this.localConstants;
        }

        @Override
        public boolean stillAcceptsData() {
            return this.localConstants == null;
        }

        @Override
        public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
            byte[] first = JPLEphemeridesLoader.this.readFirstRecord(input, name);
            byte[] second = new byte[first.length];
            if (!JPLEphemeridesLoader.this.readInRecord(input, second, 0)) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_READ_JPL_HEADER, name);
            }
            this.localConstants = JPLEphemeridesLoader.this.parseConstants(first, second, name);
        }
    }

    public static interface RawPVProvider {
        public PVCoordinates getRawPV(AbsoluteDate var1) throws OrekitException;
    }

    public static enum EphemerisType {
        SOLAR_SYSTEM_BARYCENTER,
        SUN,
        MERCURY,
        VENUS,
        EARTH_MOON,
        EARTH,
        MOON,
        MARS,
        JUPITER,
        SATURN,
        URANUS,
        NEPTUNE,
        PLUTO;

    }
}

