/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.AttitudeProviderModifier;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;

public class SpinStabilized
implements AttitudeProviderModifier {
    private static final long serialVersionUID = -7025790361794748354L;
    private final AttitudeProvider nonRotatingLaw;
    private final AbsoluteDate start;
    private final Vector3D axis;
    private final double rate;
    private final Vector3D spin;

    public SpinStabilized(AttitudeProvider nonRotatingLaw, AbsoluteDate start, Vector3D axis, double rate) {
        this.nonRotatingLaw = nonRotatingLaw;
        this.start = start;
        this.axis = axis;
        this.rate = rate;
        this.spin = new Vector3D(rate / axis.getNorm(), axis);
    }

    @Override
    public AttitudeProvider getUnderlyingAttitudeProvider() {
        return this.nonRotatingLaw;
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        Attitude base = this.nonRotatingLaw.getAttitude(pvProv, date, frame);
        Transform baseTransform = new Transform(date, base.getOrientation());
        Transform spinInfluence = new Transform(date, new Rotation(this.axis, -this.rate * date.durationFrom(this.start)), this.spin);
        Transform combined = new Transform(date, baseTransform, spinInfluence);
        return new Attitude(date, frame, combined.getRotation(), combined.getRotationRate(), combined.getRotationAcceleration());
    }
}

