/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;

public class InertialProvider
implements AttitudeProvider {
    public static final InertialProvider EME2000_ALIGNED = new InertialProvider(Rotation.IDENTITY);
    private static final long serialVersionUID = -818658655669855332L;
    private final Frame satelliteFrame;

    public InertialProvider(Rotation rotation) {
        this.satelliteFrame = new Frame((Frame)FramesFactory.getEME2000(), new Transform(AbsoluteDate.J2000_EPOCH, rotation), null, false);
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        Transform t = frame.getTransformTo(this.satelliteFrame, date);
        return new Attitude(date, frame, t.getRotation(), t.getRotationRate(), t.getRotationAcceleration());
    }
}

