/*
 * Decompiled with CFR 0.152.
 */
package dopplerpsk.util;

import dopplerpsk.util.Sqf;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SqfParser {
    private final Map<String, Sqf> sqfMap;
    private final File file;

    public SqfParser(File f) {
        this.file = f;
        this.sqfMap = new TreeMap<String, Sqf>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws FileNotFoundException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this.file));
            String line = br.readLine();
            while (line != null) {
                line = line.trim();
                try {
                    if (!line.startsWith(";") && line.length() > 0) {
                        String[] strs = line.split(",");
                        String name = strs[0];
                        double downlinkHz = Double.parseDouble(strs[1]) * 1000.0;
                        double uplinkHz = Double.parseDouble(strs[2]) * 1000.0;
                        boolean isRev = "REV".equalsIgnoreCase(strs[5]);
                        Sqf sqf = new Sqf(name, downlinkHz, uplinkHz, isRev);
                        System.out.println(sqf.getName());
                        this.sqfMap.put(name, sqf);
                    }
                }
                catch (Exception e) {
                    System.out.println("Error reading sqf line: " + line);
                    e.printStackTrace();
                }
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SqfParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SqfParser.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public Sqf getSqf(String name) {
        return this.sqfMap.get(name);
    }
}

