/*
 * Decompiled with CFR 0.152.
 */
package dopplerpsk.util;

import dopplerpsk.Macro;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;

public class MacroParser {
    private final File macroDir;
    private Map<String, Macro> macroMap;

    public MacroParser(File macroDir) {
        this.macroDir = macroDir;
    }

    public void loadMacros() {
        this.macroMap = new TreeMap<String, Macro>();
        if (!this.macroDir.exists()) {
            System.out.println("Macro dir does not exist.  No macros will be loaded.");
        } else {
            File[] files;
            for (File f : files = this.macroDir.listFiles()) {
                Macro m;
                if (!f.getName().endsWith(".txt") || (m = this.parse(f)) == null) continue;
                this.macroMap.put(f.getName(), m);
            }
        }
    }

    public Macro getMacro(String name) {
        return this.macroMap.get(name);
    }

    public Map<String, Macro> getMacroMap() {
        return this.macroMap;
    }

    private Macro parse(File macroFile) {
        Macro m = null;
        try {
            String s = FileUtils.readFileToString(macroFile);
            JSONObject obj = new JSONObject(s);
            String text = obj.getString("text");
            m = new Macro(text);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return m;
    }
}

