/*
 * Decompiled with CFR 0.152.
 */
package dopplerpsk.util;

import java.util.Map;
import java.util.TreeMap;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class AudioConfiguration {
    private static Map<String, Mixer.Info> audioMap = new TreeMap<String, Mixer.Info>();

    public static String[] getMixerNames() {
        return audioMap.keySet().toArray(new String[0]);
    }

    public static Mixer.Info getMixerInfoFromName(String name) {
        return audioMap.get(name);
    }

    public static void findAudioConfigurations() {
        Mixer.Info[] minfoSet;
        for (Mixer.Info minfo : minfoSet = AudioSystem.getMixerInfo()) {
            Mixer m = AudioSystem.getMixer(minfo);
            Line.Info[] tlines = m.getSourceLineInfo();
            if (tlines.length <= 0) continue;
            System.out.println("   " + minfo.toString());
            audioMap.put(minfo.toString(), minfo);
            System.out.println("      " + tlines.length + " Source lines:");
            for (Line.Info t : tlines) {
                System.out.println("        " + t.toString());
            }
        }
    }

    public static SourceDataLine getSourceDataLine(String mixerInfoString, AudioFormat format) throws LineUnavailableException {
        SourceDataLine line = null;
        if (mixerInfoString == null) {
            line = AudioSystem.getSourceDataLine(format);
        } else {
            Mixer.Info[] minfoSet;
            for (Mixer.Info minfo : minfoSet = AudioSystem.getMixerInfo()) {
                if (!minfo.toString().equals(mixerInfoString)) continue;
                line = AudioSystem.getSourceDataLine(format, minfo);
            }
        }
        if (line == null) {
            line = AudioSystem.getSourceDataLine(format);
        }
        return line;
    }
}

