/*
 * Decompiled with CFR 0.152.
 */
package dopplerpsk.ui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class StationInfoDialog
extends JDialog {
    public static final int CANCEL_ACTION = 0;
    public static final int OK_ACTION = 1;
    private static final DecimalFormat degFormat = new DecimalFormat("0.000###");
    private int userAction = 0;
    private double lat;
    private double lon;
    private double alt;
    private JTextField altTextField;
    private JButton cancelButton;
    private JRadioButton eastRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private ButtonGroup latButtonGroup;
    private JTextField latTextField;
    private ButtonGroup lonButtonGroup;
    private JTextField lonTextField;
    private JRadioButton northRadioButton;
    private JButton okButton;
    private JRadioButton southRadioButton;
    private JRadioButton westRadioButton;

    public StationInfoDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public StationInfoDialog(Frame parent, double latitude, double longitude, double altitude, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.lat = latitude;
        this.lon = longitude;
        this.alt = altitude;
        if (this.lat < 0.0) {
            this.latTextField.setText(degFormat.format(-this.lat));
            this.southRadioButton.setSelected(true);
        } else {
            this.latTextField.setText(degFormat.format(this.lat));
            this.northRadioButton.setSelected(true);
        }
        if (longitude < 0.0) {
            this.lonTextField.setText(degFormat.format(-this.lon));
            this.westRadioButton.setSelected(true);
        } else {
            this.lonTextField.setText(degFormat.format(this.lon));
            this.eastRadioButton.setSelected(true);
        }
        this.altTextField.setText("" + (int)Math.round(this.alt));
    }

    public int getUserAction() {
        return this.userAction;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public double getAlt() {
        return this.alt;
    }

    private void initComponents() {
        this.latButtonGroup = new ButtonGroup();
        this.lonButtonGroup = new ButtonGroup();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.latTextField = new JTextField();
        this.lonTextField = new JTextField();
        this.altTextField = new JTextField();
        this.northRadioButton = new JRadioButton();
        this.southRadioButton = new JRadioButton();
        this.eastRadioButton = new JRadioButton();
        this.westRadioButton = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Set Station Location");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationInfoDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationInfoDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Latitude:");
        this.jLabel2.setText("Longitude:");
        this.jLabel3.setText("Altitude (meters)");
        this.latTextField.setHorizontalAlignment(11);
        this.latTextField.setText("0.0");
        this.lonTextField.setHorizontalAlignment(11);
        this.lonTextField.setText("0.0");
        this.altTextField.setHorizontalAlignment(11);
        this.altTextField.setText("0.0");
        this.latButtonGroup.add(this.northRadioButton);
        this.northRadioButton.setText("N");
        this.latButtonGroup.add(this.southRadioButton);
        this.southRadioButton.setText("S");
        this.lonButtonGroup.add(this.eastRadioButton);
        this.eastRadioButton.setText("E");
        this.lonButtonGroup.add(this.westRadioButton);
        this.westRadioButton.setText("W");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel1)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.latTextField).addComponent(this.altTextField, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.lonTextField, -2, 102, -2).addGap(0, 0, Short.MAX_VALUE))).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.northRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.southRadioButton)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.eastRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.westRadioButton))).addGap(31, 31, 31)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.latTextField, -2, -1, -2).addComponent(this.northRadioButton).addComponent(this.southRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.lonTextField, -2, -1, -2).addComponent(this.eastRadioButton).addComponent(this.westRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.altTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cancelButton, -1, -1, Short.MAX_VALUE).addComponent(this.okButton, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addGap(0, 44, Short.MAX_VALUE))).addContainerGap()));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        double altitude;
        double longitude;
        double latitude;
        try {
            latitude = Double.parseDouble(this.latTextField.getText());
            if (latitude < 0.0) {
                JOptionPane.showMessageDialog(this.rootPane, "Latitude cannot be negative.");
                return;
            }
            if (this.southRadioButton.isSelected()) {
                latitude = -latitude;
            }
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            JOptionPane.showMessageDialog(this.rootPane, "Latitude is not a valid number.");
            return;
        }
        try {
            longitude = Double.parseDouble(this.lonTextField.getText());
            if (longitude < 0.0) {
                JOptionPane.showMessageDialog(this.rootPane, "Longitude cannot be negative.");
                return;
            }
            if (this.westRadioButton.isSelected()) {
                longitude = -longitude;
            }
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            JOptionPane.showMessageDialog(this.rootPane, "Longitude is not a valid number.");
            return;
        }
        try {
            altitude = Double.parseDouble(this.altTextField.getText());
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            JOptionPane.showMessageDialog(this.rootPane, "Altitude is not a valid number.");
            return;
        }
        this.userAction = 1;
        this.lat = latitude;
        this.lon = longitude;
        this.alt = altitude;
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.userAction = 0;
        this.dispose();
    }
}

