/*
 * Decompiled with CFR 0.152.
 */
package dopplerpsk.ui;

import dopplerpsk.Macro;
import dopplerpsk.event.IMessageChangedListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class MessagePanel
extends JPanel {
    private Macro macro;
    private String mycall;
    private String dxcall;
    private String exchange;
    private IMessageChangedListener messageChangedListener;
    private JTextField messageTextField;
    private JRadioButton selectButton;

    public MessagePanel() {
        this.initComponents();
    }

    public MessagePanel(Macro m, ButtonGroup bg, String mycall, String dxcall, String exchange, IMessageChangedListener l) {
        this.mycall = mycall;
        this.dxcall = dxcall;
        this.exchange = exchange;
        this.messageChangedListener = l;
        this.initComponents();
        this.initialize(m);
        bg.add(this.selectButton);
    }

    private void initComponents() {
        this.messageTextField = new JTextField();
        this.selectButton = new JRadioButton();
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessagePanel.this.selectButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.messageTextField, -1, 403, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.messageTextField, -2, -1, -2).addComponent(this.selectButton)));
    }

    private void selectButtonActionPerformed(ActionEvent evt) {
        if (this.selectButton.isSelected() && this.messageChangedListener != null) {
            this.messageChangedListener.messageChanged(this.getFormattedMessage());
        }
    }

    private void initialize(Macro m) {
        this.macro = m;
        this.messageTextField.setText(this.formatMessage(m.getText()));
    }

    public String getFormattedMessage() {
        return this.messageTextField.getText();
    }

    public boolean isSelected() {
        return this.selectButton.isSelected();
    }

    public void update(String myCall, String dxCall, String exchange) {
        this.mycall = myCall;
        this.dxcall = dxCall;
        this.exchange = exchange;
        this.messageTextField.setText(this.formatMessage(this.macro.getText()));
    }

    private String formatMessage(String text) {
        text = text.replaceAll("MYCALL", this.mycall);
        text = text.replaceAll("DXCALL", this.dxcall);
        text = text.replaceAll("EXCHANGE", this.exchange);
        return text;
    }
}

