/*
 * Decompiled with CFR 0.152.
 */
package dopplerpsk.event;

import dopplerpsk.Satellite;
import dopplerpsk.event.ISatelliteEventSink;
import dopplerpsk.event.ISatelliteEventSource;
import dopplerpsk.event.SatelliteUpdateEvent;
import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.data.DataProvider;
import org.orekit.data.DataProvidersManager;
import org.orekit.data.DirectoryCrawler;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.frames.TopocentricFrame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.PVCoordinates;

public class OrekitSatelliteEventSource
implements ISatelliteEventSource {
    private static final double ae = 6378137.0;
    private static final double f = 0.0033528106647474805;
    private static final double c = 2.9970464453915E8;
    private final Frame IRTF2008;
    private final TLEPropagator prop;
    private final BodyShape earth;
    private final GeodeticPoint station;
    private final Set<ISatelliteEventSink> listeners = new HashSet<ISatelliteEventSink>();
    private final long updateInterval;
    private Timer timer;
    private final double uplinkFreq;
    private final String satName;

    public OrekitSatelliteEventSource(Satellite sat, double stationLat, double stationLon, double stationAltMeters, double uplinkFreq, double updateIntervalSeconds) throws OrekitException {
        this.updateInterval = (long)(updateIntervalSeconds * 1000.0);
        this.uplinkFreq = uplinkFreq;
        DataProvidersManager.getInstance().addProvider((DataProvider)new DirectoryCrawler(new File(".")));
        this.IRTF2008 = FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)true);
        this.earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, this.IRTF2008);
        this.satName = sat.getName();
        this.station = new GeodeticPoint(stationLat, stationLon, stationAltMeters);
        TLE tle = new TLE(sat.getTleLine1(), sat.getTleLine2());
        this.prop = TLEPropagator.selectExtrapolator((TLE)tle);
    }

    @Override
    public synchronized void start() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    OrekitSatelliteEventSource.this.calc();
                }
                catch (OrekitException ex) {
                    Logger.getLogger(OrekitSatelliteEventSource.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        this.timer.scheduleAtFixedRate(task, 0L, this.updateInterval);
    }

    @Override
    public synchronized void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private void calc() throws OrekitException {
        TopocentricFrame stationFrame = new TopocentricFrame(this.earth, this.station, "earth station");
        Date nowDate = new Date();
        Date futureDate = new Date(nowDate.getTime() + this.updateInterval);
        AbsoluteDate now = new AbsoluteDate(nowDate, (TimeScale)TimeScalesFactory.getUTC());
        AbsoluteDate future = new AbsoluteDate(futureDate, (TimeScale)TimeScalesFactory.getUTC());
        SpacecraftState currentState = this.prop.propagate(now);
        SpacecraftState futureState = this.prop.propagate(future);
        double el = Math.toDegrees(stationFrame.getElevation(currentState.getPVCoordinates().getPosition(), currentState.getFrame(), currentState.getDate()));
        double az = Math.toDegrees(stationFrame.getAzimuth(currentState.getPVCoordinates().getPosition(), currentState.getFrame(), currentState.getDate()));
        double currentRangeRate = stationFrame.getRangeRate((PVCoordinates)currentState.getPVCoordinates(), currentState.getFrame(), currentState.getDate());
        double futureRangeRate = stationFrame.getRangeRate((PVCoordinates)futureState.getPVCoordinates(), futureState.getFrame(), futureState.getDate());
        double currentdf = (2.9970464453915E8 + currentRangeRate) / 2.9970464453915E8 * this.uplinkFreq - this.uplinkFreq;
        double futuredf = (2.9970464453915E8 + futureRangeRate) / 2.9970464453915E8 * this.uplinkFreq - this.uplinkFreq;
        double ddf = (futuredf - currentdf) / ((double)this.updateInterval / 1000.0);
        SatelliteUpdateEvent evt = new SatelliteUpdateEvent(this.satName, az, el, currentdf, ddf);
        this.updateListeners(evt);
    }

    private synchronized void updateListeners(SatelliteUpdateEvent evt) {
        System.out.println(evt);
        for (ISatelliteEventSink s : this.listeners) {
            s.SatelliteUpdateEventOccured(evt);
        }
    }

    @Override
    public synchronized void addEventListener(ISatelliteEventSink snk) {
        this.listeners.add(snk);
    }

    @Override
    public synchronized void removeEventListener(ISatelliteEventSink snk) {
        this.listeners.remove(snk);
    }
}

