/*
 * Decompiled with CFR 0.152.
 */
package dopplerpsk.dsp;

import dopplerpsk.dsp.DbpskDDS;
import dopplerpsk.dsp.ITxListener;
import dopplerpsk.dsp.LocalOscillator;
import dopplerpsk.dsp.Mixer;
import dopplerpsk.event.ISatelliteEventSink;
import dopplerpsk.event.SatelliteUpdateEvent;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.SourceDataLine;

public class Psk31Transmitter
implements ISatelliteEventSink {
    private final SourceDataLine line;
    private final AudioFormat format;
    private final float sampleRate;
    private final Deque<Character> txQueue;
    private final Mixer m;
    private final DbpskDDS dds;
    private final Object charLock = new Object();
    private AudioThread audioThread;
    private boolean isTx;
    private final Set<ITxListener> listeners = new HashSet<ITxListener>();
    private final double baudrate = 31.25;
    private final LocalOscillator lo;
    private Object lastName;
    private boolean isLoop;
    private String loopMessage;

    public Psk31Transmitter(SourceDataLine line, AudioFormat format, double dopplerCenter) {
        this.line = line;
        this.format = format;
        this.sampleRate = format.getSampleRate();
        this.lo = new LocalOscillator(format.getSampleRate(), dopplerCenter);
        this.m = new Mixer(this.lo);
        this.dds = new DbpskDDS(this.sampleRate, 31.25);
        this.txQueue = new LinkedList<Character>();
        this.startAudioThread();
    }

    public synchronized void addListener(ITxListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeListener(ITxListener l) {
        this.listeners.remove(l);
    }

    private void startAudioThread() {
        this.line.start();
        if (this.audioThread != null) {
            this.audioThread.kill();
        }
        this.audioThread = new AudioThread();
        this.audioThread.start();
    }

    public void stopAudioThread() {
        if (this.audioThread != null) {
            this.audioThread.kill();
        }
    }

    public void startTx() {
        this.isTx = true;
    }

    public void stopTx() {
        this.isTx = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChar() {
        Object object = this.charLock;
        synchronized (object) {
            if (!this.txQueue.isEmpty()) {
                this.txQueue.removeLast();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putChar(char c) {
        Object object = this.charLock;
        synchronized (object) {
            this.txQueue.add(Character.valueOf(c));
        }
    }

    public void putString(String s) {
        for (char c : s.toCharArray()) {
            this.putChar(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBuffer() {
        Object object = this.charLock;
        synchronized (object) {
            this.txQueue.clear();
        }
    }

    @Override
    public void SatelliteUpdateEventOccured(SatelliteUpdateEvent evt) {
        String name = evt.getName();
        if (!name.equals(this.lastName)) {
            this.lo.setInstantaneousFrequency(this.lo.getCenterFrequency() + evt.getDopplerShift());
            this.lastName = name;
        }
        if (!this.isTx) {
            this.lo.setInstantaneousFrequency(this.lo.getCenterFrequency() + evt.getDopplerShift());
        }
        this.lo.adjustCarrierFrequency(evt.getDopplerShift(), evt.getDopplerRate());
    }

    public double getCenterFrequency() {
        return this.lo.getCenterFrequency();
    }

    public double getInstantaneousFrequency() {
        return this.lo.getInstantaneousFrequency();
    }

    public void setLoop(boolean b) {
        this.isLoop = b;
        this.loopMessage = null;
    }

    public void putLoopMessage(String loop) {
        this.loopMessage = loop;
    }

    public boolean isIsLoop() {
        return this.isLoop;
    }

    class AudioThread
    extends Thread {
        private boolean kill;
        private final ByteBuffer buf;

        public AudioThread() {
            this.buf = ByteBuffer.allocate(Psk31Transmitter.this.line.getBufferSize());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.kill) {
                Character c = null;
                Object object = Psk31Transmitter.this.charLock;
                synchronized (object) {
                    if (!Psk31Transmitter.this.txQueue.isEmpty()) {
                        if (Psk31Transmitter.this.isTx) {
                            c = (Character)Psk31Transmitter.this.txQueue.poll();
                        }
                    } else if (Psk31Transmitter.this.isIsLoop()) {
                        Psk31Transmitter.this.putString(Psk31Transmitter.this.loopMessage);
                        if (Psk31Transmitter.this.isTx) {
                            c = (Character)Psk31Transmitter.this.txQueue.poll();
                        }
                    }
                }
                double[] baseBand = c == null ? Psk31Transmitter.this.dds.getSamples(null) : Psk31Transmitter.this.dds.getSamples(c.charValue());
                double[] waveform = Psk31Transmitter.this.m.mix(baseBand);
                if (!Psk31Transmitter.this.isTx) {
                    waveform = new double[waveform.length];
                }
                this.play(waveform);
                if (c == null) continue;
                this.notifyListeners(c);
            }
            Psk31Transmitter.this.line.stop();
            Psk31Transmitter.this.line.close();
        }

        private void play(double[] waveform) {
            this.buf.clear();
            for (int i = 0; i < waveform.length; ++i) {
                this.buf.putShort((short)(32767.0 * waveform[i]));
            }
            Psk31Transmitter.this.line.write(this.buf.array(), 0, this.buf.position());
        }

        private void kill() {
            this.kill = true;
        }

        private synchronized void notifyListeners(Character c) {
            for (ITxListener l : Psk31Transmitter.this.listeners) {
                l.TxCharacterSent(c);
            }
        }
    }
}

