/*
 * Decompiled with CFR 0.152.
 */
package dopplerpsk.dsp;

public class LocalOscillator {
    private double dopplerCenter = 2000.0;
    private double f0 = 2000.0;
    private volatile double k = 0.0;
    private double ph0 = 0.0;
    private double ph = 0.0;
    private double t = 0.0;
    private final double sr;
    private int sampleSinceUpdate = 0;

    public LocalOscillator(double sr, double dopplerCenter) {
        this.sr = sr;
        this.dopplerCenter = dopplerCenter;
    }

    public double getInstantaneousFrequency() {
        return this.f0;
    }

    public void setInstantaneousFrequency(double f) {
        this.f0 = f;
    }

    public double getDopplerRate() {
        return this.k;
    }

    public synchronized void adjustCarrierFrequency(double absDopplerShift, double chirpRate) {
        double elapsedTime = (double)this.sampleSinceUpdate / this.sr;
        if (this.sampleSinceUpdate > 0) {
            this.f0 += elapsedTime * this.k;
            this.ph0 = this.ph;
            this.t = 1.0 / this.sr;
        }
        this.k = chirpRate;
        this.sampleSinceUpdate = 0;
    }

    public synchronized double getNextSample() {
        this.ph = this.ph0 + Math.PI * 2 * (this.f0 * this.t + this.k / 2.0 * Math.pow(this.t, 2.0));
        this.t += 1.0 / this.sr;
        ++this.sampleSinceUpdate;
        return Math.sin(this.ph);
    }

    public double getCenterFrequency() {
        return this.dopplerCenter;
    }
}

