/*
 * Decompiled with CFR 0.152.
 */
package dopplerpsk.dsp;

import dopplerpsk.dsp.Varicode;
import java.util.Arrays;

public class DbpskDDS {
    private final double sr;
    double[] high;
    double[] low;
    double[] transition_low;
    double[] transition_high;
    private final double bitDuration;
    private final int samplesPerBit;
    boolean isHigh = false;

    public DbpskDDS(double sampleRate, double baudRate) {
        this.sr = sampleRate;
        this.bitDuration = 1.0 / baudRate;
        this.samplesPerBit = (int)Math.round(this.bitDuration * this.sr);
        this.makeDdsArrays();
    }

    public double[] getSamples(char c) {
        return this.getSamples("" + c);
    }

    public double[] getSamples(String s) {
        String pattern = Varicode.getPattern(s);
        double[] rVal = new double[pattern.length() * this.samplesPerBit];
        int pos = 0;
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            double[] bitSamples = c == '1' ? this.keepPhase() : this.reversePhase();
            System.arraycopy(bitSamples, 0, rVal, pos, bitSamples.length);
            pos += bitSamples.length;
        }
        return rVal;
    }

    private double[] keepPhase() {
        if (this.isHigh) {
            return this.high;
        }
        return this.low;
    }

    private double[] reversePhase() {
        double[] rVal = this.isHigh ? this.transition_low : this.transition_high;
        this.isHigh = !this.isHigh;
        return rVal;
    }

    private void makeDdsArrays() {
        int i;
        this.high = new double[this.samplesPerBit];
        this.low = new double[this.samplesPerBit];
        this.transition_low = new double[this.samplesPerBit];
        this.transition_high = new double[this.samplesPerBit];
        Arrays.fill(this.high, 1.0);
        Arrays.fill(this.low, -1.0);
        for (i = 0; i < this.transition_low.length; ++i) {
            this.transition_low[i] = Math.cos(Math.PI * ((double)i / (double)this.samplesPerBit));
        }
        for (i = 0; i < this.transition_high.length; ++i) {
            this.transition_high[i] = -Math.cos(Math.PI * ((double)i / (double)this.samplesPerBit));
        }
    }
}

