/*
 * Decompiled with CFR 0.152.
 */
package dopplerpsk;

import dopplerpsk.Satellite;
import dopplerpsk.util.Sqf;
import dopplerpsk.util.SqfParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SatelliteDirectory {
    private final TreeMap<String, Satellite> satelliteMap = new TreeMap();
    private final File tleDirectory;
    private final SqfParser sqfParser;

    public SatelliteDirectory(File tleDirectory, File sqf) {
        this.tleDirectory = tleDirectory;
        this.sqfParser = new SqfParser(sqf);
    }

    public String[] getSatelliteNames() {
        Set<String> names = this.satelliteMap.keySet();
        String[] arr = new String[names.size()];
        int i = 0;
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            String n;
            arr[i] = n = iterator.next();
            ++i;
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSatellites() throws FileNotFoundException {
        this.loadSqf();
        File[] tleFiles = this.tleDirectory.listFiles();
        String name = null;
        String line1 = null;
        String line2 = null;
        for (File f : tleFiles) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(f));
                String line = br.readLine();
                while (line != null) {
                    if ((line = line.trim()).startsWith("1 ")) {
                        if (name != null && !name.contains("DECODE 2-LINE")) {
                            line1 = line;
                        }
                    } else if (line.startsWith("2 ")) {
                        if (name != null && line1 != null) {
                            line2 = line;
                            double downlinkFreq = 0.0;
                            double uplinkFreq = 0.0;
                            boolean inverting = false;
                            Sqf sqf = this.sqfParser.getSqf(name);
                            if (sqf != null) {
                                downlinkFreq = sqf.getDownlinkHz();
                                uplinkFreq = sqf.getUplinkHz();
                                inverting = sqf.isRev();
                            }
                            Satellite s = new Satellite(name, line1, line2, uplinkFreq, downlinkFreq, inverting);
                            this.satelliteMap.put(name, s);
                        }
                        name = null;
                        line1 = null;
                        line2 = null;
                    } else {
                        name = line;
                    }
                    line = br.readLine();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(SatelliteDirectory.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(SatelliteDirectory.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    public Satellite getSatellite(String name) {
        return this.satelliteMap.get(name);
    }

    private void loadSqf() throws FileNotFoundException {
        this.sqfParser.parse();
    }
}

