/*
 * Decompiled with CFR 0.152.
 */
package dopplerpsk;

import dopplerpsk.Macro;
import dopplerpsk.Satellite;
import dopplerpsk.SatelliteDirectory;
import dopplerpsk.dsp.ITxListener;
import dopplerpsk.dsp.Psk31Transmitter;
import dopplerpsk.event.IMessageChangedListener;
import dopplerpsk.event.ISatelliteEventSink;
import dopplerpsk.event.ISatelliteEventSource;
import dopplerpsk.event.OrekitSatelliteEventSource;
import dopplerpsk.event.SatelliteUpdateEvent;
import dopplerpsk.ui.MessageInfoPanel;
import dopplerpsk.ui.MessagePanel;
import dopplerpsk.ui.SatelliteChooserDialog;
import dopplerpsk.ui.StationInfoDialog;
import dopplerpsk.util.AudioConfiguration;
import dopplerpsk.util.MacroParser;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.orekit.errors.OrekitException;

public class DopplerPSK
extends JFrame
implements ISatelliteEventSink,
ITxListener,
IMessageChangedListener {
    private static final DecimalFormat mhzFormat = new DecimalFormat("##0.000");
    private static final DecimalFormat decimalFormat = new DecimalFormat("##0.00");
    private static final DecimalFormat integerFormat = new DecimalFormat("#####0");
    private static final String DEFAULT_AUDIO_DEVICE_NAME = "System default audio";
    private final File tleDir = new File("tle");
    private final File sqfFile = new File("doppler.sqf");
    private ISatelliteEventSource propagator;
    private SatelliteDirectory satelliteDirectory;
    private String currentSatelliteName;
    private Psk31Transmitter tx;
    double stationLon = 0.0;
    double stationLat = 0.0;
    double stationAlt = 0.0;
    double dopplerCenter = 2000.0;
    private JCheckBoxMenuItem systemDefaultCheckBoxMenuItem;
    private String lastUsedAudioDeviceName = null;
    private SatelliteUpdateEvent lastEvt;
    private String mycall = "k0sm";
    private String dxcall = "dx0dx";
    private String exchange = "fn13";
    private MessageInfoPanel messageInfoPanel;
    private JMenu AudioDeviceMenu;
    private JMenuItem aboutMenuItem;
    private ButtonGroup audioButtonGroup;
    private JLabel azLabel;
    private JLabel centerAfFreqLabel;
    private JMenuItem chooseSatelliteMenuItem;
    private JButton clearBufferButton;
    private JLabel currentAfFreqLabel;
    private JLabel ddfLabel;
    private JLabel dopplerLabel;
    private JTextField echoTextField;
    private JLabel elLabel;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JPanel infoPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JMenu jMenu1;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator1;
    private JTabbedPane jTabbedPane1;
    private JToggleButton keyboardTxToggleButton;
    private ButtonGroup macroButtonGroup;
    private JPanel macroPanel;
    private JMenuBar menuBar;
    private JPanel messagePanel;
    private JToggleButton messageTxToggleButton;
    private JPanel satInfoPanel;
    private JLabel satNameLabel;
    private JMenu satelliteMenu;
    private JMenu stationMenu;
    private JMenuItem stationMenuItem;
    private JPanel topPanel;
    private JPanel txPanel;
    private JTextArea txTextArea;
    private JLabel uplinkFreqLabel;

    public DopplerPSK() {
        try {
            this.initComponents();
            this.loadSettings();
            this.loadSatelliteDirectory();
            this.addMacroButtons();
            AudioConfiguration.findAudioConfigurations();
            this.setupAudioCheckBoxes();
            this.loadSelectedSatellite(this.currentSatelliteName);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(DopplerPSK.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(null, ex.getMessage());
        }
    }

    private void setupAudioCheckBoxes() {
        final DopplerPSK txListener = this;
        ActionListener lis = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JCheckBoxMenuItem source = (JCheckBoxMenuItem)ae.getSource();
                System.out.println("Audio output changed to " + source.getText());
                try {
                    Psk31Transmitter newTx = DopplerPSK.this.getPsk31Tx(source.getText());
                    if (newTx != null) {
                        if (DopplerPSK.this.tx != null) {
                            DopplerPSK.this.tx.stopTx();
                            DopplerPSK.this.tx.stopAudioThread();
                        }
                        if (DopplerPSK.this.tx != null) {
                            DopplerPSK.this.tx.removeListener(txListener);
                        }
                        DopplerPSK.this.tx = newTx;
                        DopplerPSK.this.tx.addListener(txListener);
                        DopplerPSK.this.lastUsedAudioDeviceName = source.getText();
                        System.out.println(DopplerPSK.this.lastUsedAudioDeviceName);
                    }
                }
                catch (LineUnavailableException ex) {
                    Logger.getLogger(DopplerPSK.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        this.systemDefaultCheckBoxMenuItem = new JCheckBoxMenuItem(DEFAULT_AUDIO_DEVICE_NAME);
        this.systemDefaultCheckBoxMenuItem.setSelected(DEFAULT_AUDIO_DEVICE_NAME.equals(this.lastUsedAudioDeviceName));
        this.audioButtonGroup.add(this.systemDefaultCheckBoxMenuItem);
        this.AudioDeviceMenu.add(this.systemDefaultCheckBoxMenuItem);
        this.systemDefaultCheckBoxMenuItem.addActionListener(lis);
        this.AudioDeviceMenu.add(new JSeparator());
        for (String s : AudioConfiguration.getMixerNames()) {
            JCheckBoxMenuItem cb = new JCheckBoxMenuItem(s);
            cb.setSelected(s.equals(this.lastUsedAudioDeviceName));
            this.audioButtonGroup.add(cb);
            cb.addActionListener(lis);
            this.AudioDeviceMenu.add(cb);
        }
    }

    private void loadSatelliteDirectory() {
        if (!this.tleDir.canRead()) {
            this.satelliteDirectory = null;
            System.out.println("Program cannot read tle directory at " + this.tleDir.getAbsolutePath() + ". Make sure directory" + "exists and that you run this program with sufficient" + "privilage to read this file.");
            System.exit(1);
        } else {
            this.satelliteDirectory = new SatelliteDirectory(this.tleDir, this.sqfFile);
        }
        try {
            this.satelliteDirectory.loadSatellites();
        }
        catch (IOException ex) {
            Logger.getLogger(DopplerPSK.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void loadSelectedSatellite(String name) {
        Satellite sat = this.satelliteDirectory.getSatellite(name);
        if (sat != null) {
            try {
                if (this.propagator != null) {
                    this.propagator.stop();
                    this.propagator.removeEventListener(this);
                }
                this.propagator = new OrekitSatelliteEventSource(sat, this.stationLat, this.stationLon, this.stationAlt, sat.getUpLinkHz(), 1.0);
                this.propagator.addEventListener(this);
                this.propagator.start();
                this.currentSatelliteName = name;
            }
            catch (OrekitException ex) {
                Logger.getLogger(DopplerPSK.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private Psk31Transmitter getPsk31Tx(String audioDeviceName) throws LineUnavailableException {
        AudioFormat format = new AudioFormat(48000.0f, 16, 1, true, true);
        SourceDataLine line = AudioConfiguration.getSourceDataLine(audioDeviceName, format);
        line.open();
        Psk31Transmitter trans = new Psk31Transmitter(line, format, this.dopplerCenter);
        return trans;
    }

    private void initComponents() {
        this.audioButtonGroup = new ButtonGroup();
        this.macroButtonGroup = new ButtonGroup();
        this.topPanel = new JPanel();
        this.satInfoPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.satNameLabel = new JLabel();
        this.jLabel3 = new JLabel();
        this.azLabel = new JLabel();
        this.jLabel5 = new JLabel();
        this.elLabel = new JLabel();
        this.infoPanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.uplinkFreqLabel = new JLabel();
        this.jLabel7 = new JLabel();
        this.dopplerLabel = new JLabel();
        this.jLabel9 = new JLabel();
        this.ddfLabel = new JLabel();
        this.jLabel2 = new JLabel();
        this.centerAfFreqLabel = new JLabel();
        this.jLabel6 = new JLabel();
        this.currentAfFreqLabel = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.messagePanel = new JPanel();
        this.macroPanel = new JPanel();
        this.messageTxToggleButton = new JToggleButton();
        this.txPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.txTextArea = new JTextArea();
        this.keyboardTxToggleButton = new JToggleButton();
        this.clearBufferButton = new JButton();
        this.echoTextField = new JTextField();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitMenuItem = new JMenuItem();
        this.stationMenu = new JMenu();
        this.stationMenuItem = new JMenuItem();
        this.satelliteMenu = new JMenu();
        this.chooseSatelliteMenuItem = new JMenuItem();
        this.AudioDeviceMenu = new JMenu();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenu1 = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("DopplerPSK");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DopplerPSK.this.formWindowClosing(evt);
            }
        });
        this.satInfoPanel.setBorder(BorderFactory.createTitledBorder("Satellite Info"));
        this.satInfoPanel.setLayout(new GridLayout(3, 2, 2, 0));
        this.jLabel1.setText("Sat:");
        this.jLabel1.setToolTipText("Satellite being tracked");
        this.satInfoPanel.add(this.jLabel1);
        this.satNameLabel.setFont(new Font("Courier New", 0, 11));
        this.satNameLabel.setHorizontalAlignment(11);
        this.satNameLabel.setText("--");
        this.satNameLabel.setToolTipText("Satellite being tracked");
        this.satInfoPanel.add(this.satNameLabel);
        this.jLabel3.setText("AZ:");
        this.jLabel3.setToolTipText("Satellite azimuth at station");
        this.satInfoPanel.add(this.jLabel3);
        this.azLabel.setFont(new Font("Courier New", 0, 11));
        this.azLabel.setHorizontalAlignment(11);
        this.azLabel.setText("--");
        this.azLabel.setToolTipText("Satellite azimuth at station");
        this.satInfoPanel.add(this.azLabel);
        this.jLabel5.setText("EL:");
        this.jLabel5.setToolTipText("Satellite elevation at station");
        this.satInfoPanel.add(this.jLabel5);
        this.elLabel.setFont(new Font("Courier New", 0, 11));
        this.elLabel.setHorizontalAlignment(11);
        this.elLabel.setText("--");
        this.elLabel.setToolTipText("Satellite elevation at station");
        this.satInfoPanel.add(this.elLabel);
        this.infoPanel.setBorder(BorderFactory.createTitledBorder("Uplink"));
        this.infoPanel.setToolTipText("");
        this.infoPanel.setLayout(new GridLayout(5, 2));
        this.jLabel4.setText("Uplink Freq:");
        this.infoPanel.add(this.jLabel4);
        this.uplinkFreqLabel.setFont(new Font("Courier New", 0, 11));
        this.uplinkFreqLabel.setHorizontalAlignment(11);
        this.uplinkFreqLabel.setText("--");
        this.infoPanel.add(this.uplinkFreqLabel);
        this.jLabel7.setText("Doppler Adj.:");
        this.jLabel7.setToolTipText("Absolute Doppler shift adjustment in Hz");
        this.infoPanel.add(this.jLabel7);
        this.dopplerLabel.setFont(new Font("Courier New", 0, 11));
        this.dopplerLabel.setHorizontalAlignment(11);
        this.dopplerLabel.setText("--");
        this.dopplerLabel.setToolTipText("Absolute Doppler shift adjustment in Hz");
        this.infoPanel.add(this.dopplerLabel);
        this.jLabel9.setText("Doppler Adj. Rate:");
        this.jLabel9.setToolTipText("Change in Doppler shift of uplink(Hz/s)");
        this.infoPanel.add(this.jLabel9);
        this.ddfLabel.setFont(new Font("Courier New", 0, 11));
        this.ddfLabel.setHorizontalAlignment(11);
        this.ddfLabel.setText("--");
        this.ddfLabel.setToolTipText("Change in Doppler shift of uplink(Hz/s)");
        this.infoPanel.add(this.ddfLabel);
        this.jLabel2.setText("Center AF Freq.:");
        this.jLabel2.setToolTipText("Audio frequency of carrier without Doppler correction");
        this.infoPanel.add(this.jLabel2);
        this.centerAfFreqLabel.setFont(new Font("Courier New", 0, 11));
        this.centerAfFreqLabel.setHorizontalAlignment(11);
        this.centerAfFreqLabel.setText("--");
        this.centerAfFreqLabel.setToolTipText("Audio frequency of carrier without Doppler correction");
        this.infoPanel.add(this.centerAfFreqLabel);
        this.jLabel6.setText("Current AF Freq.:");
        this.jLabel6.setToolTipText("Current TX audio frequency, corrected for uplink Doppler (Hz)");
        this.infoPanel.add(this.jLabel6);
        this.currentAfFreqLabel.setFont(new Font("Courier New", 0, 11));
        this.currentAfFreqLabel.setHorizontalAlignment(11);
        this.currentAfFreqLabel.setText("--");
        this.currentAfFreqLabel.setToolTipText("Current TX audio frequency, corrected for uplink Doppler (Hz)");
        this.infoPanel.add(this.currentAfFreqLabel);
        GroupLayout topPanelLayout = new GroupLayout(this.topPanel);
        this.topPanel.setLayout(topPanelLayout);
        topPanelLayout.setHorizontalGroup(topPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(topPanelLayout.createSequentialGroup().addComponent(this.satInfoPanel, -2, 219, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoPanel, -2, -1, -2)));
        topPanelLayout.setVerticalGroup(topPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.satInfoPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, topPanelLayout.createSequentialGroup().addComponent(this.infoPanel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.macroPanel.setLayout(new BoxLayout(this.macroPanel, 3));
        this.messageTxToggleButton.setText("TX");
        this.messageTxToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DopplerPSK.this.messageTxToggleButtonActionPerformed(evt);
            }
        });
        GroupLayout messagePanelLayout = new GroupLayout(this.messagePanel);
        this.messagePanel.setLayout(messagePanelLayout);
        messagePanelLayout.setHorizontalGroup(messagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(messagePanelLayout.createSequentialGroup().addContainerGap().addGroup(messagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.macroPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, messagePanelLayout.createSequentialGroup().addGap(0, 521, Short.MAX_VALUE).addComponent(this.messageTxToggleButton, -2, 65, -2))).addContainerGap()));
        messagePanelLayout.setVerticalGroup(messagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(messagePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.macroPanel, -1, 240, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messageTxToggleButton).addContainerGap()));
        this.jTabbedPane1.addTab("Messages", this.messagePanel);
        this.txTextArea.setColumns(20);
        this.txTextArea.setLineWrap(true);
        this.txTextArea.setRows(5);
        this.txTextArea.setWrapStyleWord(true);
        this.txTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DopplerPSK.this.txTextAreaKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.txTextArea);
        this.keyboardTxToggleButton.setText("TX");
        this.keyboardTxToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DopplerPSK.this.keyboardTxToggleButtonActionPerformed(evt);
            }
        });
        this.clearBufferButton.setText("Clear Buffer");
        this.clearBufferButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DopplerPSK.this.clearBufferButtonActionPerformed(evt);
            }
        });
        GroupLayout txPanelLayout = new GroupLayout(this.txPanel);
        this.txPanel.setLayout(txPanelLayout);
        txPanelLayout.setHorizontalGroup(txPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(txPanelLayout.createSequentialGroup().addContainerGap().addGroup(txPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 586, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, txPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.clearBufferButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.keyboardTxToggleButton, -2, 65, -2))).addContainerGap()));
        txPanelLayout.setVerticalGroup(txPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(txPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 240, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(txPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyboardTxToggleButton).addComponent(this.clearBufferButton)).addContainerGap()));
        this.jTabbedPane1.addTab("Keyboard Chat", this.txPanel);
        this.echoTextField.setEditable(false);
        this.echoTextField.setBackground(new Color(204, 204, 204));
        this.echoTextField.setHorizontalAlignment(11);
        this.fileMenu.setText("File");
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DopplerPSK.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.stationMenu.setText("Station");
        this.stationMenuItem.setText("Edit station information...");
        this.stationMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DopplerPSK.this.stationMenuItemActionPerformed(evt);
            }
        });
        this.stationMenu.add(this.stationMenuItem);
        this.menuBar.add(this.stationMenu);
        this.satelliteMenu.setText("Satellite");
        this.chooseSatelliteMenuItem.setText("Choose Satellite...");
        this.chooseSatelliteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DopplerPSK.this.chooseSatelliteMenuItemActionPerformed(evt);
            }
        });
        this.satelliteMenu.add(this.chooseSatelliteMenuItem);
        this.menuBar.add(this.satelliteMenu);
        this.AudioDeviceMenu.setText("Audio Device");
        this.AudioDeviceMenu.add(this.jSeparator1);
        this.menuBar.add(this.AudioDeviceMenu);
        this.jMenu1.setText("Help");
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DopplerPSK.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.aboutMenuItem);
        this.menuBar.add(this.jMenu1);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1).addComponent(this.topPanel, -1, -1, Short.MAX_VALUE).addComponent(this.echoTextField)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.topPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.echoTextField, -2, -1, -2).addGap(35, 35, 35).addComponent(this.jTabbedPane1).addContainerGap()));
        this.jTabbedPane1.getAccessibleContext().setAccessibleName("tab2");
        this.jTabbedPane1.getAccessibleContext().setAccessibleDescription("");
        this.pack();
    }

    private void keyboardTxToggleButtonActionPerformed(ActionEvent evt) {
        if (this.messageTxToggleButton.isSelected()) {
            this.messageTxToggleButton.setSelected(false);
        }
        if (this.tx == null) {
            try {
                this.tx = this.getPsk31Tx(this.lastUsedAudioDeviceName);
                this.tx.addListener(this);
                if (this.lastEvt != null) {
                    this.tx.SatelliteUpdateEventOccured(this.lastEvt);
                }
            }
            catch (LineUnavailableException ex) {
                Logger.getLogger(DopplerPSK.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.tx != null) {
            if (this.keyboardTxToggleButton.isSelected()) {
                if (this.tx.isIsLoop()) {
                    this.tx.setLoop(false);
                    this.tx.clearBuffer();
                }
                this.tx.startTx();
            } else {
                this.tx.stopTx();
            }
        }
    }

    private void txTextAreaKeyTyped(KeyEvent evt) {
        if (this.tx != null) {
            char k = evt.getKeyChar();
            System.out.println((int)k);
            if (k == '\b') {
                this.tx.removeChar();
            } else if (k == '\n') {
                this.tx.putChar('\r');
            } else if (k == '\u001b') {
                this.tx.stopTx();
            } else {
                this.tx.putChar(evt.getKeyChar());
            }
        }
    }

    private void chooseSatelliteMenuItemActionPerformed(ActionEvent evt) {
        SatelliteChooserDialog d = new SatelliteChooserDialog((Frame)this, this.satelliteDirectory.getSatelliteNames(), this.currentSatelliteName, true);
        d.setVisible(true);
        int option = d.getUserAction();
        if (option == 1) {
            String s = d.getSelectedSatelliteName();
            System.out.println("User selected satellite: " + s);
            this.loadSelectedSatellite(s);
        } else {
            System.out.println("User cancelled satellite selection");
        }
    }

    private void clearBufferButtonActionPerformed(ActionEvent evt) {
        if (this.tx != null) {
            this.tx.clearBuffer();
        }
        this.txTextArea.setText("");
    }

    private void stationMenuItemActionPerformed(ActionEvent evt) {
        StationInfoDialog d = new StationInfoDialog(this, Math.toDegrees(this.stationLat), Math.toDegrees(this.stationLon), this.stationAlt, true);
        d.setVisible(true);
        int option = d.getUserAction();
        if (option == 1) {
            this.stationAlt = d.getAlt();
            this.stationLat = Math.toRadians(d.getLat());
            this.stationLon = Math.toRadians(d.getLon());
            System.out.println("new groudstation location: " + this.stationLat + " " + this.stationLon + " " + this.stationAlt);
            this.loadSelectedSatellite(this.currentSatelliteName);
        } else {
            System.out.println("User cancelled edit groudstation");
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.saveSettings();
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Version 0.20\nAndrew T. Flowers, K0SM", "About DopplerPSK", 1);
    }

    private void messageTxToggleButtonActionPerformed(ActionEvent evt) {
        if (this.keyboardTxToggleButton.isSelected()) {
            this.keyboardTxToggleButton.setSelected(false);
        }
        if (this.tx == null) {
            try {
                this.tx = this.getPsk31Tx(this.lastUsedAudioDeviceName);
                this.tx.addListener(this);
                if (this.lastEvt != null) {
                    this.tx.SatelliteUpdateEventOccured(this.lastEvt);
                }
            }
            catch (LineUnavailableException ex) {
                Logger.getLogger(DopplerPSK.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.tx != null) {
            if (this.messageTxToggleButton.isSelected()) {
                Component[] comps;
                this.tx.clearBuffer();
                this.tx.startTx();
                this.tx.setLoop(true);
                String message = null;
                for (Component c : comps = this.macroPanel.getComponents()) {
                    MessagePanel p;
                    if (!(c instanceof MessagePanel) || !(p = (MessagePanel)c).isSelected()) continue;
                    message = p.getFormattedMessage();
                    break;
                }
                if (!message.endsWith(" ")) {
                    message = message + " ";
                }
                this.tx.putLoopMessage(message);
            } else {
                this.tx.stopTx();
            }
        }
    }

    private void saveSettings() {
        Properties p = new Properties();
        p.put("stationLat", "" + Math.toDegrees(this.stationLat));
        p.put("stationLon", "" + Math.toDegrees(this.stationLon));
        p.put("stationAlt", "" + this.stationAlt);
        p.put("dopplerCenter", "" + this.dopplerCenter);
        p.put("currentSatelliteName", this.currentSatelliteName);
        p.put("lastUsedAudioDeviceName", "" + this.lastUsedAudioDeviceName);
        p.put("mycall", "" + this.messageInfoPanel.getMyCall());
        p.put("dxcall", "" + this.messageInfoPanel.getDxCall());
        p.put("exchange", "" + this.messageInfoPanel.getExchange());
        try {
            p.store(new FileOutputStream("settings.ini"), "");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void loadSettings() {
        try {
            Properties p = new Properties();
            File settingsFile = new File("settings.ini");
            if (settingsFile.exists()) {
                p.load(new FileInputStream("settings.ini"));
                this.stationLat = Math.toRadians(Double.valueOf((String)p.getOrDefault((Object)"stationLat", "0.0")));
                this.stationLon = Math.toRadians(Double.valueOf((String)p.getOrDefault((Object)"stationLon", "0.0")));
                this.stationAlt = Double.valueOf((String)p.getOrDefault((Object)"stationAlt", "0.0"));
                this.currentSatelliteName = (String)p.getOrDefault((Object)"currentSatelliteName", "NO-84");
                this.dopplerCenter = Double.valueOf((String)p.getOrDefault((Object)"dopplerCenter", "2000.0"));
                this.lastUsedAudioDeviceName = (String)p.getOrDefault((Object)"lastUsedAudioDeviceName", (Object)null);
                this.mycall = (String)p.getOrDefault((Object)"mycall", "k0sm");
                this.dxcall = (String)p.getOrDefault((Object)"dxcall", "dx0dx");
                this.exchange = (String)p.getOrDefault((Object)"exchange", "fn13");
            } else {
                this.stationLat = 0.0;
                this.stationLon = 0.0;
                this.stationAlt = 0.0;
                this.currentSatelliteName = "NO-84";
                this.dopplerCenter = 2000.0;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(DopplerPSK.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void addMacroButtons() {
        this.messageInfoPanel = new MessageInfoPanel(this.mycall, this.dxcall, this.exchange);
        this.macroPanel.add(this.messageInfoPanel);
        MacroParser mp = new MacroParser(new File("macros"));
        mp.loadMacros();
        Map<String, Macro> macroMap = mp.getMacroMap();
        for (String s : macroMap.keySet()) {
            Macro m = macroMap.get(s);
            MessagePanel p = new MessagePanel(m, this.macroButtonGroup, this.mycall, this.dxcall, this.exchange, this);
            this.messageInfoPanel.addUpdateListener(p);
            this.macroPanel.add(p);
        }
        if (this.macroButtonGroup.getButtonCount() > 0) {
            this.macroButtonGroup.getElements().nextElement().setSelected(true);
        }
    }

    @Override
    public void SatelliteUpdateEventOccured(SatelliteUpdateEvent evt) {
        this.lastEvt = evt;
        this.satNameLabel.setText(evt.getName());
        this.elLabel.setText(decimalFormat.format(evt.getEl()));
        this.azLabel.setText(decimalFormat.format(evt.getAz()));
        this.dopplerLabel.setText(decimalFormat.format(evt.getDopplerShift()) + "   Hz");
        this.ddfLabel.setText(decimalFormat.format(evt.getDopplerRate()) + " Hz/s");
        this.uplinkFreqLabel.setText(mhzFormat.format(this.satelliteDirectory.getSatellite(this.currentSatelliteName).getUpLinkHz() / 1000000.0) + "  MHz");
        if (this.tx != null) {
            this.tx.SatelliteUpdateEventOccured(evt);
            this.centerAfFreqLabel.setText(integerFormat.format(this.tx.getCenterFrequency()) + "   Hz");
            this.currentAfFreqLabel.setText(integerFormat.format(this.tx.getInstantaneousFrequency()) + "   Hz");
        } else {
            this.centerAfFreqLabel.setText("    --    ");
            this.currentAfFreqLabel.setText("    --    ");
        }
    }

    @Override
    public void TxCharacterSent(Character c) {
        String s = this.echoTextField.getText();
        if (s.length() > 200) {
            s = s.substring(s.length() - 200);
        }
        if (c.charValue() == '\n' || c.charValue() == '\r') {
            this.echoTextField.setText(s + " ");
        } else {
            this.echoTextField.setText(s + c);
        }
        this.echoTextField.setCaretPosition(this.echoTextField.getText().length());
    }

    @Override
    public void messageChanged(String message) {
        if (this.messageTxToggleButton.isSelected()) {
            this.tx.clearBuffer();
            this.tx.startTx();
            this.tx.setLoop(true);
            if (!message.endsWith(" ")) {
                message = message + " ";
            }
            this.tx.putLoopMessage(message);
        }
    }

    public static void main(String[] args) throws OrekitException {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DopplerPSK.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(DopplerPSK.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(DopplerPSK.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(DopplerPSK.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DopplerPSK pskFrame = new DopplerPSK();
                pskFrame.setVisible(true);
            }
        });
    }
}

