/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.math3.exception.util.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.DateComponents;
import org.orekit.time.Month;
import org.orekit.time.UTCTAILoader;

class UTCTAIHistoryFilesLoader
implements UTCTAILoader {
    private static final String SUPPORTED_NAMES = "^UTC-TAI\\.history$";
    private Pattern regularPattern;
    private Pattern lastPattern;
    private SortedMap<DateComponents, Integer> entries;

    public UTCTAIHistoryFilesLoader() {
        String start = "^";
        String yearField = "\\p{Blank}*((?:\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})|(?:    ))";
        StringBuilder builder = new StringBuilder("\\p{Blank}+(");
        for (Month month : Month.values()) {
            builder.append(month.getCapitalizedAbbreviation());
            builder.append('|');
        }
        builder.delete(builder.length() - 1, builder.length());
        builder.append(")\\.?");
        String monthField = builder.toString();
        String dayField = "\\p{Blank}+([ 0-9]+)\\.?";
        String offsetField = "\\p{Blank}+(\\p{Digit}+)s";
        String separator = "\\p{Blank}*-\\p{Blank}+";
        String finalBlanks = "\\p{Blank}*$";
        this.regularPattern = Pattern.compile("^\\p{Blank}*((?:\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})|(?:    ))" + monthField + "\\p{Blank}+([ 0-9]+)\\.?" + "\\p{Blank}*-\\p{Blank}+" + "\\p{Blank}*((?:\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})|(?:    ))" + monthField + "\\p{Blank}+([ 0-9]+)\\.?" + "\\p{Blank}+(\\p{Digit}+)s" + "\\p{Blank}*$");
        this.lastPattern = Pattern.compile("^\\p{Blank}*((?:\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})|(?:    ))" + monthField + "\\p{Blank}+([ 0-9]+)\\.?" + "\\p{Blank}*-\\p{Blank}+" + "\\p{Blank}+(\\p{Digit}+)s" + "\\p{Blank}*$");
        this.entries = new TreeMap<DateComponents, Integer>();
    }

    @Override
    public String getSupportedNames() {
        return SUPPORTED_NAMES;
    }

    @Override
    public SortedMap<DateComponents, Integer> loadTimeSteps() {
        return this.entries;
    }

    @Override
    public boolean stillAcceptsData() {
        return this.entries == null || this.entries.isEmpty();
    }

    @Override
    public void loadData(InputStream input, String name) throws OrekitException, IOException, ParseException {
        this.entries.clear();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
        boolean foundEntries = false;
        String emptyYear = "    ";
        int lineNumber = 0;
        DateComponents lastDate = null;
        int lastLine = 0;
        String previousYear = "    ";
        String line = reader.readLine();
        while (line != null) {
            ++lineNumber;
            Matcher matcher = this.regularPattern.matcher(line);
            if (matcher.matches()) {
                if (lastLine > 0) {
                    throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_DATA_AFTER_LINE_IN_FILE, lastLine, name, line);
                }
            } else {
                matcher = this.lastPattern.matcher(line);
                if (matcher.matches()) {
                    lastLine = lineNumber;
                }
            }
            if (matcher.matches()) {
                try {
                    String year = matcher.group(1);
                    if ("    ".equals(year)) {
                        year = previousYear;
                    }
                    if (lineNumber != lastLine) {
                        previousYear = "    ".equals(matcher.group(4)) ? year : matcher.group(4);
                    }
                    DateComponents leapDay = new DateComponents(Integer.parseInt(year.trim()), Month.parseMonth(matcher.group(2)), Integer.parseInt(matcher.group(3).trim()));
                    Integer offset = Integer.valueOf(matcher.group(matcher.groupCount()));
                    if (lastDate != null && leapDay.compareTo(lastDate) <= 0) {
                        throw new OrekitException((Localizable)OrekitMessages.NON_CHRONOLOGICAL_DATES_IN_FILE, name, lineNumber);
                    }
                    lastDate = leapDay;
                    foundEntries = true;
                    this.entries.put(leapDay, offset);
                }
                catch (NumberFormatException nfe) {
                    throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                }
            }
            line = reader.readLine();
        }
        if (!foundEntries) {
            throw new OrekitException((Localizable)OrekitMessages.NO_ENTRIES_IN_IERS_UTC_TAI_HISTORY_FILE, name);
        }
    }
}

