/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.orekit.frames.EOPHistory;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.UTCScale;

public class UT1Scale
implements TimeScale {
    private static final long serialVersionUID = 20131209L;
    private final UTCScale utc;
    private final EOPHistory eopHistory;

    UT1Scale(EOPHistory eopHistory, UTCScale utc) {
        this.eopHistory = eopHistory;
        this.utc = utc;
    }

    public EOPHistory getEOPHistory() {
        return this.eopHistory;
    }

    @Override
    public double offsetFromTAI(AbsoluteDate date) {
        double dtu1 = this.eopHistory == null ? 0.0 : this.eopHistory.getUT1MinusUTC(date);
        double utcMinusTai = this.utc.offsetFromTAI(date);
        return utcMinusTai + dtu1;
    }

    @Override
    public double offsetToTAI(DateComponents date, TimeComponents time) {
        AbsoluteDate reference = new AbsoluteDate(date, time, (TimeScale)TimeScalesFactory.getTAI());
        double offset = 0.0;
        for (int i = 0; i < 3; ++i) {
            offset = -this.offsetFromTAI(reference.shiftedBy(offset));
        }
        return offset;
    }

    @Override
    public String getName() {
        return "UT1";
    }

    public String toString() {
        return this.getName();
    }
}

