/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;

public class TCGScale
implements TimeScale {
    private static final long serialVersionUID = 20131209L;
    private static double LG_RATE = 6.969290134E-10;
    private static final AbsoluteDate REFERENCE_DATE = new AbsoluteDate(1977, 1, 1, (TimeScale)TimeScalesFactory.getTAI());
    private static final double TT_OFFSET = TimeScalesFactory.getTT().offsetFromTAI(REFERENCE_DATE);

    TCGScale() {
    }

    @Override
    public double offsetFromTAI(AbsoluteDate date) {
        return TT_OFFSET + LG_RATE * date.durationFrom(REFERENCE_DATE);
    }

    @Override
    public double offsetToTAI(DateComponents date, TimeComponents time) {
        AbsoluteDate reference = new AbsoluteDate(date, time, (TimeScale)TimeScalesFactory.getTAI());
        double offset = 0.0;
        for (int i = 0; i < 3; ++i) {
            offset = -this.offsetFromTAI(reference.shiftedBy(offset));
        }
        return offset;
    }

    @Override
    public String getName() {
        return "TCG";
    }

    public String toString() {
        return this.getName();
    }
}

