/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.Month;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.TimeShiftable;
import org.orekit.time.TimeStamped;
import org.orekit.time.UTCScale;

public class AbsoluteDate
implements TimeStamped,
TimeShiftable<AbsoluteDate>,
Comparable<AbsoluteDate>,
Serializable {
    public static final AbsoluteDate JULIAN_EPOCH = new AbsoluteDate(DateComponents.JULIAN_EPOCH, TimeComponents.H12, (TimeScale)TimeScalesFactory.getTT());
    public static final AbsoluteDate MODIFIED_JULIAN_EPOCH = new AbsoluteDate(DateComponents.MODIFIED_JULIAN_EPOCH, TimeComponents.H00, (TimeScale)TimeScalesFactory.getTT());
    public static final AbsoluteDate FIFTIES_EPOCH = new AbsoluteDate(DateComponents.FIFTIES_EPOCH, TimeComponents.H00, (TimeScale)TimeScalesFactory.getTT());
    public static final AbsoluteDate CCSDS_EPOCH = new AbsoluteDate(DateComponents.CCSDS_EPOCH, TimeComponents.H00, (TimeScale)TimeScalesFactory.getTAI());
    public static final AbsoluteDate GALILEO_EPOCH = new AbsoluteDate(DateComponents.GALILEO_EPOCH, new TimeComponents(0, 0, 32.0), (TimeScale)TimeScalesFactory.getTAI());
    public static final AbsoluteDate GPS_EPOCH = new AbsoluteDate(DateComponents.GPS_EPOCH, TimeComponents.H00, (TimeScale)TimeScalesFactory.getGPS());
    public static final AbsoluteDate J2000_EPOCH = new AbsoluteDate(DateComponents.J2000_EPOCH, TimeComponents.H12, (TimeScale)TimeScalesFactory.getTT());
    public static final AbsoluteDate JAVA_EPOCH = new AbsoluteDate(DateComponents.JAVA_EPOCH, (TimeScale)TimeScalesFactory.getTAI()).shiftedBy(8.000082);
    public static final AbsoluteDate PAST_INFINITY = JAVA_EPOCH.shiftedBy(Double.NEGATIVE_INFINITY);
    public static final AbsoluteDate FUTURE_INFINITY = JAVA_EPOCH.shiftedBy(Double.POSITIVE_INFINITY);
    private static final long serialVersionUID = 617061803741806846L;
    private final long epoch;
    private final double offset;

    public AbsoluteDate() {
        this.epoch = AbsoluteDate.J2000_EPOCH.epoch;
        this.offset = AbsoluteDate.J2000_EPOCH.offset;
    }

    public AbsoluteDate(String location, TimeScale timeScale) {
        this(DateTimeComponents.parseDateTime(location), timeScale);
    }

    public AbsoluteDate(DateTimeComponents location, TimeScale timeScale) {
        this(location.getDate(), location.getTime(), timeScale);
    }

    public AbsoluteDate(DateComponents date, TimeComponents time, TimeScale timeScale) {
        double seconds = time.getSecond();
        double tsOffset = timeScale.offsetToTAI(date, time);
        double sum = seconds + tsOffset;
        double sPrime = sum - tsOffset;
        double tPrime = sum - sPrime;
        double deltaS = seconds - sPrime;
        double deltaT = tsOffset - tPrime;
        double residual = deltaS + deltaT;
        long dl = (long)FastMath.floor((double)sum);
        this.offset = sum - (double)dl + residual;
        this.epoch = 60L * (((long)date.getJ2000Day() * 24L + (long)time.getHour()) * 60L + (long)time.getMinute() - 720L) + dl;
    }

    public AbsoluteDate(int year, int month, int day, int hour, int minute, double second, TimeScale timeScale) throws IllegalArgumentException {
        this(new DateComponents(year, month, day), new TimeComponents(hour, minute, second), timeScale);
    }

    public AbsoluteDate(int year, Month month, int day, int hour, int minute, double second, TimeScale timeScale) throws IllegalArgumentException {
        this(new DateComponents(year, month, day), new TimeComponents(hour, minute, second), timeScale);
    }

    public AbsoluteDate(DateComponents date, TimeScale timeScale) throws IllegalArgumentException {
        this(date, TimeComponents.H00, timeScale);
    }

    public AbsoluteDate(int year, int month, int day, TimeScale timeScale) throws IllegalArgumentException {
        this(new DateComponents(year, month, day), TimeComponents.H00, timeScale);
    }

    public AbsoluteDate(int year, Month month, int day, TimeScale timeScale) throws IllegalArgumentException {
        this(new DateComponents(year, month, day), TimeComponents.H00, timeScale);
    }

    public AbsoluteDate(Date location, TimeScale timeScale) {
        this(new DateComponents(DateComponents.JAVA_EPOCH, (int)(location.getTime() / 86400000L)), new TimeComponents(0.001 * (double)(location.getTime() % 86400000L)), timeScale);
    }

    public AbsoluteDate(AbsoluteDate since, double elapsedDuration) {
        double sum = since.offset + elapsedDuration;
        if (Double.isInfinite(sum)) {
            this.offset = sum;
            this.epoch = sum < 0.0 ? Long.MIN_VALUE : Long.MAX_VALUE;
        } else {
            double oPrime = sum - elapsedDuration;
            double dPrime = sum - oPrime;
            double deltaO = since.offset - oPrime;
            double deltaD = elapsedDuration - dPrime;
            double residual = deltaO + deltaD;
            long dl = (long)FastMath.floor((double)sum);
            this.offset = sum - (double)dl + residual;
            this.epoch = since.epoch + dl;
        }
    }

    public AbsoluteDate(AbsoluteDate reference, double apparentOffset, TimeScale timeScale) {
        this(new DateTimeComponents(reference.getComponents(timeScale), apparentOffset), timeScale);
    }

    public static AbsoluteDate parseCCSDSUnsegmentedTimeCode(byte preambleField1, byte preambleField2, byte[] timeField, AbsoluteDate agencyDefinedEpoch) throws OrekitException {
        AbsoluteDate epoch;
        switch (preambleField1 & 0x70) {
            case 16: {
                epoch = CCSDS_EPOCH;
                break;
            }
            case 32: {
                if (agencyDefinedEpoch == null) {
                    throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_MISSING_AGENCY_EPOCH, new Object[0]);
                }
                epoch = agencyDefinedEpoch;
                break;
            }
            default: {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, AbsoluteDate.formatByte(preambleField1));
            }
        }
        int coarseTimeLength = 1 + ((preambleField1 & 0xC) >>> 2);
        int fineTimeLength = preambleField1 & 3;
        if ((preambleField1 & 0x80) != 0) {
            coarseTimeLength += (preambleField2 & 0x60) >>> 5;
            fineTimeLength += (preambleField2 & 0x1C) >>> 2;
        }
        if (timeField.length != coarseTimeLength + fineTimeLength) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_LENGTH_TIME_FIELD, timeField.length, coarseTimeLength + fineTimeLength);
        }
        double seconds = 0.0;
        for (int i = 0; i < coarseTimeLength; ++i) {
            seconds = seconds * 256.0 + (double)AbsoluteDate.toUnsigned(timeField[i]);
        }
        double subseconds = 0.0;
        for (int i = timeField.length - 1; i >= coarseTimeLength; --i) {
            subseconds = (subseconds + (double)AbsoluteDate.toUnsigned(timeField[i])) / 256.0;
        }
        return new AbsoluteDate(epoch, seconds).shiftedBy(subseconds);
    }

    public static AbsoluteDate parseCCSDSDaySegmentedTimeCode(byte preambleField, byte[] timeField, DateComponents agencyDefinedEpoch) throws OrekitException {
        DateComponents epoch;
        if ((preambleField & 0xF0) != 64) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, AbsoluteDate.formatByte(preambleField));
        }
        if ((preambleField & 8) == 0) {
            epoch = DateComponents.CCSDS_EPOCH;
        } else {
            if (agencyDefinedEpoch == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_MISSING_AGENCY_EPOCH, new Object[0]);
            }
            epoch = agencyDefinedEpoch;
        }
        int daySegmentLength = (preambleField & 4) == 0 ? 2 : 3;
        int subMillisecondLength = (preambleField & 3) << 1;
        if (subMillisecondLength == 6) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, AbsoluteDate.formatByte(preambleField));
        }
        if (timeField.length != daySegmentLength + 4 + subMillisecondLength) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_LENGTH_TIME_FIELD, timeField.length, daySegmentLength + 4 + subMillisecondLength);
        }
        int i = 0;
        int day = 0;
        while (i < daySegmentLength) {
            day = day * 256 + AbsoluteDate.toUnsigned(timeField[i++]);
        }
        long milliInDay = 0L;
        while (i < daySegmentLength + 4) {
            milliInDay = milliInDay * 256L + (long)AbsoluteDate.toUnsigned(timeField[i++]);
        }
        int milli = (int)(milliInDay % 1000L);
        int seconds = (int)((milliInDay - (long)milli) / 1000L);
        double subMilli = 0.0;
        double divisor = 1.0;
        while (i < timeField.length) {
            subMilli = subMilli * 256.0 + (double)AbsoluteDate.toUnsigned(timeField[i++]);
            divisor *= 1000.0;
        }
        DateComponents date = new DateComponents(epoch, day);
        TimeComponents time = new TimeComponents(seconds);
        return new AbsoluteDate(date, time, (TimeScale)TimeScalesFactory.getUTC()).shiftedBy((double)milli * 0.001 + subMilli / divisor);
    }

    public static AbsoluteDate parseCCSDSCalendarSegmentedTimeCode(byte preambleField, byte[] timeField) throws OrekitException {
        if ((preambleField & 0xF0) != 80) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, AbsoluteDate.formatByte(preambleField));
        }
        int length = 7 + (preambleField & 7);
        if (length == 14) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, AbsoluteDate.formatByte(preambleField));
        }
        if (timeField.length != length) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_LENGTH_TIME_FIELD, timeField.length, length);
        }
        DateComponents date = (preambleField & 8) == 0 ? new DateComponents(AbsoluteDate.toUnsigned(timeField[0]) * 256 + AbsoluteDate.toUnsigned(timeField[1]), AbsoluteDate.toUnsigned(timeField[2]), AbsoluteDate.toUnsigned(timeField[3])) : new DateComponents(AbsoluteDate.toUnsigned(timeField[0]) * 256 + AbsoluteDate.toUnsigned(timeField[1]), AbsoluteDate.toUnsigned(timeField[2]) * 256 + AbsoluteDate.toUnsigned(timeField[3]));
        TimeComponents time = new TimeComponents(AbsoluteDate.toUnsigned(timeField[4]), AbsoluteDate.toUnsigned(timeField[5]), AbsoluteDate.toUnsigned(timeField[6]));
        double subSecond = 0.0;
        double divisor = 1.0;
        for (int i = 7; i < length; ++i) {
            subSecond = subSecond * 100.0 + (double)AbsoluteDate.toUnsigned(timeField[i]);
            divisor *= 100.0;
        }
        return new AbsoluteDate(date, time, (TimeScale)TimeScalesFactory.getUTC()).shiftedBy(subSecond / divisor);
    }

    private static int toUnsigned(byte b) {
        int i = b;
        return i < 0 ? 256 + i : i;
    }

    private static String formatByte(byte data) {
        return "0x" + Integer.toHexString(data).toUpperCase();
    }

    public static AbsoluteDate createGPSDate(int weekNumber, double milliInWeek) {
        int day = (int)FastMath.floor((double)(milliInWeek / 8.64E7));
        double secondsInDay = milliInWeek / 1000.0 - (double)day * 86400.0;
        return new AbsoluteDate(new DateComponents(DateComponents.GPS_EPOCH, weekNumber * 7 + day), new TimeComponents(secondsInDay), (TimeScale)TimeScalesFactory.getGPS());
    }

    public static AbsoluteDate createJulianEpoch(double julianEpoch) {
        return new AbsoluteDate(J2000_EPOCH, 3.15576E7 * (julianEpoch - 2000.0));
    }

    public static AbsoluteDate createBesselianEpoch(double besselianEpoch) {
        return new AbsoluteDate(J2000_EPOCH, MathArrays.linearCombination((double)3.15569259746784E7, (double)(besselianEpoch - 1900.0), (double)86400.0, (double)-36525.0, (double)86400.0, (double)0.31352));
    }

    @Override
    public AbsoluteDate shiftedBy(double dt) {
        return new AbsoluteDate(this, dt);
    }

    public double durationFrom(AbsoluteDate instant) {
        return (double)(this.epoch - instant.epoch) + (this.offset - instant.offset);
    }

    public double offsetFrom(AbsoluteDate instant, TimeScale timeScale) {
        long elapsedDurationA = this.epoch - instant.epoch;
        double elapsedDurationB = this.offset + timeScale.offsetFromTAI(this) - (instant.offset + timeScale.offsetFromTAI(instant));
        return (double)elapsedDurationA + elapsedDurationB;
    }

    public double timeScalesOffset(TimeScale scale1, TimeScale scale2) {
        return scale1.offsetFromTAI(this) - scale2.offsetFromTAI(this);
    }

    public Date toDate(TimeScale timeScale) {
        double time = (double)this.epoch + (this.offset + timeScale.offsetFromTAI(this));
        return new Date(FastMath.round((double)((time + 9.46728E8) * 1000.0)));
    }

    public DateTimeComponents getComponents(TimeScale timeScale) {
        UTCScale utc;
        long time;
        double taiOffset = timeScale.offsetFromTAI(this);
        double sum = this.offset + taiOffset;
        double oPrime = sum - taiOffset;
        double dPrime = sum - oPrime;
        double deltaO = this.offset - oPrime;
        double deltaD = taiOffset - dPrime;
        double residual = deltaO + deltaD;
        long carry = (long)FastMath.floor((double)sum);
        double offset2000B = sum - (double)carry + residual;
        long offset2000A = this.epoch + carry + 43200L;
        if (offset2000B < 0.0) {
            --offset2000A;
            offset2000B += 1.0;
        }
        if ((time = offset2000A % 86400L) < 0L) {
            time += 86400L;
        }
        int date = (int)((offset2000A - time) / 86400L);
        DateComponents dateComponents = new DateComponents(DateComponents.J2000_EPOCH, date);
        TimeComponents timeComponents = new TimeComponents((int)time, offset2000B);
        if (timeScale instanceof UTCScale && (utc = (UTCScale)timeScale).insideLeap(this)) {
            timeComponents = new TimeComponents(timeComponents.getHour(), timeComponents.getMinute(), timeComponents.getSecond() + utc.getLeap(this));
        }
        return new DateTimeComponents(dateComponents, timeComponents);
    }

    @Override
    public int compareTo(AbsoluteDate date) {
        double delta = this.durationFrom(date);
        if (delta < 0.0) {
            return -1;
        }
        if (delta > 0.0) {
            return 1;
        }
        return 0;
    }

    @Override
    public AbsoluteDate getDate() {
        return this;
    }

    public boolean equals(Object date) {
        if (date == this) {
            return true;
        }
        if (date != null && date instanceof AbsoluteDate) {
            return this.durationFrom((AbsoluteDate)date) == 0.0;
        }
        return false;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.durationFrom(J2000_EPOCH));
        return (int)(l ^ l >>> 32);
    }

    public String toString() {
        try {
            return this.toString(TimeScalesFactory.getUTC());
        }
        catch (OrekitException oe) {
            throw new RuntimeException(oe);
        }
    }

    public String toString(TimeScale timeScale) {
        return this.getComponents(timeScale).toString();
    }
}

