/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities.hansen;

import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.util.FastMath;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.HansenUtilities;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.PolynomialFunctionMatrix;

public class HansenZonalLinear {
    private static final int SLICE = 10;
    private PolynomialFunction[][] mpvec;
    private PolynomialFunction[][] mpvecDeriv;
    private double[][] hansenRoot;
    private double[][] hansenDerivRoot;
    private int Nmin;
    private int N0;
    private int s;
    private int offset;
    private int numSlices;
    private double twots;
    private int twosp1;
    private int twos;
    private double twosp1otwots;

    public HansenZonalLinear(int nMax, int s) {
        this.offset = nMax + 1;
        this.Nmin = -nMax - 1;
        this.N0 = -(s + 2);
        this.s = s;
        this.twots = FastMath.pow((double)2.0, (int)s);
        this.twos = 2 * s;
        this.twosp1 = this.twos + 1;
        this.twosp1otwots = (double)this.twosp1 / this.twots;
        int size = nMax - s - 1;
        this.mpvec = new PolynomialFunction[size][];
        this.mpvecDeriv = new PolynomialFunction[size][];
        this.numSlices = FastMath.max((int)((int)FastMath.ceil((double)((double)size / 10.0))), (int)1);
        this.hansenRoot = new double[this.numSlices][2];
        this.hansenDerivRoot = new double[this.numSlices][2];
        this.generatePolynomials();
    }

    private PolynomialFunction a(int mnm1) {
        double d1 = (mnm1 + 2) * (2 * mnm1 + 5);
        double d2 = (mnm1 + 2 - this.s) * (mnm1 + 2 + this.s);
        return new PolynomialFunction(new double[]{0.0, 0.0, d1 / d2});
    }

    private PolynomialFunction b(int mnm1) {
        double d1 = (mnm1 + 2) * (mnm1 + 3);
        double d2 = (mnm1 + 2 - this.s) * (mnm1 + 2 + this.s);
        return new PolynomialFunction(new double[]{0.0, 0.0, -d1 / d2});
    }

    private void generatePolynomials() {
        int sliceCounter = 0;
        PolynomialFunctionMatrix A = HansenUtilities.buildIdentityMatrix2();
        PolynomialFunctionMatrix D = HansenUtilities.buildZeroMatrix2();
        PolynomialFunctionMatrix E = HansenUtilities.buildIdentityMatrix2();
        PolynomialFunctionMatrix a = HansenUtilities.buildZeroMatrix2();
        a.setElem(0, 1, HansenUtilities.ONE);
        PolynomialFunctionMatrix B = HansenUtilities.buildZeroMatrix2();
        B.setElem(1, 1, new PolynomialFunction(new double[]{2.0}));
        for (int i = this.N0 - 1; i > this.Nmin - 1; --i) {
            int index = i + this.offset;
            a.setMatrixLine(1, new PolynomialFunction[]{this.b(i), this.a(i)});
            A = A.multiply(a);
            this.mpvec[index] = A.getMatrixLine(1);
            D = D.multiply(a);
            E = E.multiply(a);
            D = D.add(E.multiply(B));
            this.mpvecDeriv[index] = D.getMatrixLine(1);
            if (++sliceCounter % 10 != 0) continue;
            A = HansenUtilities.buildIdentityMatrix2();
            D = HansenUtilities.buildZeroMatrix2();
            E = HansenUtilities.buildIdentityMatrix2();
        }
    }

    public void computeInitValues(double chi) {
        this.hansenRoot[0][0] = 0.0;
        this.hansenRoot[0][1] = FastMath.pow((double)chi, (int)this.twosp1) / this.twots;
        this.hansenDerivRoot[0][0] = 0.0;
        this.hansenDerivRoot[0][1] = this.twosp1otwots * FastMath.pow((double)chi, (int)this.twos);
        int st = -this.s - 1;
        for (int i = 1; i < this.numSlices; ++i) {
            for (int j = 0; j < 2; ++j) {
                PolynomialFunction[] mv = this.mpvec[st - i * 10 - j + this.offset];
                PolynomialFunction[] sv = this.mpvecDeriv[st - i * 10 - j + this.offset];
                this.hansenDerivRoot[i][j] = mv[1].value(chi) * this.hansenDerivRoot[i - 1][1] + mv[0].value(chi) * this.hansenDerivRoot[i - 1][0] + (sv[1].value(chi) * this.hansenRoot[i - 1][1] + sv[0].value(chi) * this.hansenRoot[i - 1][0]) / chi;
                this.hansenRoot[i][j] = mv[1].value(chi) * this.hansenRoot[i - 1][1] + mv[0].value(chi) * this.hansenRoot[i - 1][0];
            }
        }
    }

    public double getValue(int mnm1, double chi) {
        int n = -mnm1 - 1;
        int sliceNo = (n - this.s) / 10;
        if (sliceNo < this.numSlices) {
            int indexInSlice = (n - this.s) % 10;
            if (indexInSlice <= 1) {
                return this.hansenRoot[sliceNo][indexInSlice];
            }
        } else {
            --sliceNo;
        }
        PolynomialFunction[] v = this.mpvec[mnm1 + this.offset];
        double ret = v[1].value(chi) * this.hansenRoot[sliceNo][1];
        if (this.hansenRoot[sliceNo][0] != 0.0) {
            ret += v[0].value(chi) * this.hansenRoot[sliceNo][0];
        }
        return ret;
    }

    public double getDerivative(int mnm1, double chi) {
        int n = -mnm1 - 1;
        int sliceNo = (n - this.s) / 10;
        if (sliceNo < this.numSlices) {
            int indexInSlice = (n - this.s) % 10;
            if (indexInSlice <= 1) {
                return this.hansenDerivRoot[sliceNo][indexInSlice];
            }
        } else {
            --sliceNo;
        }
        PolynomialFunction[] v = this.mpvec[mnm1 + this.offset];
        double ret = v[1].value(chi) * this.hansenDerivRoot[sliceNo][1];
        if (this.hansenDerivRoot[sliceNo][0] != 0.0) {
            ret += v[0].value(chi) * this.hansenDerivRoot[sliceNo][0];
        }
        PolynomialFunction[] v1 = this.mpvecDeriv[mnm1 + this.offset];
        double hret = v1[1].value(chi) * this.hansenRoot[sliceNo][1];
        if (this.hansenRoot[sliceNo][0] != 0.0) {
            hret += v1[0].value(chi) * this.hansenRoot[sliceNo][0];
        }
        return ret += hret / chi;
    }
}

