/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.forces.SphericalSpacecraft;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.forces.radiation.SolarRadiationPressure;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.semianalytical.dsst.forces.AbstractGaussianContribution;
import org.orekit.utils.PVCoordinatesProvider;

public class DSSTSolarRadiationPressure
extends AbstractGaussianContribution {
    private static final double D_REF = 1.4959787E11;
    private static final double P_REF = 4.56E-6;
    private static final double GAUSS_THRESHOLD = 1.0E-15;
    private static final double S_ZERO = 1.0E-6;
    private final PVCoordinatesProvider sun;
    private final double ae;
    private final RadiationSensitive spacecraft;

    public DSSTSolarRadiationPressure(double cr, double area, PVCoordinatesProvider sun, double equatorialRadius) {
        this(1.4959787E11, 4.56E-6, cr, area, sun, equatorialRadius);
    }

    public DSSTSolarRadiationPressure(PVCoordinatesProvider sun, double equatorialRadius, RadiationSensitive spacecraft) {
        this(1.4959787E11, 4.56E-6, sun, equatorialRadius, spacecraft);
    }

    public DSSTSolarRadiationPressure(double dRef, double pRef, double cr, double area, PVCoordinatesProvider sun, double equatorialRadius) {
        this(dRef, pRef, sun, equatorialRadius, new SphericalSpacecraft(area, 0.0, 0.0, 3.25 - 2.25 * cr));
    }

    public DSSTSolarRadiationPressure(double dRef, double pRef, PVCoordinatesProvider sun, double equatorialRadius, RadiationSensitive spacecraft) {
        super(1.0E-15, new SolarRadiationPressure(dRef, pRef, sun, equatorialRadius, spacecraft));
        this.sun = sun;
        this.ae = equatorialRadius;
        this.spacecraft = spacecraft;
    }

    public RadiationSensitive getSpacecraft() {
        return this.spacecraft;
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return null;
    }

    @Override
    protected double[] getLLimits(SpacecraftState state) throws OrekitException {
        double[] roots;
        double dd;
        double m4;
        double h2;
        double k2;
        double bet2;
        double cc;
        double m;
        double m2;
        double bb;
        double b2;
        double[] a;
        int nbRoots;
        double[] ll = new double[]{-Math.PI + MathUtils.normalizeAngle((double)state.getLv(), (double)0.0), Math.PI + MathUtils.normalizeAngle((double)state.getLv(), (double)0.0)};
        Vector3D sunDir = this.sun.getPVCoordinates(state.getDate(), state.getFrame()).getPosition().normalize();
        double alpha = sunDir.dotProduct((Vector)this.f);
        double beta = sunDir.dotProduct((Vector)this.g);
        double gamma = sunDir.dotProduct((Vector)this.w);
        if (FastMath.abs((double)(gamma * this.a * (1.0 - this.ecc))) < this.ae && (nbRoots = this.realQuarticRoots(a = new double[]{4.0 * (b2 = (bb = alpha * beta + (m2 = (m = this.ae / (this.a * this.B)) * m) * this.h * this.k) * bb) + (cc = alpha * alpha - (bet2 = beta * beta) + m2 * ((k2 = this.k * this.k) - (h2 = this.h * this.h))) * cc, 8.0 * bb * m2 * this.h + 4.0 * cc * m2 * this.k, -4.0 * b2 + 4.0 * (m4 = m2 * m2) * h2 - 2.0 * cc * (dd = 1.0 - bet2 - m2 * (1.0 + h2)) + 4.0 * m4 * k2, -8.0 * bb * m2 * this.h - 4.0 * dd * m2 * this.k, -4.0 * m4 * h2 + dd * dd}, roots = new double[4])) > 0) {
            boolean entryFound = false;
            boolean exitFound = false;
            for (int i = 0; i < nbRoots; ++i) {
                double cosL = roots[i];
                double sL = FastMath.sqrt((double)((1.0 - cosL) * (1.0 + cosL)));
                for (int j = -1; j <= 1; j += 2) {
                    double range;
                    double S;
                    double sinL = (double)j * sL;
                    double cPhi = alpha * cosL + beta * sinL;
                    if (!(cPhi < 0.0) || !(FastMath.abs((double)(S = 1.0 - m2 * (range = 1.0 + this.k * cosL + this.h * sinL) * range - cPhi * cPhi)) < 1.0E-6)) continue;
                    double dSdL = m2 * range * (this.k * sinL - this.h * cosL) + cPhi * (alpha * sinL - beta * cosL);
                    if (dSdL > 0.0) {
                        exitFound = true;
                        ll[0] = FastMath.atan2((double)sinL, (double)cosL);
                        continue;
                    }
                    entryFound = true;
                    ll[1] = FastMath.atan2((double)sinL, (double)cosL);
                }
            }
            if (entryFound != exitFound) {
                ll[0] = -Math.PI;
                ll[1] = Math.PI;
            }
            if (ll[0] > ll[1]) {
                if (ll[1] < 0.0) {
                    ll[1] = ll[1] + Math.PI * 2;
                } else {
                    ll[0] = ll[0] - Math.PI * 2;
                }
            }
        }
        return ll;
    }

    public double getEquatorialRadius() {
        return this.ae;
    }

    private int realQuarticRoots(double[] a, double[] y) {
        if (Precision.equals((double)a[0], (double)0.0)) {
            double[] aa = new double[a.length - 1];
            System.arraycopy(a, 1, aa, 0, aa.length);
            return this.realCubicRoots(aa, y);
        }
        double b = a[1] / a[0];
        double c = a[2] / a[0];
        double d = a[3] / a[0];
        double e = a[4] / a[0];
        double bh = b * 0.5;
        double[] z3 = new double[3];
        int i3 = this.realCubicRoots(new double[]{1.0, -c, b * d - 4.0 * e, e * (4.0 * c - b * b) - d * d}, z3);
        if (i3 == 0) {
            return 0;
        }
        double z = z3[0];
        double zh = z * 0.5;
        double p = FastMath.max((double)(z + bh * bh - c), (double)0.0);
        double q = FastMath.max((double)(zh * zh - e), (double)0.0);
        double r = bh * z - d;
        double pp = FastMath.sqrt((double)p);
        double qq = FastMath.copySign((double)FastMath.sqrt((double)q), (double)r);
        double[] y1 = new double[2];
        int n1 = this.realQuadraticRoots(new double[]{1.0, bh - pp, zh - qq}, y1);
        double[] y2 = new double[2];
        int n2 = this.realQuadraticRoots(new double[]{1.0, bh + pp, zh + qq}, y2);
        if (n1 == 2) {
            if (n2 == 2) {
                y[0] = y1[0];
                y[1] = y1[1];
                y[2] = y2[0];
                y[3] = y2[1];
                return 4;
            }
            y[0] = y1[0];
            y[1] = y1[1];
            return 2;
        }
        if (n2 == 2) {
            y[0] = y2[0];
            y[1] = y2[1];
            return 2;
        }
        return 0;
    }

    private int realCubicRoots(double[] a, double[] y) {
        if (Precision.equals((double)a[0], (double)0.0)) {
            double[] aa = new double[a.length - 1];
            System.arraycopy(a, 1, aa, 0, aa.length);
            return this.realQuadraticRoots(aa, y);
        }
        double b = -a[1] / (3.0 * a[0]);
        double b2 = b * b;
        double c = a[2] / a[0];
        double p = b2 - c / 3.0;
        double d = a[3] / a[0];
        double q = b * (b2 - c * 0.5) - d * 0.5;
        double disc = p * p * p - q * q;
        if (disc < 0.0) {
            double alpha = q + FastMath.copySign((double)FastMath.sqrt((double)(-disc)), (double)q);
            double cbrtAl = FastMath.cbrt((double)alpha);
            double cbrtBe = p / cbrtAl;
            y[0] = p < 0.0 ? b + 2.0 * q / (cbrtAl * cbrtAl + cbrtBe * cbrtBe - p) : (p > 0.0 ? b + cbrtAl + cbrtBe : b + cbrtAl);
            return 1;
        }
        if (disc > 0.0) {
            double phi = FastMath.atan2((double)FastMath.sqrt((double)disc), (double)q) / 3.0;
            double sqP = 2.0 * FastMath.sqrt((double)p);
            y[0] = b + sqP * FastMath.cos((double)phi);
            y[1] = b - sqP * FastMath.cos((double)(1.0471975511965976 + phi));
            y[2] = b - sqP * FastMath.cos((double)(1.0471975511965976 - phi));
            return 3;
        }
        double cbrtQ = FastMath.cbrt((double)q);
        double root1 = b + 2.0 * cbrtQ;
        double root2 = b - cbrtQ;
        if (q < 0.0) {
            y[0] = root2;
            y[1] = root2;
            y[2] = root1;
        } else {
            y[0] = root1;
            y[1] = root2;
            y[2] = root2;
        }
        return 3;
    }

    private int realQuadraticRoots(double[] a, double[] y) {
        if (Precision.equals((double)a[0], (double)0.0)) {
            if (Precision.equals((double)a[1], (double)0.0)) {
                return 0;
            }
            y[0] = -a[2] / a[1];
            return 1;
        }
        double b = -0.5 * a[1] / a[0];
        double c = a[2] / a[0];
        double d = b * b - c;
        if (d < 0.0) {
            return 0;
        }
        if (d > 0.0) {
            double y0 = b + FastMath.copySign((double)FastMath.sqrt((double)d), (double)b);
            double y1 = c / y0;
            y[0] = FastMath.max((double)y0, (double)y1);
            y[1] = FastMath.min((double)y0, (double)y1);
            return 2;
        }
        y[0] = b;
        y[1] = b;
        return 2;
    }
}

