/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.apache.commons.math3.analysis.UnivariateVectorFunction;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.forces.ForceModel;
import org.orekit.frames.Frame;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.CjSjCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.ShortPeriodicsInterpolatedCoefficient;
import org.orekit.time.AbsoluteDate;

public abstract class AbstractGaussianContribution
implements DSSTForceModel {
    private static final int[] GAUSS_ORDER = new int[]{12, 16, 20, 24, 32, 40, 48};
    private static final int MAX_ORDER_RANK = GAUSS_ORDER.length - 1;
    private static final int INTERPOLATION_POINTS = 3;
    private static final int JMAX = 12;
    protected int I;
    protected double a;
    protected double k;
    protected double h;
    protected double q;
    protected double p;
    protected double ecc;
    protected double n;
    protected double lm;
    protected Vector3D f;
    protected Vector3D g;
    protected Vector3D w;
    protected double A;
    protected double B;
    protected double C;
    protected double ton2a;
    protected double ooA;
    protected double ooAB;
    protected double co2AB;
    protected double ooBpo;
    protected double ooMu;
    protected double mu;
    private final ForceModel contribution;
    private final double threshold;
    private GaussQuadrature integrator;
    private boolean isDirty;
    private AttitudeProvider attitudeProvider;
    private GaussianShortPeriodicCoefficients gaussianSPCoefs;
    private Frame frame;

    protected AbstractGaussianContribution(double threshold, ForceModel contribution) {
        this.contribution = contribution;
        this.threshold = threshold;
        this.integrator = new GaussQuadrature(GAUSS_ORDER[MAX_ORDER_RANK]);
        this.isDirty = true;
    }

    @Override
    public void initialize(AuxiliaryElements aux, boolean meanOnly) throws OrekitException {
        this.frame = aux.getFrame();
        if (!meanOnly) {
            this.gaussianSPCoefs = new GaussianShortPeriodicCoefficients(12, 3);
        }
    }

    @Override
    public void initializeStep(AuxiliaryElements aux) throws OrekitException {
        this.a = aux.getSma();
        this.k = aux.getK();
        this.h = aux.getH();
        this.q = aux.getQ();
        this.p = aux.getP();
        this.I = aux.getRetrogradeFactor();
        this.ecc = aux.getEcc();
        this.A = aux.getA();
        this.B = aux.getB();
        this.C = aux.getC();
        this.f = aux.getVectorF();
        this.g = aux.getVectorG();
        this.w = aux.getVectorW();
        this.n = aux.getMeanMotion();
        this.lm = aux.getLM();
        this.ooA = 1.0 / this.A;
        this.ooAB = this.ooA / this.B;
        this.co2AB = this.C * this.ooAB / 2.0;
        this.ooBpo = 1.0 / (1.0 + this.B);
        this.ton2a = 2.0 / (this.n * this.n * this.a);
        this.mu = aux.getMu();
        this.ooMu = 1.0 / this.mu;
    }

    @Override
    public double[] getMeanElementRate(SpacecraftState state) throws OrekitException {
        double[] meanElementRate = new double[6];
        double[] ll = this.getLLimits(state);
        if (ll[0] < ll[1]) {
            meanElementRate = this.getMeanElementRate(state, this.integrator, ll[0], ll[1]);
            if (this.isDirty) {
                boolean next = true;
                for (int i = 0; i < MAX_ORDER_RANK && next; ++i) {
                    double[] meanRates = this.getMeanElementRate(state, new GaussQuadrature(GAUSS_ORDER[i]), ll[0], ll[1]);
                    if (!(this.getRatesDiff(meanElementRate, meanRates) < this.threshold)) continue;
                    this.integrator = new GaussQuadrature(GAUSS_ORDER[i]);
                    next = false;
                }
                this.isDirty = false;
            }
        }
        return meanElementRate;
    }

    protected Vector3D getAcceleration(SpacecraftState state) throws OrekitException {
        AccelerationRetriever retriever = new AccelerationRetriever(state);
        this.contribution.addContribution(state, retriever);
        return retriever.getAcceleration();
    }

    protected abstract double[] getLLimits(SpacecraftState var1) throws OrekitException;

    private double[] getMeanElementRate(SpacecraftState state, GaussQuadrature gauss, double low, double high) throws OrekitException {
        double[] meanElementRate = gauss.integrate(new IntegrableFunction(state, true, 0), low, high);
        double coef = 1.0 / (Math.PI * 2 * this.B);
        int i = 0;
        while (i < 6) {
            int n = i++;
            meanElementRate[n] = meanElementRate[n] * coef;
        }
        return meanElementRate;
    }

    private double getRatesDiff(double[] meanRef, double[] meanCur) {
        double maxDiff = FastMath.abs((double)(meanRef[0] - meanCur[0])) / this.a;
        for (int i = 1; i < meanRef.length; ++i) {
            double diff = FastMath.abs((double)(meanRef[i] - meanCur[i]));
            if (!(maxDiff < diff)) continue;
            maxDiff = diff;
        }
        return maxDiff;
    }

    @Override
    public void registerAttitudeProvider(AttitudeProvider provider) {
        this.attitudeProvider = provider;
    }

    @Override
    public double[] getShortPeriodicVariations(AbsoluteDate date, double[] meanElements) throws OrekitException {
        Orbit meanOrbit = OrbitType.EQUINOCTIAL.mapArrayToOrbit(meanElements, PositionAngle.MEAN, date, this.mu, this.frame);
        double L = meanOrbit.getLv();
        double center = L - meanElements[5];
        double center2 = center * center;
        double[] shortPeriodicVariation = new double[6];
        for (int i = 0; i < 6; ++i) {
            shortPeriodicVariation[i] = this.gaussianSPCoefs.getCij(i, 0, date) + center * this.gaussianSPCoefs.getDij(i, 1, date);
            if (i != 5) continue;
            int n = i;
            shortPeriodicVariation[n] = shortPeriodicVariation[n] + center2 * this.gaussianSPCoefs.getDij(i, 2, date);
        }
        for (int j = 1; j <= 12; ++j) {
            int i = 0;
            while (i < 6) {
                double cij = this.gaussianSPCoefs.getCij(i, j, date);
                double sij = this.gaussianSPCoefs.getSij(i, j, date);
                int n = i;
                shortPeriodicVariation[n] = shortPeriodicVariation[n] + cij * FastMath.cos((double)((double)j * L));
                int n2 = i++;
                shortPeriodicVariation[n2] = shortPeriodicVariation[n2] + sij * FastMath.sin((double)((double)j * L));
            }
        }
        return shortPeriodicVariation;
    }

    @Override
    public void computeShortPeriodicsCoefficients(SpacecraftState state) throws OrekitException {
        this.gaussianSPCoefs.computeCoefficients(state);
    }

    @Override
    public void resetShortPeriodicsCoefficients() {
        if (this.gaussianSPCoefs != null) {
            this.gaussianSPCoefs.resetCoefficients();
        }
    }

    private static class UijVijCoefficients {
        private final double[][] u1ij;
        private final double[][] v1ij;
        private final double[] u2ij;
        private final double[] v2ij;
        private final double[][] currentRhoSigmaj;
        private final FourierCjSjCoefficients fourierCjSj;
        private final int jMax;

        public UijVijCoefficients(double[][] currentRhoSigmaj, FourierCjSjCoefficients fourierCjSj, int jMax) {
            this.currentRhoSigmaj = currentRhoSigmaj;
            this.fourierCjSj = fourierCjSj;
            this.jMax = jMax;
            this.u1ij = new double[6][2 * jMax + 1];
            this.v1ij = new double[6][2 * jMax + 1];
            this.u2ij = new double[jMax + 1];
            this.v2ij = new double[jMax + 1];
            this.computeU1V1Coefficients();
            this.computeU2V2Coefficients();
        }

        private void computeU1V1Coefficients() {
            double ooj;
            int j;
            this.u1ij[0][0] = 0.0;
            for (j = 1; j <= this.jMax; ++j) {
                ooj = 1.0 / (double)j;
                for (int i = 0; i < 6; ++i) {
                    int kIndex;
                    this.u1ij[i][j] = this.fourierCjSj.getSij(i, j);
                    this.v1ij[i][j] = this.fourierCjSj.getCij(i, j);
                    if (j > 1) {
                        for (kIndex = 1; kIndex <= j - 1; ++kIndex) {
                            double[] dArray = this.u1ij[i];
                            int n = j;
                            dArray[n] = dArray[n] + (this.fourierCjSj.getCij(i, j - kIndex) * this.currentRhoSigmaj[1][kIndex] + this.fourierCjSj.getSij(i, j - kIndex) * this.currentRhoSigmaj[0][kIndex]);
                            double[] dArray2 = this.v1ij[i];
                            int n2 = j;
                            dArray2[n2] = dArray2[n2] + (this.fourierCjSj.getCij(i, j - kIndex) * this.currentRhoSigmaj[0][kIndex] - this.fourierCjSj.getSij(i, j - kIndex) * this.currentRhoSigmaj[1][kIndex]);
                        }
                    }
                    if (j != this.jMax) {
                        for (kIndex = 1; kIndex <= this.jMax - j; ++kIndex) {
                            double[] dArray = this.u1ij[i];
                            int n = j;
                            dArray[n] = dArray[n] + (-this.fourierCjSj.getCij(i, j + kIndex) * this.currentRhoSigmaj[1][kIndex] + this.fourierCjSj.getSij(i, j + kIndex) * this.currentRhoSigmaj[0][kIndex]);
                            double[] dArray3 = this.v1ij[i];
                            int n3 = j;
                            dArray3[n3] = dArray3[n3] + (this.fourierCjSj.getCij(i, j + kIndex) * this.currentRhoSigmaj[0][kIndex] + this.fourierCjSj.getSij(i, j + kIndex) * this.currentRhoSigmaj[1][kIndex]);
                        }
                    }
                    for (kIndex = 1; kIndex <= this.jMax; ++kIndex) {
                        double[] dArray = this.u1ij[i];
                        int n = j;
                        dArray[n] = dArray[n] + (-this.fourierCjSj.getCij(i, kIndex) * this.currentRhoSigmaj[1][j + kIndex] - this.fourierCjSj.getSij(i, kIndex) * this.currentRhoSigmaj[0][j + kIndex]);
                        double[] dArray4 = this.v1ij[i];
                        int n4 = j;
                        dArray4[n4] = dArray4[n4] + (this.fourierCjSj.getCij(i, kIndex) * this.currentRhoSigmaj[0][j + kIndex] + this.fourierCjSj.getSij(i, kIndex) * this.currentRhoSigmaj[1][j + kIndex]);
                    }
                    double[] dArray = this.u1ij[i];
                    int n = j;
                    dArray[n] = dArray[n] * -ooj;
                    double[] dArray5 = this.v1ij[i];
                    int n5 = j;
                    dArray5[n5] = dArray5[n5] * ooj;
                    if (i != 0) continue;
                    double[] dArray6 = this.u1ij[0];
                    dArray6[0] = dArray6[0] + (-this.u1ij[0][j] * this.currentRhoSigmaj[0][j] - this.v1ij[0][j] * this.currentRhoSigmaj[1][j]);
                }
            }
            j = this.jMax + 1;
            while (j <= 2 * this.jMax) {
                int kIndex;
                ooj = 1.0 / (double)j;
                this.u1ij[0][j] = 0.0;
                this.v1ij[0][j] = 0.0;
                for (kIndex = j - this.jMax; kIndex <= j - 1; ++kIndex) {
                    double[] dArray = this.u1ij[0];
                    int n = j;
                    dArray[n] = dArray[n] + (this.fourierCjSj.getCij(0, j - kIndex) * this.currentRhoSigmaj[1][kIndex] + this.fourierCjSj.getSij(0, j - kIndex) * this.currentRhoSigmaj[0][kIndex]);
                    double[] dArray7 = this.v1ij[0];
                    int n6 = j;
                    dArray7[n6] = dArray7[n6] + (this.fourierCjSj.getCij(0, j - kIndex) * this.currentRhoSigmaj[0][kIndex] - this.fourierCjSj.getSij(0, j - kIndex) * this.currentRhoSigmaj[1][kIndex]);
                }
                for (kIndex = 1; kIndex <= this.jMax; ++kIndex) {
                    double[] dArray = this.u1ij[0];
                    int n = j;
                    dArray[n] = dArray[n] + (-this.fourierCjSj.getCij(0, kIndex) * this.currentRhoSigmaj[1][j + kIndex] - this.fourierCjSj.getSij(0, kIndex) * this.currentRhoSigmaj[0][j + kIndex]);
                    double[] dArray8 = this.v1ij[0];
                    int n7 = j;
                    dArray8[n7] = dArray8[n7] + (this.fourierCjSj.getCij(0, kIndex) * this.currentRhoSigmaj[0][j + kIndex] + this.fourierCjSj.getSij(0, kIndex) * this.currentRhoSigmaj[1][j + kIndex]);
                }
                double[] dArray = this.u1ij[0];
                int n = j;
                dArray[n] = dArray[n] * -ooj;
                double[] dArray9 = this.v1ij[0];
                int n8 = j++;
                dArray9[n8] = dArray9[n8] * ooj;
            }
        }

        private void computeU2V2Coefficients() {
            int j = 1;
            while (j <= this.jMax) {
                int l;
                double ooj = 1.0 / (double)j;
                this.u2ij[j] = this.v1ij[0][j];
                this.v2ij[j] = this.u1ij[0][j];
                if (j > 1) {
                    for (l = 1; l <= j - 1; ++l) {
                        int n = j;
                        this.u2ij[n] = this.u2ij[n] + (this.u1ij[0][j - l] * this.currentRhoSigmaj[1][l] + this.v1ij[0][j - l] * this.currentRhoSigmaj[0][l]);
                        int n2 = j;
                        this.v2ij[n2] = this.v2ij[n2] + (this.u1ij[0][j - l] * this.currentRhoSigmaj[0][l] - this.v1ij[0][j - l] * this.currentRhoSigmaj[1][l]);
                    }
                }
                for (l = 1; l <= this.jMax; ++l) {
                    int n = j;
                    this.u2ij[n] = this.u2ij[n] + (-this.u1ij[0][j + l] * this.currentRhoSigmaj[1][l] + this.u1ij[0][l] * this.currentRhoSigmaj[1][j + l] + this.v1ij[0][j + l] * this.currentRhoSigmaj[0][l] - this.v1ij[0][l] * this.currentRhoSigmaj[0][j + l]);
                    int n3 = j;
                    this.u2ij[n3] = this.u2ij[n3] + (this.u1ij[0][j + l] * this.currentRhoSigmaj[0][l] + this.u1ij[0][l] * this.currentRhoSigmaj[0][j + l] + this.v1ij[0][j + l] * this.currentRhoSigmaj[1][l] + this.v1ij[0][l] * this.currentRhoSigmaj[1][j + l]);
                }
                int n = j;
                this.u2ij[n] = this.u2ij[n] * -ooj;
                int n4 = j++;
                this.v2ij[n4] = this.v2ij[n4] * ooj;
            }
        }

        public double getU1(int j, int i) {
            return this.u1ij[i][j];
        }

        public double getV1(int j, int i) {
            return this.v1ij[i][j];
        }

        public double getU2(int j) {
            return this.u2ij[j];
        }

        public double getV2(int j) {
            return this.v2ij[j];
        }
    }

    private class GaussianShortPeriodicCoefficients {
        private final int jMax;
        private final ShortPeriodicsInterpolatedCoefficient[][] dij;
        private final ShortPeriodicsInterpolatedCoefficient[][] cij;
        private final ShortPeriodicsInterpolatedCoefficient[][] sij;
        private final double[][] currentRhoSigmaj;

        public GaussianShortPeriodicCoefficients(int jMax, int interpolationPoints) {
            this.jMax = jMax;
            this.dij = new ShortPeriodicsInterpolatedCoefficient[3][6];
            this.cij = new ShortPeriodicsInterpolatedCoefficient[jMax + 1][6];
            this.sij = new ShortPeriodicsInterpolatedCoefficient[jMax + 1][6];
            this.currentRhoSigmaj = new double[2][3 * jMax + 1];
            for (int j = 0; j <= jMax; ++j) {
                for (int i = 0; i < 6; ++i) {
                    this.cij[j][i] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                    if (j > 0) {
                        this.sij[j][i] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                    }
                    if (j != 1 && (j != 2 || i != 5)) continue;
                    this.dij[j][i] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                }
            }
        }

        public void computeCoefficients(SpacecraftState state) throws OrekitException {
            AbsoluteDate date = state.getDate();
            this.computeRhoSigmaCoefficients(date);
            FourierCjSjCoefficients fourierCjSj = new FourierCjSjCoefficients(state, this.jMax);
            UijVijCoefficients uijvij = new UijVijCoefficients(this.currentRhoSigmaj, fourierCjSj, this.jMax);
            double k20 = this.computeK20(this.jMax);
            double oon = 1.0 / AbstractGaussianContribution.this.n;
            double to2an = 1.5 * oon / AbstractGaussianContribution.this.a;
            double to4an = to2an / 2.0;
            for (int i = 0; i < 6; ++i) {
                double di1 = -oon * fourierCjSj.getCij(i, 0);
                if (i == 5) {
                    di1 += to2an * uijvij.getU1(0, 0);
                }
                double di2 = 0.0;
                if (i == 5) {
                    di2 += -to4an * fourierCjSj.getCij(0, 0);
                }
                double currentCi0 = -di2 * k20;
                for (int j = 1; j <= this.jMax; ++j) {
                    double currentCij = oon * uijvij.getU1(j, i);
                    if (i == 5) {
                        currentCij += -to2an * uijvij.getU2(j);
                    }
                    double currentSij = oon * uijvij.getV1(j, i);
                    if (i == 5) {
                        currentSij += -to2an * uijvij.getV2(j);
                    }
                    currentCi0 += -(currentCij * this.currentRhoSigmaj[0][j] + currentSij * this.currentRhoSigmaj[1][j]);
                    this.cij[j][i].addGridPoint(date, currentCij);
                    this.sij[j][i].addGridPoint(date, currentSij);
                }
                this.cij[0][i].addGridPoint(date, currentCi0);
                this.dij[1][i].addGridPoint(date, di1);
                if (i != 5) continue;
                this.dij[2][i].addGridPoint(date, di2);
            }
        }

        public void resetCoefficients() {
            for (int j = 0; j <= this.jMax; ++j) {
                for (int i = 0; i < 6; ++i) {
                    this.cij[j][i].clearHistory();
                    if (j > 0) {
                        this.sij[j][i].clearHistory();
                    }
                    if (j != 1 && (j != 2 || i != 5)) continue;
                    this.dij[j][i].clearHistory();
                }
            }
        }

        private void computeRhoSigmaCoefficients(AbsoluteDate date) {
            CjSjCoefficient cjsjKH = new CjSjCoefficient(AbstractGaussianContribution.this.k, AbstractGaussianContribution.this.h);
            double b = 1.0 / (1.0 + AbstractGaussianContribution.this.B);
            double mbtj = 1.0;
            for (int j = 1; j <= 3 * this.jMax; ++j) {
                double coef = (1.0 + (double)j * AbstractGaussianContribution.this.B) * (mbtj *= -b);
                this.currentRhoSigmaj[0][j] = coef * cjsjKH.getCj(j);
                this.currentRhoSigmaj[1][j] = coef * cjsjKH.getSj(j);
            }
        }

        private double computeK20(int kMax) {
            double k20 = 0.0;
            for (int kIndex = 1; kIndex <= kMax; ++kIndex) {
                double currentTerm = this.currentRhoSigmaj[1][kIndex] * this.currentRhoSigmaj[1][kIndex] + this.currentRhoSigmaj[0][kIndex] * this.currentRhoSigmaj[0][kIndex];
                k20 += (currentTerm *= 2.0 / (double)(kIndex * kIndex));
            }
            return k20;
        }

        public double getCij(int i, int j, AbsoluteDate date) {
            return this.cij[j][i].value(date);
        }

        public double getSij(int i, int j, AbsoluteDate date) {
            return this.sij[j][i].value(date);
        }

        public double getDij(int i, int j, AbsoluteDate date) {
            return this.dij[j][i].value(date);
        }
    }

    private class FourierCjSjCoefficients {
        private final int jMax;
        private final double[][] cCoef;
        private final double[][] sCoef;

        public FourierCjSjCoefficients(SpacecraftState state, int jMax) throws OrekitException {
            this.jMax = jMax;
            this.cCoef = new double[jMax + 1][6];
            this.sCoef = new double[jMax + 1][6];
            this.computeCoefficients(state);
        }

        private void computeCoefficients(SpacecraftState state) throws OrekitException {
            double[] ll = AbstractGaussianContribution.this.getLLimits(state);
            if (ll[0] < ll[1]) {
                double ooPI = 0.3183098861837907;
                for (int j = 0; j <= this.jMax; ++j) {
                    double[] curentCoefficients = AbstractGaussianContribution.this.integrator.integrate(new IntegrableFunction(state, false, j), ll[0], ll[1]);
                    for (int i = 0; i < 6; ++i) {
                        this.cCoef[j][i] = 0.3183098861837907 * curentCoefficients[i];
                        this.sCoef[j][i] = 0.3183098861837907 * curentCoefficients[i + 6];
                    }
                }
            }
        }

        public double getCij(int i, int j) {
            return this.cCoef[j][i];
        }

        public double getSij(int i, int j) {
            return this.sCoef[j][i];
        }
    }

    private static class GaussQuadrature {
        private static final double[] P_12 = new double[]{-0.9815606342467191, -0.9041172563704749, -0.7699026741943047, -0.5873179542866174, -0.36783149899818024, -0.1252334085114689, 0.1252334085114689, 0.36783149899818024, 0.5873179542866174, 0.7699026741943047, 0.9041172563704749, 0.9815606342467191};
        private static final double[] W_12 = new double[]{0.0471753363865122, 0.1069393259953183, 0.16007832854334633, 0.20316742672306584, 0.23349253653835478, 0.24914704581340286, 0.24914704581340286, 0.23349253653835478, 0.20316742672306584, 0.16007832854334633, 0.1069393259953183, 0.0471753363865122};
        private static final double[] P_16 = new double[]{-0.9894009349916499, -0.9445750230732326, -0.8656312023878316, -0.7554044083550031, -0.6178762444026438, -0.45801677765722737, -0.2816035507792589, -0.09501250983763745, 0.09501250983763745, 0.2816035507792589, 0.45801677765722737, 0.6178762444026438, 0.7554044083550031, 0.8656312023878316, 0.9445750230732326, 0.9894009349916499};
        private static final double[] W_16 = new double[]{0.027152459411754058, 0.06225352393864777, 0.09515851168249283, 0.12462897125553388, 0.14959598881657685, 0.16915651939500256, 0.1826034150449236, 0.18945061045506847, 0.18945061045506847, 0.1826034150449236, 0.16915651939500256, 0.14959598881657685, 0.12462897125553388, 0.09515851168249283, 0.06225352393864777, 0.027152459411754058};
        private static final double[] P_20 = new double[]{-0.9931285991850949, -0.9639719272779139, -0.912234428251326, -0.8391169718222189, -0.7463319064601508, -0.6360536807265151, -0.510867001950827, -0.37370608871541955, -0.22778585114164507, -0.07652652113349734, 0.07652652113349734, 0.22778585114164507, 0.37370608871541955, 0.510867001950827, 0.6360536807265151, 0.7463319064601508, 0.8391169718222189, 0.912234428251326, 0.9639719272779139, 0.9931285991850949};
        private static final double[] W_20 = new double[]{0.017614007139152264, 0.04060142980038684, 0.06267204833410904, 0.08327674157670477, 0.10193011981724048, 0.11819453196151844, 0.13168863844917678, 0.14209610931838212, 0.1491729864726038, 0.152753387130726, 0.152753387130726, 0.1491729864726038, 0.14209610931838212, 0.13168863844917678, 0.11819453196151844, 0.10193011981724048, 0.08327674157670477, 0.06267204833410904, 0.04060142980038684, 0.017614007139152264};
        private static final double[] P_24 = new double[]{-0.9951872199970213, -0.9747285559713095, -0.9382745520027327, -0.886415527004401, -0.820001985973903, -0.7401241915785544, -0.6480936519369755, -0.5454214713888395, -0.4337935076260452, -0.3150426796961634, -0.19111886747361634, -0.06405689286260563, 0.06405689286260563, 0.19111886747361634, 0.3150426796961634, 0.4337935076260452, 0.5454214713888395, 0.6480936519369755, 0.7401241915785544, 0.820001985973903, 0.886415527004401, 0.9382745520027327, 0.9747285559713095, 0.9951872199970213};
        private static final double[] W_24 = new double[]{0.012341229799987335, 0.028531388628933806, 0.04427743881741981, 0.059298584915436915, 0.07334648141108027, 0.0861901615319532, 0.09761865210411391, 0.10744427011596558, 0.11550566805372553, 0.12167047292780335, 0.12583745634682825, 0.12793819534675221, 0.12793819534675221, 0.12583745634682825, 0.12167047292780335, 0.11550566805372553, 0.10744427011596558, 0.09761865210411391, 0.0861901615319532, 0.07334648141108027, 0.059298584915436915, 0.04427743881741981, 0.028531388628933806, 0.012341229799987335};
        private static final double[] P_32 = new double[]{-0.9972638618494816, -0.9856115115452684, -0.9647622555875064, -0.9349060759377397, -0.8963211557660522, -0.8493676137325699, -0.7944837959679425, -0.7321821187402897, -0.6630442669302152, -0.5877157572407623, -0.5068999089322295, -0.4213512761306354, -0.33186860228212767, -0.2392873622521371, -0.14447196158279646, -0.04830766568773831, 0.04830766568773831, 0.14447196158279646, 0.2392873622521371, 0.33186860228212767, 0.4213512761306354, 0.5068999089322295, 0.5877157572407623, 0.6630442669302152, 0.7321821187402897, 0.7944837959679425, 0.8493676137325699, 0.8963211557660522, 0.9349060759377397, 0.9647622555875064, 0.9856115115452684, 0.9972638618494816};
        private static final double[] W_32 = new double[]{0.007018610009470136, 0.016274394730905712, 0.025392065309262142, 0.03427386291302141, 0.042835898022226586, 0.050998059262376216, 0.05868409347853559, 0.06582222277636193, 0.07234579410884862, 0.07819389578707042, 0.08331192422694673, 0.0876520930044038, 0.0911738786957639, 0.09384439908080441, 0.09563872007927487, 0.09654008851472784, 0.09654008851472784, 0.09563872007927487, 0.09384439908080441, 0.0911738786957639, 0.0876520930044038, 0.08331192422694673, 0.07819389578707042, 0.07234579410884862, 0.06582222277636193, 0.05868409347853559, 0.050998059262376216, 0.042835898022226586, 0.03427386291302141, 0.025392065309262142, 0.016274394730905712, 0.007018610009470136};
        private static final double[] P_40 = new double[]{-0.9982377097105593, -0.9907262386994571, -0.9772599499837742, -0.9579168192137917, -0.9328128082786766, -0.9020988069688742, -0.8659595032122596, -0.8246122308333117, -0.7783056514265194, -0.7273182551899271, -0.6719566846141796, -0.6125538896679803, -0.5494671250951282, -0.4830758016861787, -0.413779204371605, -0.3419940908257585, -0.2681521850072537, -0.1926975807013711, -0.11608407067525522, -0.038772417506050816, 0.038772417506050816, 0.11608407067525522, 0.1926975807013711, 0.2681521850072537, 0.3419940908257585, 0.413779204371605, 0.4830758016861787, 0.5494671250951282, 0.6125538896679803, 0.6719566846141796, 0.7273182551899271, 0.7783056514265194, 0.8246122308333117, 0.8659595032122596, 0.9020988069688742, 0.9328128082786766, 0.9579168192137917, 0.9772599499837742, 0.9907262386994571, 0.9982377097105593};
        private static final double[] W_40 = new double[]{0.004521277098533098, 0.010498284531152704, 0.016421058381907973, 0.02224584919416689, 0.02793700698002338, 0.033460195282547865, 0.03878216797447199, 0.04387090818567333, 0.04869580763507221, 0.05322784698393679, 0.05743976909939157, 0.06130624249292891, 0.06480401345660108, 0.06791204581523394, 0.07061164739128681, 0.07288658239580408, 0.07472316905796833, 0.07611036190062619, 0.07703981816424793, 0.07750594797842482, 0.07750594797842482, 0.07703981816424793, 0.07611036190062619, 0.07472316905796833, 0.07288658239580408, 0.07061164739128681, 0.06791204581523394, 0.06480401345660108, 0.06130624249292891, 0.05743976909939157, 0.05322784698393679, 0.04869580763507221, 0.04387090818567333, 0.03878216797447199, 0.033460195282547865, 0.02793700698002338, 0.02224584919416689, 0.016421058381907973, 0.010498284531152704, 0.004521277098533098};
        private static final double[] P_48 = new double[]{-0.9987710072524261, -0.9935301722663508, -0.984124583722827, -0.9705915925462472, -0.9529877031604308, -0.9313866907065544, -0.9058791367155696, -0.876572020274248, -0.8435882616243935, -0.8070662040294425, -0.7671590325157402, -0.7240341309238147, -0.677872379632664, -0.6288673967765137, -0.5772247260839727, -0.523160974722233, -0.4669029047509584, -0.4086864819907168, -0.3487558862921607, -0.28736248735545555, -0.22476379039468908, -0.16122235606889174, -0.0970046992094627, -0.03238017096286937, 0.03238017096286937, 0.0970046992094627, 0.16122235606889174, 0.22476379039468908, 0.28736248735545555, 0.3487558862921607, 0.4086864819907168, 0.4669029047509584, 0.523160974722233, 0.5772247260839727, 0.6288673967765137, 0.677872379632664, 0.7240341309238147, 0.7671590325157402, 0.8070662040294425, 0.8435882616243935, 0.876572020274248, 0.9058791367155696, 0.9313866907065544, 0.9529877031604308, 0.9705915925462472, 0.984124583722827, 0.9935301722663508, 0.9987710072524261};
        private static final double[] W_48 = new double[]{0.0031533460523059625, 0.007327553901276208, 0.011477234579234469, 0.015579315722943866, 0.019616160457355567, 0.023570760839324356, 0.02742650970835688, 0.03116722783279807, 0.03477722256477045, 0.038241351065830806, 0.04154508294346483, 0.04467456085669424, 0.04761665849249054, 0.05035903555385448, 0.05289018948519365, 0.055199503699984165, 0.05727729210040315, 0.05911483969839566, 0.06070443916589384, 0.06203942315989268, 0.06311419228625403, 0.06392423858464817, 0.0644661644359501, 0.06473769681268386, 0.06473769681268386, 0.0644661644359501, 0.06392423858464817, 0.06311419228625403, 0.06203942315989268, 0.06070443916589384, 0.05911483969839566, 0.05727729210040315, 0.055199503699984165, 0.05289018948519365, 0.05035903555385448, 0.04761665849249054, 0.04467456085669424, 0.04154508294346483, 0.038241351065830806, 0.03477722256477045, 0.03116722783279807, 0.02742650970835688, 0.023570760839324356, 0.019616160457355567, 0.015579315722943866, 0.011477234579234469, 0.007327553901276208, 0.0031533460523059625};
        private final double[] nodePoints;
        private final double[] nodeWeights;

        public GaussQuadrature(int numberOfPoints) {
            switch (numberOfPoints) {
                case 12: {
                    this.nodePoints = (double[])P_12.clone();
                    this.nodeWeights = (double[])W_12.clone();
                    break;
                }
                case 16: {
                    this.nodePoints = (double[])P_16.clone();
                    this.nodeWeights = (double[])W_16.clone();
                    break;
                }
                case 20: {
                    this.nodePoints = (double[])P_20.clone();
                    this.nodeWeights = (double[])W_20.clone();
                    break;
                }
                case 24: {
                    this.nodePoints = (double[])P_24.clone();
                    this.nodeWeights = (double[])W_24.clone();
                    break;
                }
                case 32: {
                    this.nodePoints = (double[])P_32.clone();
                    this.nodeWeights = (double[])W_32.clone();
                    break;
                }
                case 40: {
                    this.nodePoints = (double[])P_40.clone();
                    this.nodeWeights = (double[])W_40.clone();
                    break;
                }
                default: {
                    this.nodePoints = (double[])P_48.clone();
                    this.nodeWeights = (double[])W_48.clone();
                }
            }
        }

        public double[] integrate(UnivariateVectorFunction f, double lowerBound, double upperBound) {
            double[] adaptedPoints = (double[])this.nodePoints.clone();
            double[] adaptedWeights = (double[])this.nodeWeights.clone();
            this.transform(adaptedPoints, adaptedWeights, lowerBound, upperBound);
            return this.basicIntegrate(f, adaptedPoints, adaptedWeights);
        }

        private void transform(double[] points, double[] weights, double a, double b) {
            double scale = (b - a) / 2.0;
            double shift = a + scale;
            int i = 0;
            while (i < points.length) {
                points[i] = points[i] * scale + shift;
                int n = i++;
                weights[n] = weights[n] * scale;
            }
        }

        private double[] basicIntegrate(UnivariateVectorFunction f, double[] points, double[] weights) {
            double x = points[0];
            double w = weights[0];
            double[] v = f.value(x);
            double[] y = new double[v.length];
            for (int j = 0; j < v.length; ++j) {
                y[j] = w * v[j];
            }
            double[] t = (double[])y.clone();
            double[] c = new double[v.length];
            double[] s = (double[])t.clone();
            for (int i = 1; i < points.length; ++i) {
                x = points[i];
                w = weights[i];
                v = f.value(x);
                for (int j = 0; j < v.length; ++j) {
                    y[j] = w * v[j] - c[j];
                    t[j] = s[j] + y[j];
                    c[j] = t[j] - s[j] - y[j];
                    s[j] = t[j];
                }
            }
            return s;
        }
    }

    private class IntegrableFunction
    implements UnivariateVectorFunction {
        private final SpacecraftState state;
        private final boolean meanMode;
        private final int j;

        public IntegrableFunction(SpacecraftState state, boolean meanMode, int j) {
            this.state = state;
            this.meanMode = meanMode;
            this.j = j;
        }

        public double[] value(double x) {
            double shiftedLm = this.trueToMean(x);
            double dLm = shiftedLm - AbstractGaussianContribution.this.lm;
            double dt = dLm / AbstractGaussianContribution.this.n;
            double cosL = FastMath.cos((double)x);
            double sinL = FastMath.sin((double)x);
            double roa = AbstractGaussianContribution.this.B * AbstractGaussianContribution.this.B / (1.0 + AbstractGaussianContribution.this.h * sinL + AbstractGaussianContribution.this.k * cosL);
            double roa2 = roa * roa;
            double r = AbstractGaussianContribution.this.a * roa;
            double X = r * cosL;
            double Y = r * sinL;
            double naob = AbstractGaussianContribution.this.n * AbstractGaussianContribution.this.a / AbstractGaussianContribution.this.B;
            double Xdot = -naob * (AbstractGaussianContribution.this.h + sinL);
            double Ydot = naob * (AbstractGaussianContribution.this.k + cosL);
            Vector3D vel = new Vector3D(Xdot, AbstractGaussianContribution.this.f, Ydot, AbstractGaussianContribution.this.g);
            Vector3D acc = Vector3D.ZERO;
            try {
                Orbit shiftedOrbit = this.state.getOrbit().shiftedBy(dt);
                EquinoctialOrbit recomposedOrbit = new EquinoctialOrbit(shiftedOrbit.getA(), shiftedOrbit.getEquinoctialEx(), shiftedOrbit.getEquinoctialEy(), shiftedOrbit.getHx(), shiftedOrbit.getHy(), shiftedOrbit.getLv(), PositionAngle.TRUE, shiftedOrbit.getFrame(), this.state.getDate(), shiftedOrbit.getMu());
                Attitude recomposedAttitude = AbstractGaussianContribution.this.attitudeProvider.getAttitude(recomposedOrbit, recomposedOrbit.getDate(), recomposedOrbit.getFrame());
                SpacecraftState shiftedState = new SpacecraftState((Orbit)recomposedOrbit, recomposedAttitude, this.state.getMass());
                acc = AbstractGaussianContribution.this.getAcceleration(shiftedState);
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
            double[] deriv = new double[]{this.getAoV(vel).dotProduct((Vector)acc), this.getKoV(X, Y, Xdot, Ydot).dotProduct((Vector)acc), this.getHoV(X, Y, Xdot, Ydot).dotProduct((Vector)acc), this.getQoV(X).dotProduct((Vector)acc), this.getPoV(Y).dotProduct((Vector)acc), this.getLoV(X, Y, Xdot, Ydot).dotProduct((Vector)acc)};
            double[] val = null;
            if (this.meanMode) {
                val = new double[6];
                for (int i = 0; i < 6; ++i) {
                    val[i] = roa2 * deriv[i];
                }
            } else {
                val = new double[12];
                double cosjL = this.j == 1 ? cosL : FastMath.cos((double)((double)this.j * x));
                double sinjL = this.j == 1 ? sinL : FastMath.sin((double)((double)this.j * x));
                for (int i = 0; i < 6; ++i) {
                    val[i] = cosjL * deriv[i];
                    val[i + 6] = sinjL * deriv[i];
                }
            }
            return val;
        }

        private double trueToEccentric(double lv) {
            double cosLv = FastMath.cos((double)lv);
            double sinLv = FastMath.sin((double)lv);
            double num = AbstractGaussianContribution.this.h * cosLv - AbstractGaussianContribution.this.k * sinLv;
            double den = AbstractGaussianContribution.this.B + 1.0 + AbstractGaussianContribution.this.k * cosLv + AbstractGaussianContribution.this.h * sinLv;
            return lv + 2.0 * FastMath.atan((double)(num / den));
        }

        private double eccentricToMean(double le) {
            return le - AbstractGaussianContribution.this.k * FastMath.sin((double)le) + AbstractGaussianContribution.this.h * FastMath.cos((double)le);
        }

        private double trueToMean(double lv) {
            return this.eccentricToMean(this.trueToEccentric(lv));
        }

        private Vector3D getAoV(Vector3D vel) {
            return new Vector3D(AbstractGaussianContribution.this.ton2a, vel);
        }

        private Vector3D getHoV(double X, double Y, double Xdot, double Ydot) {
            double kf = (2.0 * Xdot * Y - X * Ydot) * AbstractGaussianContribution.this.ooMu;
            double kg = X * Xdot * AbstractGaussianContribution.this.ooMu;
            double kw = AbstractGaussianContribution.this.k * ((double)AbstractGaussianContribution.this.I * AbstractGaussianContribution.this.q * Y - AbstractGaussianContribution.this.p * X) * AbstractGaussianContribution.this.ooAB;
            return new Vector3D(kf, AbstractGaussianContribution.this.f, -kg, AbstractGaussianContribution.this.g, kw, AbstractGaussianContribution.this.w);
        }

        private Vector3D getKoV(double X, double Y, double Xdot, double Ydot) {
            double kf = Y * Ydot * AbstractGaussianContribution.this.ooMu;
            double kg = (2.0 * X * Ydot - Xdot * Y) * AbstractGaussianContribution.this.ooMu;
            double kw = AbstractGaussianContribution.this.h * ((double)AbstractGaussianContribution.this.I * AbstractGaussianContribution.this.q * Y - AbstractGaussianContribution.this.p * X) * AbstractGaussianContribution.this.ooAB;
            return new Vector3D(-kf, AbstractGaussianContribution.this.f, kg, AbstractGaussianContribution.this.g, -kw, AbstractGaussianContribution.this.w);
        }

        private Vector3D getPoV(double Y) {
            return new Vector3D(AbstractGaussianContribution.this.co2AB * Y, AbstractGaussianContribution.this.w);
        }

        private Vector3D getQoV(double X) {
            return new Vector3D((double)AbstractGaussianContribution.this.I * AbstractGaussianContribution.this.co2AB * X, AbstractGaussianContribution.this.w);
        }

        private Vector3D getLoV(double X, double Y, double Xdot, double Ydot) {
            Vector3D pos = new Vector3D(X, AbstractGaussianContribution.this.f, Y, AbstractGaussianContribution.this.g);
            Vector3D v2 = new Vector3D(AbstractGaussianContribution.this.k, this.getHoV(X, Y, Xdot, Ydot), -AbstractGaussianContribution.this.h, this.getKoV(X, Y, Xdot, Ydot));
            return new Vector3D(-2.0 * AbstractGaussianContribution.this.ooA, pos, AbstractGaussianContribution.this.ooBpo, v2, ((double)AbstractGaussianContribution.this.I * AbstractGaussianContribution.this.q * Y - AbstractGaussianContribution.this.p * X) * AbstractGaussianContribution.this.ooA, AbstractGaussianContribution.this.w);
        }
    }

    private static class AccelerationRetriever
    implements TimeDerivativesEquations {
        private Vector3D acceleration = Vector3D.ZERO;
        private final SpacecraftState state;

        public AccelerationRetriever(SpacecraftState state) {
            this.state = state;
        }

        @Override
        public void addKeplerContribution(double mu) {
        }

        @Override
        public void addXYZAcceleration(double x, double y, double z) {
            this.acceleration = new Vector3D(x, y, z);
        }

        @Override
        public void addAcceleration(Vector3D gamma, Frame frame) throws OrekitException {
            this.acceleration = frame.getTransformTo(this.state.getFrame(), this.state.getDate()).transformVector(gamma);
        }

        @Override
        public void addMassDerivative(double q) {
        }

        public Vector3D getAcceleration() {
            return this.acceleration;
        }
    }
}

