/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.orekit.bodies.BodyShape;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnDecreasing;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AltitudeDetector
extends AbstractDetector<AltitudeDetector> {
    private static final long serialVersionUID = 20131118L;
    private final double altitude;
    private final BodyShape bodyShape;

    public AltitudeDetector(double altitude, BodyShape bodyShape) {
        this(600.0, 1.0E-6, altitude, bodyShape);
    }

    public AltitudeDetector(double maxCheck, double altitude, BodyShape bodyShape) {
        this(maxCheck, 1.0E-6, altitude, bodyShape);
    }

    public AltitudeDetector(double maxCheck, double threshold, double altitude, BodyShape bodyShape) {
        this(maxCheck, threshold, 100, new StopOnDecreasing<AltitudeDetector>(), altitude, bodyShape);
    }

    private AltitudeDetector(double maxCheck, double threshold, int maxIter, EventHandler<AltitudeDetector> handler, double altitude, BodyShape bodyShape) {
        super(maxCheck, threshold, maxIter, handler);
        this.altitude = altitude;
        this.bodyShape = bodyShape;
    }

    @Override
    protected AltitudeDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<AltitudeDetector> newHandler) {
        return new AltitudeDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.altitude, this.bodyShape);
    }

    public double getAltitude() {
        return this.altitude;
    }

    public BodyShape getBodyShape() {
        return this.bodyShape;
    }

    @Override
    public double g(SpacecraftState s) throws OrekitException {
        Frame bodyFrame = this.bodyShape.getBodyFrame();
        TimeStampedPVCoordinates pvBody = s.getPVCoordinates(bodyFrame);
        GeodeticPoint point = this.bodyShape.transform(pvBody.getPosition(), bodyFrame, s.getDate());
        return point.getAltitude() - this.altitude;
    }
}

