/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.AbstractPropagatorConverter;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.utils.TimeStampedPVCoordinates;

public class FiniteDifferencePropagatorConverter
extends AbstractPropagatorConverter {
    private final PropagatorBuilder builder;

    public FiniteDifferencePropagatorConverter(PropagatorBuilder factory, double threshold, int maxIterations) {
        super(factory, threshold, maxIterations);
        this.builder = factory;
    }

    @Override
    protected MultivariateVectorFunction getObjectiveFunction() {
        return new ObjectiveFunction();
    }

    @Override
    protected MultivariateMatrixFunction getObjectiveFunctionJacobian() {
        return new ObjectiveFunctionJacobian();
    }

    private class ObjectiveFunctionJacobian
    implements MultivariateMatrixFunction {
        private ObjectiveFunctionJacobian() {
        }

        public double[][] value(double[] arg) throws IllegalArgumentException, OrekitExceptionWrapper {
            ObjectiveFunction f = new ObjectiveFunction();
            double[][] jacob = new double[FiniteDifferencePropagatorConverter.this.getTargetSize()][arg.length];
            double[] eval = f.value(arg);
            double[] arg1 = new double[arg.length];
            double increment = 0.0;
            for (int j = 0; j < arg.length; ++j) {
                System.arraycopy(arg, 0, arg1, 0, arg.length);
                increment = FastMath.sqrt((double)Precision.EPSILON) * FastMath.abs((double)arg[j]);
                if (increment <= Precision.SAFE_MIN) {
                    increment = FastMath.sqrt((double)Precision.EPSILON);
                }
                int n = j;
                arg1[n] = arg1[n] + increment;
                double[] eval1 = f.value(arg1);
                for (int t = 0; t < eval.length; ++t) {
                    jacob[t][j] = (eval1[t] - eval[t]) / increment;
                }
            }
            return jacob;
        }
    }

    private class ObjectiveFunction
    implements MultivariateVectorFunction {
        private ObjectiveFunction() {
        }

        public double[] value(double[] arg) throws IllegalArgumentException, OrekitExceptionWrapper {
            try {
                Propagator propagator = FiniteDifferencePropagatorConverter.this.builder.buildPropagator(FiniteDifferencePropagatorConverter.this.getDate(), arg);
                double[] eval = new double[FiniteDifferencePropagatorConverter.this.getTargetSize()];
                int k = 0;
                for (SpacecraftState state : FiniteDifferencePropagatorConverter.this.getSample()) {
                    TimeStampedPVCoordinates pv = propagator.getPVCoordinates(state.getDate(), FiniteDifferencePropagatorConverter.this.getFrame());
                    eval[k++] = pv.getPosition().getX();
                    eval[k++] = pv.getPosition().getY();
                    eval[k++] = pv.getPosition().getZ();
                    if (FiniteDifferencePropagatorConverter.this.isOnlyPosition()) continue;
                    eval[k++] = pv.getVelocity().getX();
                    eval[k++] = pv.getVelocity().getY();
                    eval[k++] = pv.getVelocity().getZ();
                }
                return eval;
            }
            catch (OrekitException ex) {
                throw new OrekitExceptionWrapper(ex);
            }
        }
    }
}

