/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.PropagationException;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.time.AbsoluteDate;

public class KeplerianPropagator
extends AbstractAnalyticalPropagator {
    private SpacecraftState initialState;

    public KeplerianPropagator(Orbit initialOrbit) throws PropagationException {
        this(initialOrbit, DEFAULT_LAW, initialOrbit.getMu(), 1000.0);
    }

    public KeplerianPropagator(Orbit initialOrbit, double mu) throws PropagationException {
        this(initialOrbit, DEFAULT_LAW, mu, 1000.0);
    }

    public KeplerianPropagator(Orbit initialOrbit, AttitudeProvider attitudeProv) throws PropagationException {
        this(initialOrbit, attitudeProv, initialOrbit.getMu(), 1000.0);
    }

    public KeplerianPropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mu) throws PropagationException {
        this(initialOrbit, attitudeProv, mu, 1000.0);
    }

    public KeplerianPropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mu, double mass) throws PropagationException {
        super(attitudeProv);
        try {
            this.resetInitialState(new SpacecraftState(initialOrbit, this.getAttitudeProvider().getAttitude(initialOrbit, initialOrbit.getDate(), initialOrbit.getFrame()), mass));
        }
        catch (OrekitException oe) {
            throw new PropagationException(oe);
        }
    }

    @Override
    public void resetInitialState(SpacecraftState state) throws PropagationException {
        super.resetInitialState(state);
        this.initialState = state;
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) throws PropagationException {
        Orbit orbit = this.initialState.getOrbit();
        while (!date.equals((orbit = orbit.shiftedBy(date.durationFrom(orbit.getDate()))).getDate())) {
        }
        return orbit;
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.initialState.getMass();
    }
}

