/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.ExceptionContextProvider;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.errors.PropagationException;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeInterpolable;
import org.orekit.utils.ImmutableTimeStampedCache;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public class Ephemeris
extends AbstractAnalyticalPropagator
implements BoundedPropagator {
    private final AbsoluteDate minDate;
    private final AbsoluteDate maxDate;
    private final Frame frame;
    private final String[] additional;
    private LocalPVProvider pvProvider;
    private final transient ImmutableTimeStampedCache<SpacecraftState> cache;

    public Ephemeris(List<SpacecraftState> states, int interpolationPoints) throws OrekitException, MathIllegalArgumentException {
        super(DEFAULT_LAW);
        if (states.size() < interpolationPoints) {
            throw new MathIllegalArgumentException((Localizable)LocalizedFormats.INSUFFICIENT_DIMENSION, new Object[]{states.size(), interpolationPoints});
        }
        SpacecraftState s0 = states.get(0);
        this.minDate = s0.getDate();
        this.maxDate = states.get(states.size() - 1).getDate();
        this.frame = s0.getFrame();
        Set<String> names0 = s0.getAdditionalStates().keySet();
        this.additional = names0.toArray(new String[names0.size()]);
        for (SpacecraftState state : states) {
            s0.ensureCompatibleAdditionalStates(state);
        }
        this.pvProvider = new LocalPVProvider();
        this.setAttitudeProvider(null);
        this.cache = new ImmutableTimeStampedCache<SpacecraftState>(interpolationPoints, states);
    }

    @Override
    public AbsoluteDate getMinDate() {
        return this.minDate;
    }

    @Override
    public AbsoluteDate getMaxDate() {
        return this.maxDate;
    }

    @Override
    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public SpacecraftState basicPropagate(AbsoluteDate date) throws PropagationException {
        try {
            List<SpacecraftState> neighbors = this.cache.getNeighbors(date);
            TimeInterpolable interpolatedState = neighbors.get(0).interpolate(date, neighbors);
            AttitudeProvider attitudeProvider = this.getAttitudeProvider();
            if (attitudeProvider == null) {
                return interpolatedState;
            }
            this.pvProvider.setCurrentState((SpacecraftState)interpolatedState);
            Attitude calculatedAttitude = attitudeProvider.getAttitude(this.pvProvider, date, ((SpacecraftState)interpolatedState).getFrame());
            return new SpacecraftState(((SpacecraftState)interpolatedState).getOrbit(), calculatedAttitude, ((SpacecraftState)interpolatedState).getMass());
        }
        catch (OrekitException tce) {
            throw new PropagationException(tce);
        }
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) throws PropagationException {
        return this.basicPropagate(date).getOrbit();
    }

    @Override
    protected double getMass(AbsoluteDate date) throws PropagationException {
        return this.basicPropagate(date).getMass();
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame f) throws OrekitException {
        return this.propagate(date).getPVCoordinates(f);
    }

    @Override
    public void resetInitialState(SpacecraftState state) throws PropagationException {
        throw new PropagationException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    public SpacecraftState getInitialState() throws PropagationException {
        return this.basicPropagate(this.getMinDate());
    }

    @Override
    public boolean isAdditionalStateManaged(String name) {
        if (super.isAdditionalStateManaged(name)) {
            return true;
        }
        for (String a : this.additional) {
            if (!a.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getManagedAdditionalStates() {
        String[] upperManaged = super.getManagedAdditionalStates();
        String[] managed = new String[upperManaged.length + this.additional.length];
        System.arraycopy(upperManaged, 0, managed, 0, upperManaged.length);
        System.arraycopy(this.additional, 0, managed, upperManaged.length, this.additional.length);
        return managed;
    }

    private Object writeReplace() {
        return new DataTransferObject(this.cache.getAll(), this.cache.getNeighborsSize());
    }

    private static class LocalPVProvider
    implements PVCoordinatesProvider {
        private SpacecraftState currentState;

        private LocalPVProvider() {
        }

        public SpacecraftState getCurrentState() {
            return this.currentState;
        }

        public void setCurrentState(SpacecraftState state) {
            this.currentState = state;
        }

        @Override
        public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame f) throws OrekitException {
            double dt = this.getCurrentState().getDate().durationFrom(date);
            double closeEnoughTimeInSec = 1.0E-9;
            if (FastMath.abs((double)dt) > 1.0E-9) {
                throw new OrekitException((ExceptionContextProvider)new OutOfRangeException((Number)new Double(FastMath.abs((double)dt)), (Number)0.0, (Number)1.0E-9));
            }
            return this.getCurrentState().getPVCoordinates(f);
        }
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = -8479036196711159270L;
        private final List<SpacecraftState> states;
        private final int interpolationPoints;

        private DataTransferObject(List<SpacecraftState> states, int interpolationPoints) {
            this.states = states;
            this.interpolationPoints = interpolationPoints;
        }

        private Object readResolve() {
            try {
                return new Ephemeris(this.states, this.interpolationPoints);
            }
            catch (OrekitException oe) {
                throw OrekitException.createInternalError(oe);
            }
        }
    }
}

