/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.errors.PropagationException;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.time.AbsoluteDate;

public class AdapterPropagator
extends AbstractAnalyticalPropagator {
    private Propagator reference;
    private List<DifferentialEffect> effects;

    public AdapterPropagator(Propagator reference) {
        super(reference.getAttitudeProvider());
        this.reference = reference;
        this.effects = new ArrayList<DifferentialEffect>();
    }

    public void addEffect(DifferentialEffect effect) {
        this.effects.add(effect);
    }

    public Propagator getPropagator() {
        return this.reference;
    }

    public List<DifferentialEffect> getEffects() {
        return Collections.unmodifiableList(this.effects);
    }

    @Override
    public SpacecraftState getInitialState() throws PropagationException {
        return this.reference.getInitialState();
    }

    @Override
    public void resetInitialState(SpacecraftState state) throws PropagationException {
        this.reference.resetInitialState(state);
    }

    @Override
    protected SpacecraftState basicPropagate(AbsoluteDate date) throws PropagationException {
        try {
            SpacecraftState state = this.reference.propagate(date);
            Map<String, double[]> before = state.getAdditionalStates();
            for (DifferentialEffect differentialEffect : this.effects) {
                state = differentialEffect.apply(state);
            }
            for (Map.Entry entry : before.entrySet()) {
                if (state.hasAdditionalState((String)entry.getKey())) continue;
                state = state.addAdditionalState((String)entry.getKey(), (double[])entry.getValue());
            }
            return state;
        }
        catch (OrekitExceptionWrapper oew) {
            if (oew.getException() instanceof PropagationException) {
                throw (PropagationException)oew.getException();
            }
            throw new PropagationException(oew.getException());
        }
        catch (OrekitException oe) {
            if (oe instanceof PropagationException) {
                throw (PropagationException)oe;
            }
            throw new PropagationException(oe);
        }
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) throws PropagationException {
        return this.basicPropagate(date).getOrbit();
    }

    @Override
    protected double getMass(AbsoluteDate date) throws PropagationException {
        return this.basicPropagate(date).getMass();
    }

    public static interface DifferentialEffect {
        public SpacecraftState apply(SpacecraftState var1) throws OrekitException;
    }
}

