/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeFunction;
import org.orekit.utils.IERSConventions;

public class EclipticProvider
implements TransformProvider {
    private static final long serialVersionUID = 20140516L;
    private final IERSConventions conventions;
    private final transient TimeFunction<Double> obliquity;

    public EclipticProvider(IERSConventions conventions) throws OrekitException {
        this.conventions = conventions;
        this.obliquity = conventions.getMeanObliquityFunction();
    }

    @Override
    public Transform getTransform(AbsoluteDate date) throws OrekitException {
        double epsA = this.obliquity.value(date);
        return new Transform(date, new Rotation(Vector3D.MINUS_I, epsA));
    }

    private Object writeReplace() {
        return new DataTransferObject(this.conventions);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20140516L;
        private final IERSConventions conventions;

        public DataTransferObject(IERSConventions conventions) {
            this.conventions = conventions;
        }

        private Object readResolve() {
            try {
                return new EclipticProvider(this.conventions);
            }
            catch (OrekitException oe) {
                throw OrekitException.createInternalError(oe);
            }
        }
    }
}

