/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import org.orekit.errors.OrekitException;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.TimeStamped;

public class EOPEntry
implements TimeStamped,
Serializable {
    private static final long serialVersionUID = 20130924L;
    private final int mjd;
    private final AbsoluteDate date;
    private final double dt;
    private final double lod;
    private final double x;
    private final double y;
    private final double ddPsi;
    private final double ddEps;
    private final double dx;
    private final double dy;

    public EOPEntry(int mjd, double dt, double lod, double x, double y, double ddPsi, double ddEps, double dx, double dy) throws OrekitException {
        this.mjd = mjd;
        this.date = new AbsoluteDate(new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, mjd), (TimeScale)TimeScalesFactory.getUTC());
        this.dt = dt;
        this.lod = lod;
        this.x = x;
        this.y = y;
        this.ddPsi = ddPsi;
        this.ddEps = ddEps;
        this.dx = dx;
        this.dy = dy;
    }

    public int getMjd() {
        return this.mjd;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    public double getUT1MinusUTC() {
        return this.dt;
    }

    public double getLOD() {
        return this.lod;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getDdPsi() {
        return this.ddPsi;
    }

    public double getDdEps() {
        return this.ddEps;
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }
}

