/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import org.orekit.errors.OrekitException;
import org.orekit.forces.gravity.potential.GravityFieldFactory;
import org.orekit.forces.gravity.potential.NormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.time.AbsoluteDate;

class Normalizer
implements NormalizedSphericalHarmonicsProvider {
    private final UnnormalizedSphericalHarmonicsProvider unnormalized;
    private final double[][] factors;

    public Normalizer(UnnormalizedSphericalHarmonicsProvider unnormalized) throws OrekitException {
        this.unnormalized = unnormalized;
        this.factors = GravityFieldFactory.getUnnormalizationFactors(unnormalized.getMaxDegree(), unnormalized.getMaxOrder());
    }

    @Override
    public int getMaxDegree() {
        return this.unnormalized.getMaxDegree();
    }

    @Override
    public int getMaxOrder() {
        return this.unnormalized.getMaxOrder();
    }

    @Override
    public double getMu() {
        return this.unnormalized.getMu();
    }

    @Override
    public double getAe() {
        return this.unnormalized.getAe();
    }

    @Override
    public AbsoluteDate getReferenceDate() {
        return this.unnormalized.getReferenceDate();
    }

    @Override
    public double getOffset(AbsoluteDate date) {
        return this.unnormalized.getOffset(date);
    }

    @Override
    public TideSystem getTideSystem() {
        return this.unnormalized.getTideSystem();
    }

    @Override
    public NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics onDate(final AbsoluteDate date) throws OrekitException {
        final UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics = this.unnormalized.onDate(date);
        return new NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics(){

            @Override
            public AbsoluteDate getDate() {
                return date;
            }

            @Override
            public double getNormalizedCnm(int n, int m) throws OrekitException {
                return harmonics.getUnnormalizedCnm(n, m) / Normalizer.this.factors[n][m];
            }

            @Override
            public double getNormalizedSnm(int n, int m) throws OrekitException {
                return harmonics.getUnnormalizedSnm(n, m) / Normalizer.this.factors[n][m];
            }
        };
    }
}

