/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.FieldRotation;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.ode.AbstractParameterizable;
import org.apache.commons.math3.ode.UnknownParameterException;
import org.apache.commons.math3.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.forces.ForceModel;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class Relativity
extends AbstractParameterizable
implements ForceModel {
    private double gm;

    public Relativity(double gm) {
        super(new String[]{"central attraction coefficient"});
        this.gm = gm;
    }

    @Override
    public void addContribution(SpacecraftState s, TimeDerivativesEquations adder) throws OrekitException {
        TimeStampedPVCoordinates pv = s.getPVCoordinates();
        Vector3D p = pv.getPosition();
        Vector3D v = pv.getVelocity();
        double r2 = p.getNormSq();
        double r = FastMath.sqrt((double)r2);
        double s2 = v.getNormSq();
        double c2 = 8.987551787368176E16;
        Vector3D accel = new Vector3D(4.0 * this.gm / r - s2, p, 4.0 * p.dotProduct((Vector)v), v).scalarMultiply(this.gm / (r2 * r * 8.987551787368176E16));
        adder.addAcceleration(accel, s.getFrame());
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, FieldVector3D<DerivativeStructure> velocity, FieldRotation<DerivativeStructure> rotation, DerivativeStructure mass) {
        DerivativeStructure r2 = (DerivativeStructure)position.getNormSq();
        DerivativeStructure r = r2.sqrt();
        DerivativeStructure s2 = (DerivativeStructure)velocity.getNormSq();
        double c2 = 8.987551787368176E16;
        return new FieldVector3D((RealFieldElement)r.reciprocal().multiply(4.0 * this.gm).subtract(s2), position, (RealFieldElement)((DerivativeStructure)position.dotProduct(velocity)).multiply(4), velocity).scalarMultiply((RealFieldElement)r2.multiply(r).multiply(8.987551787368176E16).reciprocal().multiply(this.gm));
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(SpacecraftState s, String paramName) throws OrekitException {
        this.complainIfNotSupported(paramName);
        DerivativeStructure gmDS = new DerivativeStructure(1, 1, 0, this.gm);
        TimeStampedPVCoordinates pv = s.getPVCoordinates();
        Vector3D p = pv.getPosition();
        Vector3D v = pv.getVelocity();
        double r2 = p.getNormSq();
        double r = FastMath.sqrt((double)r2);
        double s2 = v.getNormSq();
        double c2 = 8.987551787368176E16;
        return new FieldVector3D((RealFieldElement)gmDS.multiply(4.0 / r).subtract(s2), p, (RealFieldElement)new DerivativeStructure(1, 1, 4.0 * p.dotProduct((Vector)v)), v).scalarMultiply((RealFieldElement)gmDS.divide(r2 * r * 8.987551787368176E16));
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return null;
    }

    public double getParameter(String name) throws UnknownParameterException {
        this.complainIfNotSupported(name);
        return this.gm;
    }

    public void setParameter(String name, double value) throws UnknownParameterException {
        this.complainIfNotSupported(name);
        this.gm = value;
    }
}

