/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.drag;

import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.drag.Atmosphere;
import org.orekit.forces.drag.JB2006InputParameters;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;

public class JB2006
implements Atmosphere {
    private static final long serialVersionUID = -4201270765122160831L;
    private static final double[] ALPHA = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, -0.38};
    private static final double AL10 = 2.3025851;
    private static final double[] AMW = new double[]{0.0, 28.0134, 31.9988, 15.9994, 39.948, 4.0026, 1.00797};
    private static final double AVOGAD = 6.02257E26;
    private static final double TWOPI = 6.2831853;
    private static final double PI = 3.1415927;
    private static final double PIOV2 = 1.5707963;
    private static final double[] FRAC = new double[]{0.0, 0.7811, 0.20955, 0.00934, 1.289E-5};
    private static final double RSTAR = 8314.32;
    private static final double R1 = 0.01;
    private static final double R2 = 0.025;
    private static final double R3 = 0.075;
    private static final double[] WT = new double[]{0.0, 0.311111111111111, 1.422222222222222, 0.533333333333333, 1.422222222222222, 0.311111111111111};
    private static final double[] CHT = new double[]{0.0, 0.22, -0.002, 0.00115, -2.11E-6};
    private static final double[] FZM = new double[]{0.0, 0.111613, -0.00159, 0.012619, -0.0100064, -2.37509E-5, 2.60759E-5};
    private static final double[] GTM = new double[]{0.0, -0.833646, -0.26545, 0.467603, -0.299906, -0.105451, -0.0165537, -0.0380037, -0.0150991, -0.054128, 0.0119554, 0.00437544, -0.00369016, 0.00206763, -0.00142888, -8.67124E-6, 1.89032E-5, 1.56988E-4, 4.91286E-4, -3.91484E-5, -1.26854E-5, 1.34078E-5, -6.14176E-6, 3.43423E-6};
    private static final double[] CXAMB = new double[]{0.0, 28.15204, -0.085586, 1.284E-4, -1.0056E-5, -1.021E-5, 1.5044E-6, 9.9826E-8};
    private static final double[] BDT_SUB = new double[]{0.0, -4.57512297, -5.12114909, -69.3003609, 203.716701, 703.316291, -1943.49234, 1106.51308, -174.378996, 1885.94601, -7093.71517, 9224.54523, -3845.08073, -6.45841789, 40.9703319, -482.00656, 1818.70931, -2373.89204, 996.703815, 36.1416936};
    private static final double[] CDT_SUB = new double[]{0.0, -15.5986211, -5.12114909, -69.3003609, 203.716701, 703.316291, -1943.49234, 1106.51308, -220.835117, 1432.56989, -3184.81844, 3289.81513, -1353.32119, 19.9956489, -12.7093998, 21.2825156, -2.75555432, 11.0234982, 148.881951, -751.640284, 637.876542, 12.7093998, -21.2825156, 2.75555432};
    private double[] temp = new double[3];
    private double rho;
    private PVCoordinatesProvider sun;
    private JB2006InputParameters inputParams;
    private BodyShape earth;

    public JB2006(JB2006InputParameters parameters, PVCoordinatesProvider sun, BodyShape earth) {
        this.earth = earth;
        this.sun = sun;
        this.inputParams = parameters;
    }

    @Override
    public Frame getFrame() {
        return this.earth.getBodyFrame();
    }

    public double getDensity(double dateMJD, double sunRA, double sunDecli, double satLon, double satLat, double satAlt, double f10, double f10B, double ap, double s10, double s10B, double xm10, double xm10B) {
        double[] TC;
        double TINF;
        double scaledSatAlt = satAlt / 1000.0;
        double tc = 379.0 + 3.353 * f10B + 0.358 * (f10 - f10B) + 2.094 * (s10 - s10B) + 0.343 * (xm10 - xm10B);
        double eta = 0.5 * FastMath.abs((double)(satLat - sunDecli));
        double theta = 0.5 * FastMath.abs((double)(satLat + sunDecli));
        double h = satLon - sunRA;
        double tau = h - 0.64577182 + 0.10471976 * FastMath.sin((double)(h + 0.75049158));
        double solTimeHour = FastMath.toDegrees((double)(h + 3.1415927)) / 15.0;
        if (solTimeHour >= 24.0) {
            solTimeHour -= 24.0;
        }
        if (solTimeHour < 0.0) {
            solTimeHour += 24.0;
        }
        double C = FastMath.pow((double)FastMath.cos((double)eta), (double)2.5);
        double S = FastMath.pow((double)FastMath.sin((double)theta), (double)2.5);
        double tmp = FastMath.abs((double)FastMath.cos((double)(0.5 * tau)));
        double DF = S + (C - S) * tmp * tmp * tmp;
        double TSUBL = tc * (1.0 + 0.31 * DF);
        double EXPAP = FastMath.exp((double)(-0.08 * ap));
        double DTG = ap + 100.0 * (1.0 - EXPAP);
        double DTCLST = JB2006.dTc(f10, solTimeHour, satLat, scaledSatAlt);
        this.temp[1] = TINF = TSUBL + DTG + DTCLST;
        double TSUBX = 444.3807 + 0.02385 * TINF - 392.8292 * FastMath.exp((double)(-0.0021357 * TINF));
        double GSUBX = 0.054285714 * (TSUBX - 183.0);
        TC = new double[]{TSUBX, GSUBX, (TINF - TSUBX) / 1.5707963, GSUBX / TC[2]};
        double Z1 = 90.0;
        double Z2 = FastMath.min((double)scaledSatAlt, (double)105.0);
        double AL = FastMath.log((double)(Z2 / 90.0));
        int N = (int)FastMath.floor((double)(AL / 0.01)) + 1;
        double ZR = FastMath.exp((double)(AL / (double)N));
        double AMBAR1 = JB2006.xAmbar(90.0);
        double TLOC1 = JB2006.xLocal(90.0, TC);
        double ZEND = 90.0;
        double SUM2 = 0.0;
        double AIN = AMBAR1 * JB2006.xGrav(90.0) / TLOC1;
        double AMBAR2 = 0.0;
        double TLOC2 = 0.0;
        double Z = 0.0;
        double GRAVL = 0.0;
        for (int i = 1; i <= N; ++i) {
            Z = ZEND;
            ZEND = ZR * Z;
            double DZ = 0.25 * (ZEND - Z);
            double SUM1 = WT[1] * AIN;
            for (int j = 2; j <= 5; ++j) {
                AMBAR2 = JB2006.xAmbar(Z += DZ);
                TLOC2 = JB2006.xLocal(Z, TC);
                GRAVL = JB2006.xGrav(Z);
                AIN = AMBAR2 * GRAVL / TLOC2;
                SUM1 += WT[j] * AIN;
            }
            SUM2 += DZ * SUM1;
        }
        double FACT1 = 0.12027441811236518;
        this.rho = 3.46E-6 * AMBAR2 * TLOC1 * FastMath.exp((double)(-0.12027441811236518 * SUM2)) / (AMBAR1 * TLOC2);
        double ANM = 6.02257E26 * this.rho;
        double AN = ANM / AMBAR2;
        double FACT2 = ANM / 28.96;
        double[] ALN = new double[7];
        ALN[1] = FastMath.log((double)(FRAC[1] * FACT2));
        ALN[4] = FastMath.log((double)(FRAC[3] * FACT2));
        ALN[5] = FastMath.log((double)(FRAC[4] * FACT2));
        ALN[2] = FastMath.log((double)(FACT2 * (1.0 + FRAC[2]) - AN));
        ALN[3] = FastMath.log((double)(2.0 * (AN - FACT2)));
        if (scaledSatAlt <= 105.0) {
            this.temp[2] = TLOC2;
            ALN[6] = ALN[5] - 25.0;
        } else {
            double HSIGN;
            double ALTR;
            double Z3 = FastMath.min((double)scaledSatAlt, (double)500.0);
            AL = FastMath.log((double)(Z3 / Z));
            N = (int)FastMath.floor((double)(AL / 0.025)) + 1;
            ZR = FastMath.exp((double)(AL / (double)N));
            SUM2 = 0.0;
            AIN = GRAVL / TLOC2;
            double TLOC3 = 0.0;
            for (int I = 1; I <= N; ++I) {
                Z = ZEND;
                ZEND = ZR * Z;
                double DZ = 0.25 * (ZEND - Z);
                double SUM1 = WT[1] * AIN;
                for (int J = 2; J <= 5; ++J) {
                    TLOC3 = JB2006.xLocal(Z += DZ, TC);
                    GRAVL = JB2006.xGrav(Z);
                    AIN = GRAVL / TLOC3;
                    SUM1 += WT[J] * AIN;
                }
                SUM2 += DZ * SUM1;
            }
            double Z4 = FastMath.max((double)scaledSatAlt, (double)500.0);
            AL = FastMath.log((double)(Z4 / Z));
            double R = 0.025;
            if (scaledSatAlt > 500.0) {
                R = 0.075;
            }
            N = (int)FastMath.floor((double)(AL / R)) + 1;
            ZR = FastMath.exp((double)(AL / (double)N));
            double SUM3 = 0.0;
            double TLOC4 = 0.0;
            for (int I = 1; I <= N; ++I) {
                Z = ZEND;
                ZEND = ZR * Z;
                double DZ = 0.25 * (ZEND - Z);
                double SUM1 = WT[1] * AIN;
                for (int J = 2; J <= 5; ++J) {
                    TLOC4 = JB2006.xLocal(Z += DZ, TC);
                    GRAVL = JB2006.xGrav(Z);
                    AIN = GRAVL / TLOC4;
                    SUM1 += WT[J] * AIN;
                }
                SUM3 += DZ * SUM1;
            }
            if (scaledSatAlt <= 500.0) {
                this.temp[2] = TLOC3;
                ALTR = FastMath.log((double)(TLOC3 / TLOC2));
                FACT2 = 0.12027441811236518 * SUM2;
                HSIGN = 1.0;
            } else {
                this.temp[2] = TLOC4;
                ALTR = FastMath.log((double)(TLOC4 / TLOC2));
                FACT2 = 0.12027441811236518 * (SUM2 + SUM3);
                HSIGN = -1.0;
            }
            for (int I = 1; I <= 5; ++I) {
                ALN[I] = ALN[I] - (1.0 + ALPHA[I]) * ALTR - FACT2 * AMW[I];
            }
            double AL10T5 = FastMath.log((double)TINF) / FastMath.log((double)10.0);
            double ALNH5 = (5.5 * AL10T5 - 39.4) * AL10T5 + 73.13;
            ALN[6] = 2.3025851 * (ALNH5 + 6.0) + HSIGN * (FastMath.log((double)(TLOC4 / TLOC3)) + 0.12027441811236518 * SUM3 * AMW[6]);
        }
        double CAPPHI = (dateMJD - 36204.0) / 365.2422 % 1.0;
        int signum = satLat >= 0.0 ? 1 : -1;
        double sinLat = FastMath.sin((double)satLat);
        double DLRSL = 0.02 * (scaledSatAlt - 90.0) * FastMath.exp((double)(-0.045 * (scaledSatAlt - 90.0))) * (double)signum * FastMath.sin((double)(6.2831853 * CAPPHI + 1.72)) * sinLat * sinLat;
        double DLRSA = 0.0;
        if (Z < 2000.0) {
            double D1950 = dateMJD - 33281.0;
            DLRSA = JB2006.semian(JB2006.dayOfYear(D1950), scaledSatAlt, f10B);
        }
        double DLR = 2.3025851 * (DLRSL + DLRSA);
        int i = 1;
        while (i <= 6) {
            int n = i++;
            ALN[n] = ALN[n] + DLR;
        }
        double SUMNM = 0.0;
        for (int I = 1; I <= 6; ++I) {
            AN = FastMath.exp((double)ALN[I]);
            SUMNM += AN * AMW[I];
        }
        this.rho = SUMNM / 6.02257E26;
        double FEX = 1.0;
        if (scaledSatAlt >= 1000.0 && scaledSatAlt < 1500.0) {
            double ZETA = (scaledSatAlt - 1000.0) * 0.002;
            double ZETA2 = ZETA * ZETA;
            double ZETA3 = ZETA * ZETA2;
            double F15C = CHT[1] + CHT[2] * f10B + CHT[3] * 1500.0 + CHT[4] * f10B * 1500.0;
            double F15C_ZETA = (CHT[3] + CHT[4] * f10B) * 500.0;
            double FEX2 = 3.0 * F15C - F15C_ZETA - 3.0;
            double FEX3 = F15C_ZETA - 2.0 * F15C + 2.0;
            FEX = 1.0 + FEX2 * ZETA2 + FEX3 * ZETA3;
        }
        if (scaledSatAlt >= 1500.0) {
            FEX = CHT[1] + CHT[2] * f10B + CHT[3] * scaledSatAlt + CHT[4] * f10B * scaledSatAlt;
        }
        this.rho *= FEX;
        return this.rho;
    }

    private static double dTc(double f10, double solTimeHour, double satLat, double satAlt) {
        double DD;
        double CC;
        double h;
        double sum;
        double dTc = 0.0;
        double tx = solTimeHour / 24.0;
        double tx2 = tx * tx;
        double tx3 = tx2 * tx;
        double tx4 = tx3 * tx;
        double tx5 = tx4 * tx;
        double ycs = FastMath.cos((double)satLat);
        double f = (f10 - 100.0) / 100.0;
        if (satAlt >= 120.0 && satAlt <= 200.0) {
            double DTC200 = CDT_SUB[17] + CDT_SUB[18] * tx * ycs + CDT_SUB[19] * tx2 * ycs + CDT_SUB[20] * tx3 * ycs + CDT_SUB[21] * f * ycs + CDT_SUB[22] * tx * f * ycs + CDT_SUB[23] * tx2 * f * ycs;
            double DTC200DZ = sum = CDT_SUB[1] + BDT_SUB[2] * f + CDT_SUB[3] * tx * f + CDT_SUB[4] * tx2 * f + CDT_SUB[5] * tx3 * f + CDT_SUB[6] * tx4 * f + CDT_SUB[7] * tx5 * f + CDT_SUB[8] * tx * ycs + CDT_SUB[9] * tx2 * ycs + CDT_SUB[10] * tx3 * ycs + CDT_SUB[11] * tx4 * ycs + CDT_SUB[12] * tx5 * ycs + CDT_SUB[13] * ycs + CDT_SUB[14] * f * ycs + CDT_SUB[15] * tx * f * ycs + CDT_SUB[16] * tx2 * f * ycs;
            double CC2 = 3.0 * DTC200 - DTC200DZ;
            double DD2 = DTC200 - CC2;
            double ZP = (satAlt - 120.0) / 80.0;
            dTc = CC2 * ZP * ZP + DD2 * ZP * ZP * ZP;
        }
        if (satAlt > 200.0 && satAlt <= 240.0) {
            h = (satAlt - 200.0) / 50.0;
            dTc = sum = CDT_SUB[1] * h + BDT_SUB[2] * f * h + CDT_SUB[3] * tx * f * h + CDT_SUB[4] * tx2 * f * h + CDT_SUB[5] * tx3 * f * h + CDT_SUB[6] * tx4 * f * h + CDT_SUB[7] * tx5 * f * h + CDT_SUB[8] * tx * ycs * h + CDT_SUB[9] * tx2 * ycs * h + CDT_SUB[10] * tx3 * ycs * h + CDT_SUB[11] * tx4 * ycs * h + CDT_SUB[12] * tx5 * ycs * h + CDT_SUB[13] * ycs * h + CDT_SUB[14] * f * ycs * h + CDT_SUB[15] * tx * f * ycs * h + CDT_SUB[16] * tx2 * f * ycs * h + CDT_SUB[17] + CDT_SUB[18] * tx * ycs + CDT_SUB[19] * tx2 * ycs + CDT_SUB[20] * tx3 * ycs + CDT_SUB[21] * f * ycs + CDT_SUB[22] * tx * f * ycs + CDT_SUB[23] * tx2 * f * ycs;
        }
        if (satAlt > 240.0 && satAlt <= 300.0) {
            h = 0.8;
            double AA = sum = CDT_SUB[1] * h + BDT_SUB[2] * f * h + CDT_SUB[3] * tx * f * h + CDT_SUB[4] * tx2 * f * h + CDT_SUB[5] * tx3 * f * h + CDT_SUB[6] * tx4 * f * h + CDT_SUB[7] * tx5 * f * h + CDT_SUB[8] * tx * ycs * h + CDT_SUB[9] * tx2 * ycs * h + CDT_SUB[10] * tx3 * ycs * h + CDT_SUB[11] * tx4 * ycs * h + CDT_SUB[12] * tx5 * ycs * h + CDT_SUB[13] * ycs * h + CDT_SUB[14] * f * ycs * h + CDT_SUB[15] * tx * f * ycs * h + CDT_SUB[16] * tx2 * f * ycs * h + CDT_SUB[17] + CDT_SUB[18] * tx * ycs + CDT_SUB[19] * tx2 * ycs + CDT_SUB[20] * tx3 * ycs + CDT_SUB[21] * f * ycs + CDT_SUB[22] * tx * f * ycs + CDT_SUB[23] * tx2 * f * ycs;
            double BB = CDT_SUB[1] + BDT_SUB[2] * f + CDT_SUB[3] * tx * f + CDT_SUB[4] * tx2 * f + CDT_SUB[5] * tx3 * f + CDT_SUB[6] * tx4 * f + CDT_SUB[7] * tx5 * f + CDT_SUB[8] * tx * ycs + CDT_SUB[9] * tx2 * ycs + CDT_SUB[10] * tx3 * ycs + CDT_SUB[11] * tx4 * ycs + CDT_SUB[12] * tx5 * ycs + CDT_SUB[13] * ycs + CDT_SUB[14] * f * ycs + CDT_SUB[15] * tx * f * ycs + CDT_SUB[16] * tx2 * f * ycs;
            h = 3.0;
            double DTC300 = sum = BDT_SUB[1] + BDT_SUB[2] * f + BDT_SUB[3] * tx * f + BDT_SUB[4] * tx2 * f + BDT_SUB[5] * tx3 * f + BDT_SUB[6] * tx4 * f + BDT_SUB[7] * tx5 * f + BDT_SUB[8] * tx * ycs + BDT_SUB[9] * tx2 * ycs + BDT_SUB[10] * tx3 * ycs + BDT_SUB[11] * tx4 * ycs + BDT_SUB[12] * tx5 * ycs + BDT_SUB[13] * h * ycs + BDT_SUB[14] * tx * h * ycs + BDT_SUB[15] * tx2 * h * ycs + BDT_SUB[16] * tx3 * h * ycs + BDT_SUB[17] * tx4 * h * ycs + BDT_SUB[18] * tx5 * h * ycs + BDT_SUB[19] * ycs;
            double DTC300DZ = sum = BDT_SUB[13] * ycs + BDT_SUB[14] * tx * ycs + BDT_SUB[15] * tx2 * ycs + BDT_SUB[16] * tx3 * ycs + BDT_SUB[17] * tx4 * ycs + BDT_SUB[18] * tx5 * ycs;
            CC = 3.0 * DTC300 - DTC300DZ - 3.0 * AA - 2.0 * BB;
            DD = DTC300 - AA - BB - CC;
            double ZP = (satAlt - 240.0) / 60.0;
            dTc = AA + BB * ZP + CC * ZP * ZP + DD * ZP * ZP * ZP;
        }
        if (satAlt > 300.0 && satAlt <= 600.0) {
            h = satAlt / 100.0;
            dTc = sum = BDT_SUB[1] + BDT_SUB[2] * f + BDT_SUB[3] * tx * f + BDT_SUB[4] * tx2 * f + BDT_SUB[5] * tx3 * f + BDT_SUB[6] * tx4 * f + BDT_SUB[7] * tx5 * f + BDT_SUB[8] * tx * ycs + BDT_SUB[9] * tx2 * ycs + BDT_SUB[10] * tx3 * ycs + BDT_SUB[11] * tx4 * ycs + BDT_SUB[12] * tx5 * ycs + BDT_SUB[13] * h * ycs + BDT_SUB[14] * tx * h * ycs + BDT_SUB[15] * tx2 * h * ycs + BDT_SUB[16] * tx3 * h * ycs + BDT_SUB[17] * tx4 * h * ycs + BDT_SUB[18] * tx5 * h * ycs + BDT_SUB[19] * ycs;
        }
        if (satAlt > 600.0 && satAlt <= 800.0) {
            double ZP = (satAlt - 600.0) / 100.0;
            double HP = 6.0;
            double AA = BDT_SUB[1] + BDT_SUB[2] * f + BDT_SUB[3] * tx * f + BDT_SUB[4] * tx2 * f + BDT_SUB[5] * tx3 * f + BDT_SUB[6] * tx4 * f + BDT_SUB[7] * tx5 * f + BDT_SUB[8] * tx * ycs + BDT_SUB[9] * tx2 * ycs + BDT_SUB[10] * tx3 * ycs + BDT_SUB[11] * tx4 * ycs + BDT_SUB[12] * tx5 * ycs + BDT_SUB[13] * 6.0 * ycs + BDT_SUB[14] * tx * 6.0 * ycs + BDT_SUB[15] * tx2 * 6.0 * ycs + BDT_SUB[16] * tx3 * 6.0 * ycs + BDT_SUB[17] * tx4 * 6.0 * ycs + BDT_SUB[18] * tx5 * 6.0 * ycs + BDT_SUB[19] * ycs;
            double BB = BDT_SUB[13] * ycs + BDT_SUB[14] * tx * ycs + BDT_SUB[15] * tx2 * ycs + BDT_SUB[16] * tx3 * ycs + BDT_SUB[17] * tx4 * ycs + BDT_SUB[18] * tx5 * ycs;
            CC = -(3.0 * AA + 4.0 * BB) / 4.0;
            DD = (AA + BB) / 4.0;
            dTc = AA + BB * ZP + CC * ZP * ZP + DD * ZP * ZP * ZP;
        }
        return dTc;
    }

    private static double xAmbar(double z) {
        double dz = z - 100.0;
        double amb = CXAMB[7];
        for (int i = 6; i >= 1; --i) {
            amb = dz * amb + CXAMB[i];
        }
        return amb;
    }

    private static double xLocal(double z, double[] TC) {
        double dz = z - 125.0;
        if (dz <= 0.0) {
            return ((-9.8204695E-6 * dz - 7.3039742E-4) * dz * dz + 1.0) * dz * TC[1] + TC[0];
        }
        return TC[0] + TC[2] * FastMath.atan((double)(TC[3] * dz * (1.0 + 4.5E-6 * FastMath.pow((double)dz, (double)2.5))));
    }

    private static double xGrav(double z) {
        double temp = 1.0 + z / 6356.766;
        return 9.80665 / (temp * temp);
    }

    private static double semian(double day, double height, double f10Bar) {
        double f10Bar2 = f10Bar * f10Bar;
        double htz = height / 1000.0;
        double fzz = FZM[1] + FZM[2] * f10Bar + FZM[3] * f10Bar * htz + FZM[4] * f10Bar * htz * htz + FZM[5] * f10Bar * f10Bar * htz + FZM[6] * f10Bar * f10Bar * htz * htz;
        double tau = 6.2831853 * (day - 1.0) / 365.0;
        double sin1P = FastMath.sin((double)tau);
        double cos1P = FastMath.cos((double)tau);
        double sin2P = FastMath.sin((double)(2.0 * tau));
        double cos2P = FastMath.cos((double)(2.0 * tau));
        double sin3P = FastMath.sin((double)(3.0 * tau));
        double cos3P = FastMath.cos((double)(3.0 * tau));
        double sin4P = FastMath.sin((double)(4.0 * tau));
        double cos4P = FastMath.cos((double)(4.0 * tau));
        double gtz = GTM[1] + GTM[2] * sin1P + GTM[3] * cos1P + GTM[4] * sin2P + GTM[5] * cos2P + GTM[6] * sin3P + GTM[7] * cos3P + GTM[8] * sin4P + GTM[9] * cos4P + GTM[10] * f10Bar + GTM[11] * f10Bar * sin1P + GTM[12] * f10Bar * cos1P + GTM[13] * f10Bar * sin2P + GTM[14] * f10Bar * cos2P + GTM[15] * f10Bar * sin3P + GTM[16] * f10Bar * cos3P + GTM[17] * f10Bar * sin4P + GTM[18] * f10Bar * cos4P + GTM[19] * f10Bar2 + GTM[20] * f10Bar2 * sin1P + GTM[21] * f10Bar2 * cos1P + GTM[22] * f10Bar2 * sin2P + GTM[23] * f10Bar2 * cos2P;
        return FastMath.max((double)1.0E-6, (double)fzz) * gtz;
    }

    private static double dayOfYear(double d1950) {
        int iyday = (int)d1950;
        double frac = d1950 - (double)iyday;
        int itemp = (iyday += 364) / 1461;
        if ((itemp = (iyday -= itemp * 1461) / 365) >= 3) {
            itemp = 3;
        }
        iyday = iyday - 365 * itemp + 1;
        return (double)iyday + frac;
    }

    public double getExosphericTemp() {
        return this.temp[1];
    }

    public double getLocalTemp() {
        return this.temp[2];
    }

    @Override
    public double getDensity(AbsoluteDate date, Vector3D position, Frame frame) throws OrekitException {
        if (date.compareTo(this.inputParams.getMaxDate()) > 0 || date.compareTo(this.inputParams.getMinDate()) < 0) {
            throw new OrekitException((Localizable)OrekitMessages.NO_SOLAR_ACTIVITY_AT_DATE, date, this.inputParams.getMinDate(), this.inputParams.getMaxDate());
        }
        double dateMJD = date.durationFrom(AbsoluteDate.MODIFIED_JULIAN_EPOCH) / 86400.0;
        GeodeticPoint inBody = this.earth.transform(position, frame, date);
        GeodeticPoint sunInBody = this.earth.transform(this.sun.getPVCoordinates(date, frame).getPosition(), frame, date);
        return this.getDensity(dateMJD, sunInBody.getLongitude(), sunInBody.getLatitude(), inBody.getLongitude(), inBody.getLatitude(), inBody.getAltitude(), this.inputParams.getF10(date), this.inputParams.getF10B(date), this.inputParams.getAp(date), this.inputParams.getS10(date), this.inputParams.getS10B(date), this.inputParams.getXM10(date), this.inputParams.getXM10B(date));
    }

    @Override
    public Vector3D getVelocity(AbsoluteDate date, Vector3D position, Frame frame) throws OrekitException {
        Transform bodyToFrame = this.earth.getBodyFrame().getTransformTo(frame, date);
        Vector3D posInBody = bodyToFrame.getInverse().transformPosition(position);
        PVCoordinates pvBody = new PVCoordinates(posInBody, new Vector3D(0.0, 0.0, 0.0));
        PVCoordinates pvFrame = bodyToFrame.transformPVCoordinates(pvBody);
        return pvFrame.getVelocity();
    }
}

